/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.SASLogical;

import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import SASKernel.SASPhysical.SASPhysicalDriveOperationsAllowed;
import Services.KernelConstants;
import java.util.ArrayList;
import java.util.Iterator;

public class SASLogicalDriveOperationsAllowed {
    private boolean startFGI = false;
    private boolean stopFGI = false;
    private boolean startCC = false;
    private boolean stopCC = false;
    private boolean startRecon = false;
    private boolean deleteLD = false;
    private boolean secure = false;
    private boolean enableSnapshot = false;
    private boolean disableSnapshot = false;
    private boolean rollbackPIT = false;
    private boolean createPITView = false;
    private boolean deleteView = false;
    private boolean enableAutoSnapshot = false;
    private boolean disableAutoSnapshot = false;
    private boolean SSCCacheable = false;
    private boolean breakMirror = false;
    private boolean joinMirror = false;
    private boolean forceDeleteLD = false;
    private boolean suspendCCBGI = false;
    private boolean resumeCCBGI = false;
    private boolean suspendRecon = false;
    private boolean resumeRecon = false;
    private boolean startSecureEraseNonSED;
    private boolean stopSecureEraseNonSED;
    private boolean fullFGDisallow;
    private boolean disassociatedSSC = false;
    private boolean disablePI = false;
    private boolean enableHAShare = false;
    private SASLogicalDrive sasLDrive;

    public SASLogicalDriveOperationsAllowed(SASLogicalDrive sASLogicalDrive, int n) {
        this.update(sASLogicalDrive, n);
    }

    public void update(SASLogicalDrive sASLogicalDrive, int n) {
        this.sasLDrive = sASLogicalDrive;
        this.startFGI = KernelConstants.getBitValue(n, 0) != 0;
        this.stopFGI = KernelConstants.getBitValue(n, 1) != 0;
        this.startCC = KernelConstants.getBitValue(n, 2) != 0;
        this.stopCC = KernelConstants.getBitValue(n, 3) != 0;
        this.startRecon = KernelConstants.getBitValue(n, 4) != 0;
        this.deleteLD = KernelConstants.getBitValue(n, 5) != 0;
        this.secure = KernelConstants.getBitValue(n, 6) != 0;
        this.enableSnapshot = KernelConstants.getBitValue(n, 7) != 0;
        this.disableSnapshot = KernelConstants.getBitValue(n, 8) != 0;
        this.rollbackPIT = KernelConstants.getBitValue(n, 9) != 0;
        this.createPITView = KernelConstants.getBitValue(n, 10) != 0;
        this.deleteView = KernelConstants.getBitValue(n, 11) != 0;
        this.enableAutoSnapshot = KernelConstants.getBitValue(n, 12) != 0;
        this.disableAutoSnapshot = KernelConstants.getBitValue(n, 13) != 0;
        this.SSCCacheable = KernelConstants.getBitValue(n, 14) != 0;
        this.breakMirror = KernelConstants.getBitValue(n, 15) != 0;
        this.joinMirror = KernelConstants.getBitValue(n, 16) != 0;
        this.forceDeleteLD = KernelConstants.getBitValue(n, 23) != 0;
        this.joinMirror = KernelConstants.getBitValue(n, 16) != 0;
        this.suspendCCBGI = KernelConstants.getBitValue(n, 17) != 0;
        this.resumeCCBGI = KernelConstants.getBitValue(n, 18) != 0;
        this.suspendRecon = KernelConstants.getBitValue(n, 19) != 0;
        this.resumeRecon = KernelConstants.getBitValue(n, 20) != 0;
        this.startSecureEraseNonSED = KernelConstants.getBitValue(n, 21) != 0;
        this.stopSecureEraseNonSED = KernelConstants.getBitValue(n, 22) != 0;
        this.fullFGDisallow = KernelConstants.getBitValue(n, 24) != 0;
        this.disassociatedSSC = KernelConstants.getBitValue(n, 25) != 0;
        this.disablePI = KernelConstants.getBitValue(n, 26) != 0;
        this.enableHAShare = KernelConstants.getBitValue(n, 27) != 0;
    }

    public boolean isStartFGI() {
        return this.startFGI;
    }

    public boolean isStopFGI() {
        return this.stopFGI;
    }

    public boolean isStartCC() {
        return this.startCC;
    }

    public boolean isStopCC() {
        return this.stopCC;
    }

    public boolean isStartRecon() {
        if (((SASAdapter)this.sasLDrive.parent()).getAdapterType() == 3 || ((SASAdapter)this.sasLDrive.parent()).getAdapterType() == 4) {
            return this.startRecon && ((SASAdapter)this.sasLDrive.parent()).getInformation().getadapterOperations_MR_CTRL_INFO().isSupportOCEwithNoDriveAddition();
        }
        try {
            MR_MFC_DEFAULTS mR_MFC_DEFAULTS = ((SASAdapter)this.sasLDrive.parent()).getMFCDefaults();
            if (this.sasLDrive.getRAIDLevelInfo().getPRL() == 17 && mR_MFC_DEFAULTS.gettreatR1EAsR10() == 1) {
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.startRecon;
    }

    public boolean isDeleteLD() {
        return this.deleteLD;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isEnableSnapshot() {
        return this.enableSnapshot;
    }

    public boolean isDisableSnapshot() {
        return this.disableSnapshot;
    }

    public boolean isRollbackPIT() {
        return this.rollbackPIT;
    }

    public boolean isCreatePITView() {
        return this.createPITView;
    }

    public boolean isDeleteView() {
        return this.deleteView;
    }

    public boolean isEnableAutoSnapshot() {
        return this.enableAutoSnapshot;
    }

    public boolean isDisableAutoSnapshot() {
        return this.disableAutoSnapshot;
    }

    public boolean isSSCCacheable() {
        return this.SSCCacheable;
    }

    public boolean canbreakMirror() {
        return this.breakMirror;
    }

    public boolean canjoinMirror() {
        return this.joinMirror;
    }

    public boolean isForceDeleteLD() {
        return this.forceDeleteLD;
    }

    public boolean isdisassociatedSSC() {
        return this.disassociatedSSC;
    }

    public boolean issuspendCCBGI() {
        return this.suspendCCBGI;
    }

    public boolean isresumeCCBGI() {
        return this.resumeCCBGI;
    }

    public boolean issuspendRecon() {
        return this.suspendRecon;
    }

    public boolean isresumeRecon() {
        return this.resumeRecon;
    }

    public boolean canStartSecureEraseNonSED() {
        return this.startSecureEraseNonSED;
    }

    public boolean canStopSecureEraseNonSED() {
        return this.stopSecureEraseNonSED;
    }

    public boolean canfullFGDisallow() {
        return this.fullFGDisallow;
    }

    public boolean isPIDisable() {
        return this.disablePI;
    }

    public boolean isEnableHAShare() {
        return this.enableHAShare;
    }

    public void setEnableHAShare(boolean bl) {
        this.enableHAShare = bl;
    }

    public boolean isOperationAllowed(int n) {
        SASAdapter sASAdapter = (SASAdapter)this.sasLDrive.parent();
        if (sASAdapter.isWarhawk()) {
            return n == 1;
        }
        switch (n) {
            case 3: {
                if (this.sasLDrive.getInformation().getldConfig().getparams().getSnapshotEnabled() == 1) {
                    return true;
                }
                return this.isDeleteLD();
            }
            case 10: {
                return this.isStopFGI();
            }
            case 7: {
                return this.isStopCC();
            }
            case 6: {
                return this.isStartCC();
            }
            case 9: {
                return this.isStartFGI();
            }
            case 2: {
                int n2 = 1;
                try {
                    n2 = ((SASAdapter)this.sasLDrive.parent()).getInformation().getldOperations_MR_CTRL_INFO().getdiskCachePolicy();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (this.sasLDrive.getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getrecon()) {
                    return false;
                }
                return !sASAdapter.isWarhawk() || n2 != 0;
            }
            case 14: {
                return true;
            }
            case 12: {
                return this.isStartRecon();
            }
            case 13: {
                return this.sasLDrive.getInformation().getprogInfo().getactive_MR_LD_PROGRESS1().getrecon();
            }
            case 15: {
                return true;
            }
            case 0x30C0000: {
                return this.secure;
            }
            case 0x3110100: {
                this.canbreakMirror();
            }
            case 0x3110300: {
                this.canjoinMirror();
            }
            case 51314944: {
                return this.isEnableSnapshot();
            }
            case 51315200: {
                return this.isDisableSnapshot();
            }
            case 51316480: {
                return this.isRollbackPIT();
            }
            case 0x30F0300: 
            case 51315968: {
                return this.isCreatePITView();
            }
            case 4: 
            case 5: {
                ArrayList arrayList = this.sasLDrive.getConstituentPDList();
                boolean bl = false;
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    try {
                        SASPhysicalDriveOperationsAllowed sASPhysicalDriveOperationsAllowed = ((SASPhysicalDrive)iterator.next()).getAllAllowedOperations();
                        if (!sASPhysicalDriveOperationsAllowed.isStartLocate()) continue;
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                return bl;
            }
        }
        return true;
    }
}

