/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.SASPhysical;

import Framework.Network.VivaldiFrameworkProtocolErrorException;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.AENHandlerInterface;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_ENCL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_ENCL_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_PD_ADDRESS;
import SASKernel.LibraryAPI.StoreLib.SL_ENCL_STATUS_EX_T;
import SASKernel.LibraryAPI.StoreLib.SL_ENCL_STATUS_T;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDevice;
import Services.NetworkDataPacket;
import Services.NetworkToJavaConverter;
import java.io.IOException;

public class SASEnclosure
extends SASPhysicalDevice
implements ISASObject,
AENHandlerInterface {
    private SL_ENCL_STATUS_T m_EnclStatusT = null;
    private SL_ENCL_STATUS_EX_T m_EnclStatusExT = null;
    private MR_ENCL_LIST m_enclList = null;
    private MR_ENCL_INFO m_virtualEnclInfo = null;
    private SASAdapter m_sasAdapter = null;
    private int m_latestSeqNumber = -1;
    private NotifyObject m_nObj = null;

    public SASEnclosure(short s, short s2, ISASObject iSASObject, MR_PD_ADDRESS mR_PD_ADDRESS) throws VKNotRespondingException, VKOperationFailedException {
        super(s, s2, (SASAdapter)iSASObject, mR_PD_ADDRESS);
        this.m_sasAdapter = (SASAdapter)iSASObject;
        this.refresh();
    }

    @Override
    public short getID() {
        return super.getID();
    }

    @Override
    public short getSeqNum() {
        return super.getInformation().getref().getseqNum();
    }

    @Override
    public ISASObject next() {
        return super.next();
    }

    @Override
    public ISASObject previous() {
        return super.previous();
    }

    @Override
    public ISASObject parent() {
        return super.parent();
    }

    @Override
    public boolean refresh() throws VKNotRespondingException, VKOperationFailedException {
        super.refresh();
        try {
            OperationDetails operationDetails = new OperationDetails(5, null);
            ((SASAdapter)this.parent()).fireOperation(operationDetails);
            this.m_enclList = (MR_ENCL_LIST)operationDetails.getParam();
            this.m_virtualEnclInfo = this.m_enclList.getEnclosure(this.getDeviceId());
            if (this.getInformation().getscsiDevType() != '\u001f') {
                byte[] byArray = new byte[8];
                NetworkToJavaConverter.shortTobyteArray(this.getDeviceId(), byArray, 0);
                SimpleCommandPacket simpleCommandPacket = new SimpleCommandPacket(8, 1, ((SASAdapter)this.parent()).getCtrlID(), byArray, 1028);
                NetworkDataPacket networkDataPacket = new NetworkDataPacket(simpleCommandPacket.getByteArray());
                this.processCommand(networkDataPacket);
                byte[] byArray2 = networkDataPacket.getDataBuffer();
                int n = NetworkToJavaConverter.byteArrayToInt(byArray2);
                if (n != 0) {
                    throw new VKOperationFailedException(n);
                }
                if (this.m_EnclStatusT == null) {
                    this.m_EnclStatusT = new SL_ENCL_STATUS_T(byArray2, 44, this.m_virtualEnclInfo);
                } else {
                    this.m_EnclStatusT.update(byArray2, 44, this.m_virtualEnclInfo);
                }
            } else {
                if (this.m_EnclStatusT == null) {
                    this.m_EnclStatusT = new SL_ENCL_STATUS_T(new byte[76], 0, this.m_virtualEnclInfo);
                } else {
                    this.m_EnclStatusT.update(new byte[76], 0, this.m_virtualEnclInfo);
                }
                this.populateSL_ENCL_STATUS_TfromMR_ENCL_INFO(this.m_EnclStatusT, this.m_virtualEnclInfo);
            }
        }
        catch (IOException iOException) {
            throw new VKOperationFailedException(4096);
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            throw new VKOperationFailedException(4096);
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            throw new VKOperationFailedException(4096);
        }
        return false;
    }

    public SL_ENCL_STATUS_T getStatusInformation() {
        return this.m_EnclStatusT;
    }

    public SL_ENCL_STATUS_EX_T getEnclosureStatusExT() {
        if (this.m_EnclStatusExT == null) {
            this.updateEnclosureStatusExT();
        }
        return this.m_EnclStatusExT;
    }

    public void updateEnclosureStatusExT() {
        try {
            if (this.getInformation().getscsiDevType() != '\u001f') {
                byte[] byArray = new byte[8];
                NetworkToJavaConverter.shortTobyteArray(this.getDeviceId(), byArray, 0);
                SimpleCommandPacket simpleCommandPacket = new SimpleCommandPacket(8, 5, ((SASAdapter)this.parent()).getCtrlID(), byArray, 2052);
                NetworkDataPacket networkDataPacket = new NetworkDataPacket(simpleCommandPacket.getByteArray());
                this.processCommand(networkDataPacket);
                byte[] byArray2 = networkDataPacket.getDataBuffer();
                int n = NetworkToJavaConverter.byteArrayToInt(byArray2);
                if (n != 0) {
                    this.m_EnclStatusExT = null;
                }
                if (n == 0 && this.m_EnclStatusExT == null) {
                    this.m_EnclStatusExT = new SL_ENCL_STATUS_EX_T(byArray2, 44);
                } else if (n == 0) {
                    this.m_EnclStatusExT.update(byArray2, 44);
                }
                if (this.m_EnclStatusExT != null && this.m_EnclStatusExT.getSize() == 0) {
                    this.m_EnclStatusExT = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public short getState() {
        return 0;
    }

    public boolean isOperationAllowed(byte by) throws IllegalArgumentException {
        return false;
    }

    @Override
    public void notifyMethod(Object object) {
    }

    @Override
    public int fireOperation(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        return 0;
    }

    public boolean handleAEN(MR_EVT_DETAIL mR_EVT_DETAIL) {
        if (this.m_latestSeqNumber >= 0 && this.m_latestSeqNumber > mR_EVT_DETAIL.getseqNum()) {
            return true;
        }
        switch (mR_EVT_DETAIL.getcode()) {
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                try {
                    this.updateEnclosureStatus();
                    this.updateEnclosureStatusExT();
                    this.m_latestSeqNumber = this.m_sasAdapter.getLatestSequenceNumber();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
                this.setChanged();
                break;
            }
            case 168: 
            case 169: 
            case 170: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 208: 
            case 228: 
            case 233: 
            case 243: 
            case 332: {
                try {
                    this.updateEnclosureStatus();
                    this.updateEnclosureStatusExT();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
                this.setChanged();
                break;
            }
        }
        if (this.m_nObj == null) {
            this.m_nObj = new NotifyObject(0x102000 | mR_EVT_DETAIL.getargType(), mR_EVT_DETAIL);
        } else {
            this.m_nObj.update(0x102000 | mR_EVT_DETAIL.getargType(), mR_EVT_DETAIL);
        }
        this.setChanged();
        this.notifyObservers(this.m_nObj);
        return true;
    }

    public void populateSL_ENCL_STATUS_TfromMR_ENCL_INFO(SL_ENCL_STATUS_T sL_ENCL_STATUS_T, MR_ENCL_INFO mR_ENCL_INFO) {
        if (sL_ENCL_STATUS_T != null) {
            sL_ENCL_STATUS_T.setalarmCount(mR_ENCL_INFO.getalarmCount());
            sL_ENCL_STATUS_T.setfanCount(mR_ENCL_INFO.getfanCount());
            sL_ENCL_STATUS_T.setpsCount(mR_ENCL_INFO.getpsCount());
            sL_ENCL_STATUS_T.setsimCount(mR_ENCL_INFO.getSIMCount());
            sL_ENCL_STATUS_T.setslotCount(mR_ENCL_INFO.getslotCount());
            sL_ENCL_STATUS_T.settsCount(mR_ENCL_INFO.gettempSensorCount());
        }
    }

    public MR_ENCL_INFO getEnclInfo() {
        if (this.m_virtualEnclInfo != null) {
            return this.m_virtualEnclInfo;
        }
        try {
            OperationDetails operationDetails = new OperationDetails(5, null);
            ((SASAdapter)this.parent()).fireOperation(operationDetails);
            this.m_enclList = (MR_ENCL_LIST)operationDetails.getParam();
            this.m_virtualEnclInfo = this.m_enclList.getEnclosure(this.getDeviceId());
            return this.m_virtualEnclInfo;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean updateEnclosureStatus() throws VKNotRespondingException, VKOperationFailedException {
        try {
            if (this.getInformation().getscsiDevType() != '\u001f') {
                byte[] byArray = new byte[8];
                NetworkToJavaConverter.shortTobyteArray(this.getDeviceId(), byArray, 0);
                SimpleCommandPacket simpleCommandPacket = new SimpleCommandPacket(8, 1, ((SASAdapter)this.parent()).getCtrlID(), byArray, 1028);
                NetworkDataPacket networkDataPacket = new NetworkDataPacket(simpleCommandPacket.getByteArray());
                this.processCommand(networkDataPacket);
                byte[] byArray2 = networkDataPacket.getDataBuffer();
                int n = NetworkToJavaConverter.byteArrayToInt(byArray2);
                if (n != 0) {
                    throw new VKOperationFailedException(n);
                }
                if (this.m_EnclStatusT == null) {
                    this.m_EnclStatusT = new SL_ENCL_STATUS_T(byArray2, 44, this.getEnclInfo());
                } else {
                    this.m_EnclStatusT.update(byArray2, 44, this.getEnclInfo());
                }
            } else {
                if (this.m_EnclStatusT == null) {
                    this.m_EnclStatusT = new SL_ENCL_STATUS_T(new byte[76], 0, this.getEnclInfo());
                } else {
                    this.m_EnclStatusT.update(new byte[76], 0, this.getEnclInfo());
                }
                this.populateSL_ENCL_STATUS_TfromMR_ENCL_INFO(this.m_EnclStatusT, this.getEnclInfo());
            }
        }
        catch (IOException iOException) {
            throw new VKOperationFailedException(4096);
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            throw new VKOperationFailedException(4096);
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            throw new VKOperationFailedException(4096);
        }
        return false;
    }
}

