/*
 * Decompiled with CFR 0.152.
 */
package SASKernel.SASPhysical;

import Framework.Network.VivaldiFrameworkProtocolErrorException;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.AENHandlerInterface;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_PD_ADDRESS;
import SASKernel.LibraryAPI.StoreLib.MR_PD_INFO;
import SASKernel.LibraryAPI.StoreLib.SL_WH_SSD_INFO;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import Services.NetworkDataPacket;
import Services.NetworkToJavaConverter;
import java.io.IOException;
import java.util.Observable;

public class SASPhysicalDevice
extends Observable
implements ISASObject,
AENHandlerInterface {
    public static final short DEVICE_DIRECT = 0;
    public static final short DEVICE_PROCESSOR = 3;
    public static final short DEVICE_CDROM = 5;
    public static final short DEVICE_TAPE = 1;
    public static final short DEVICE_ENCLOSURE = 13;
    public static final short DEVICE_VIRTUAL_ENCLOSURE = 31;
    public static final short DEVICE_ALL = 256;
    private short ID;
    private short deviceID;
    private SASAdapter sasAdapter;
    protected MR_PD_INFO pdInfo;
    protected MR_PD_INFO temppdInfo;
    protected SL_WH_SSD_INFO whSSDInfo;
    protected SL_WH_SSD_INFO dup_whSSDInfo;
    protected MR_PD_ADDRESS pdAddress;

    public SASPhysicalDevice(short s, short s2, SASAdapter sASAdapter, MR_PD_ADDRESS mR_PD_ADDRESS) throws VKNotRespondingException, VKOperationFailedException {
        this.ID = s;
        this.deviceID = s2;
        this.sasAdapter = sASAdapter;
        this.pdAddress = mR_PD_ADDRESS;
    }

    public short getDeviceId() {
        return this.deviceID;
    }

    @Override
    public short getSeqNum() {
        return 0;
    }

    @Override
    public short getID() {
        return this.ID;
    }

    @Override
    public ISASObject next() {
        return null;
    }

    @Override
    public ISASObject previous() {
        return null;
    }

    @Override
    public ISASObject parent() {
        return this.sasAdapter;
    }

    @Override
    public boolean refresh() throws VKNotRespondingException, VKOperationFailedException {
        this.createInformation();
        return true;
    }

    private void createInformation() throws VKNotRespondingException, VKOperationFailedException {
        byte[] byArray = new byte[8];
        NetworkToJavaConverter.shortTobyteArray(this.getDeviceId(), byArray, 0);
        SimpleCommandPacket simpleCommandPacket = new SimpleCommandPacket(2, 0, this.sasAdapter.getCtrlID(), byArray, 516);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(simpleCommandPacket.getByteArray());
        try {
            this.processCommand(networkDataPacket);
            byte[] byArray2 = networkDataPacket.getDataBuffer();
            int n = NetworkToJavaConverter.byteArrayToInt(byArray2);
            if (n != 0) {
                throw new VKOperationFailedException(n);
            }
            this.temppdInfo = this.pdInfo = new MR_PD_INFO(byArray2, 44);
        }
        catch (IOException iOException) {
            throw new VKOperationFailedException(4096);
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            throw new VKOperationFailedException(4096);
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            throw new VKOperationFailedException(4096);
        }
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public short getState() {
        return 0;
    }

    @Override
    public boolean isOperationAllowed(int n) throws IllegalArgumentException {
        return false;
    }

    @Override
    public void notifyMethod(Object object) {
    }

    @Override
    public int processCommand(NetworkDataPacket networkDataPacket) throws IOException, VKInvalidOperationException, VivaldiFrameworkProtocolErrorException {
        return this.sasAdapter.processCommand(networkDataPacket);
    }

    public MR_PD_INFO getInformation() {
        return this.temppdInfo;
    }

    public MR_PD_ADDRESS getAddress() {
        return this.pdAddress;
    }

    @Override
    public int fireOperation(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        return 0;
    }

    public String getVendorInfo() {
        return new String(this.getInformation().getinquiryData(), 8, 8).trim();
    }

    public String getProductInfo() {
        String string = new String(this.getInformation().getinquiryData(), 16, 16).trim();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isLetterOrDigit(string.charAt(i))) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public String getProductRevisionLevel() {
        return new String(this.getInformation().getinquiryData(), 32, 4).trim();
    }

    public String getSerialNumber() {
        return new String(this.getInformation().getinquiryData(), 36, 20).trim();
    }

    public String getPDSerialNumber() {
        return new String(this.getInformation().getinquiryData(), 36, 8).trim();
    }

    @Override
    public boolean handleAEN(Object object) {
        return false;
    }

    public SL_WH_SSD_INFO getSSDInformation() {
        return this.dup_whSSDInfo;
    }
}

