/*
 * Decompiled with CFR 0.152.
 */
package SASKernel;

import Framework.Network.VivaldiFrameworkProtocolErrorException;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.AENHandlerInterface;
import SASKernel.ISASObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_CCOH_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_LOG_INFO;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CG_LIMITS_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CG_STATS_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_CONFIG_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_LIST_T;
import SASKernel.LibraryAPI.StoreLib.SL_CCOH_DEV_T;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASServer;
import Services.NetworkDataPacket;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Observable;

public class VirtualAdapter
extends Observable
implements ISASObject,
AENHandlerInterface {
    SASServer m_sasServer = null;
    int m_ctrlid = 0;
    MR_EVT_LOG_INFO m_mrEvtLogInfo = null;
    String m_storelibIRPluginWWN;
    private ArrayList m_uniqueAENIDList = new ArrayList();
    private SL_CCOH_CONFIG_T m_CCOHConfig = null;

    public VirtualAdapter(SASServer sASServer, int n, String string) {
        this.m_sasServer = sASServer;
        this.m_ctrlid = n;
        this.m_storelibIRPluginWWN = string;
        try {
            this.refresh();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public synchronized boolean handleAEN(Object object) {
        int n;
        NotifyObject notifyObject = null;
        NetworkPacket networkPacket = (NetworkPacket)object;
        byte[] byArray = networkPacket.getDatabuffer();
        short s = NetworkToJavaConverter.byteArrayToShort(byArray, 0);
        if (s != 0) {
            System.out.println("AEN CallBack Error = " + s);
        }
        if ((n = NetworkToJavaConverter.byteArrayToInt(byArray, 4)) != this.m_ctrlid) {
            return false;
        }
        int n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 8);
        if (!this.isAENIDExists(n2)) {
            return false;
        }
        MR_EVT_CCOH_DETAIL mR_EVT_CCOH_DETAIL = new MR_EVT_CCOH_DETAIL(byArray, 12);
        switch (mR_EVT_CCOH_DETAIL.getcode()) {
            case 49152: 
            case 49153: 
            case 49154: 
            case 49155: 
            case 49156: 
            case 49157: 
            case 49158: {
                this.updateCCOHConfig();
            }
        }
        notifyObject = new NotifyObject(0x102000 | mR_EVT_CCOH_DETAIL.getargType(), mR_EVT_CCOH_DETAIL);
        if (notifyObject != null) {
            this.notifyMethod(notifyObject);
        }
        return true;
    }

    @Override
    public void notifyMethod(Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    private boolean isAENIDExists(int n) {
        Iterator iterator = this.m_uniqueAENIDList.iterator();
        while (iterator.hasNext()) {
            if (n != (Integer)iterator.next()) continue;
            return true;
        }
        return false;
    }

    public void cleanUP() {
        this.deleteObservers();
        this.unRegisterAEN();
    }

    private void StoreAENSequenceInfo() {
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(7, 0, this.m_ctrlid, 20).getByteArray());
        try {
            this.m_sasServer.processCommand(this.m_storelibIRPluginWWN, networkDataPacket);
            byte[] byArray = networkDataPacket.getDataBuffer();
            int n = NetworkToJavaConverter.byteArrayToInt(byArray);
            if (n != 0) {
                System.out.println("Failed to get Sequence Info, Status=" + Integer.toHexString(n));
                return;
            }
            this.m_mrEvtLogInfo = new MR_EVT_LOG_INFO(byArray, 44);
        }
        catch (Exception exception) {
            System.out.println("AEN registration failed (Sequence Info Exception)");
            exception.printStackTrace();
            this.m_mrEvtLogInfo = null;
            return;
        }
    }

    public boolean RegistrationCommandForAEN() {
        boolean bl = false;
        if (this.m_mrEvtLogInfo != null) {
            this.registerWithEventClass(this.m_mrEvtLogInfo.getnewestSeqNum() + 1, (short)-1, (byte)-1);
            ((SASServer)this.parent()).registerForAEN(this);
            bl = true;
        }
        return bl;
    }

    private void registerWithEventClass(int n, short s, byte by) {
        byte[] byArray = new byte[316];
        byArray[4] = 0;
        byArray[5] = 1;
        NetworkToJavaConverter.intToByteArray(this.m_ctrlid, byArray, 8);
        NetworkToJavaConverter.intToByteArray(112, byArray, 20);
        NetworkToJavaConverter.intToByteArray(72, byArray, 32);
        int n2 = 116;
        NetworkToJavaConverter.intToByteArray(1, byArray, n2);
        NetworkToJavaConverter.intToByteArray(this.m_ctrlid, byArray, n2 + 4);
        NetworkToJavaConverter.unsignedShortTobyteArray(s, byArray, n2 + 8);
        byArray[n2 + 11] = by;
        NetworkToJavaConverter.intToByteArray(n, byArray, n2 + 12);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
        try {
            this.m_sasServer.processCommand(this.m_storelibIRPluginWWN, networkDataPacket);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        byArray = networkDataPacket.getDataBuffer();
        int n3 = NetworkToJavaConverter.byteArrayToInt(byArray, 0);
        System.out.println("VirtualAdapter.registerWithEventClass() retval = " + n3);
        int n4 = NetworkToJavaConverter.byteArrayToInt(byArray, 44);
        System.out.println("********************************* ");
        System.out.println("Number of Virtual Controller registered for AEN= " + n4);
        this.m_uniqueAENIDList.add(new Integer(NetworkToJavaConverter.byteArrayToInt(byArray, 112)));
    }

    private void unRegisterAEN() {
        byte[] byArray = new byte[48];
        ListIterator listIterator = this.m_uniqueAENIDList.listIterator();
        while (listIterator.hasNext()) {
            int n;
            byArray[4] = 0;
            byArray[5] = 2;
            NetworkToJavaConverter.intToByteArray(this.m_ctrlid, byArray, 8);
            NetworkToJavaConverter.intToByteArray(4, byArray, 32);
            NetworkToJavaConverter.intToByteArray((Integer)listIterator.next(), byArray, 20);
            NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
            try {
                this.m_sasServer.processCommand(this.m_storelibIRPluginWWN, networkDataPacket);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if ((n = NetworkToJavaConverter.byteArrayToInt(byArray = networkDataPacket.getDataBuffer(), 0)) != 0) continue;
            ((SASServer)this.parent()).unRegisterForAEN(this);
        }
    }

    @Override
    public short getID() {
        return 0;
    }

    public int getCtrlID() {
        return this.m_ctrlid;
    }

    @Override
    public short getSeqNum() {
        return 0;
    }

    @Override
    public ISASObject next() {
        return null;
    }

    @Override
    public ISASObject previous() {
        return null;
    }

    @Override
    public ISASObject parent() {
        return this.m_sasServer;
    }

    @Override
    public boolean refresh() throws VKNotRespondingException, VKOperationFailedException {
        this.StoreAENSequenceInfo();
        this.updateCCOHConfig();
        return false;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    @Override
    public short getState() {
        return 0;
    }

    @Override
    public boolean isOperationAllowed(int n) throws IllegalArgumentException {
        return false;
    }

    @Override
    public int fireOperation(OperationDetails operationDetails) throws VKOperationFailedException, VKInvalidOperationException, VKNotRespondingException {
        return 0;
    }

    @Override
    public int processCommand(NetworkDataPacket networkDataPacket) throws IOException, VKInvalidOperationException, VivaldiFrameworkProtocolErrorException {
        return 0;
    }

    public SL_CCOH_CG_LIMITS_T getCacheGroupLimits() {
        byte[] byArray = null;
        try {
            byArray = this.processCCOHCommand(32, null, (byte)0);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            byArray = null;
        }
        SL_CCOH_CG_LIMITS_T sL_CCOH_CG_LIMITS_T = null;
        if (byArray != null) {
            sL_CCOH_CG_LIMITS_T = new SL_CCOH_CG_LIMITS_T(byArray, 44);
        }
        return sL_CCOH_CG_LIMITS_T;
    }

    public SL_CCOH_DEV_LIST_T getCCOHCDs() {
        byte[] byArray = null;
        try {
            byArray = this.processCCOHCommand(213016, null, (byte)1);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            byArray = null;
        }
        SL_CCOH_DEV_LIST_T sL_CCOH_DEV_LIST_T = null;
        if (byArray != null) {
            sL_CCOH_DEV_LIST_T = new SL_CCOH_DEV_LIST_T(byArray, 44);
        }
        return sL_CCOH_DEV_LIST_T;
    }

    public SL_CCOH_DEV_LIST_T getCCOHVDs() {
        byte[] byArray = null;
        try {
            byArray = this.processCCOHCommand(213016, null, (byte)2);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            byArray = null;
        }
        SL_CCOH_DEV_LIST_T sL_CCOH_DEV_LIST_T = null;
        if (byArray != null) {
            sL_CCOH_DEV_LIST_T = new SL_CCOH_DEV_LIST_T(byArray, 44);
        }
        return sL_CCOH_DEV_LIST_T;
    }

    public SL_CCOH_CONFIG_T getCCOHConfig() {
        return this.m_CCOHConfig;
    }

    public void updateCCOHConfig() {
        byte[] byArray = null;
        try {
            byArray = this.processCCOHCommand(426320, null, (byte)3);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            if (vKOperationFailedException.GetErrorCode() == 24578) {
                System.out.println("VirtualAdapter.getCCOHConfig() - SL_ERR_NO_VALID_CFG");
                this.m_CCOHConfig = null;
            } else {
                vKOperationFailedException.printStackTrace();
            }
            byArray = null;
        }
        if (byArray != null) {
            if (this.m_CCOHConfig == null) {
                this.m_CCOHConfig = new SL_CCOH_CONFIG_T(byArray, 44);
            } else {
                this.m_CCOHConfig.update(byArray, 44);
            }
        }
    }

    public void addCDtoCG(SL_CCOH_DEV_T sL_CCOH_DEV_T) throws VKOperationFailedException {
        try {
            this.processCCOHCommand(832, sL_CCOH_DEV_T.getByteArray(), (byte)6);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            throw vKOperationFailedException;
        }
    }

    public void removeCDfromCG(SL_CCOH_DEV_T sL_CCOH_DEV_T) throws VKOperationFailedException {
        try {
            this.processCCOHCommand(832, sL_CCOH_DEV_T.getByteArray(), (byte)7);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            throw vKOperationFailedException;
        }
    }

    public void addVDtoCG(SL_CCOH_DEV_T sL_CCOH_DEV_T) throws VKOperationFailedException {
        try {
            this.processCCOHCommand(832, sL_CCOH_DEV_T.getByteArray(), (byte)8);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            throw vKOperationFailedException;
        }
    }

    public void removeVDfromCG(SL_CCOH_DEV_T sL_CCOH_DEV_T) throws VKOperationFailedException {
        try {
            this.processCCOHCommand(832, sL_CCOH_DEV_T.getByteArray(), (byte)9);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            throw vKOperationFailedException;
        }
    }

    public SL_CCOH_CG_STATS_T getCacheGroupStats() {
        byte[] byArray = null;
        try {
            byArray = this.processCCOHCommand(368, null, (byte)10);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            byArray = null;
        }
        SL_CCOH_CG_STATS_T sL_CCOH_CG_STATS_T = null;
        if (byArray != null) {
            sL_CCOH_CG_STATS_T = new SL_CCOH_CG_STATS_T(byArray, 44);
        }
        return sL_CCOH_CG_STATS_T;
    }

    public void makeVDOnline(SL_CCOH_DEV_T sL_CCOH_DEV_T) throws VKOperationFailedException {
        try {
            this.processCCOHCommand(832, sL_CCOH_DEV_T.getByteArray(), (byte)12);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            throw vKOperationFailedException;
        }
    }

    public boolean isCCOHLicenseFound() {
        try {
            this.processCCOHCommand(0, null, (byte)13);
            return true;
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            return false;
        }
    }

    public synchronized byte[] processCCOHCommand(int n, byte[] byArray, byte by) throws VKOperationFailedException {
        NetworkDataPacket networkDataPacket = null;
        byte[] byArray2 = new byte[8];
        NetworkToJavaConverter.unsignedShortTobyteArray(this.getSeqNum(), byArray2, 0);
        try {
            networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(11, by, 0x2FFFFFF, byArray2, n, byArray).getByteArray());
            this.m_sasServer.processCommand(this.m_storelibIRPluginWWN, networkDataPacket);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
        }
        catch (VKInvalidOperationException vKInvalidOperationException) {
            vKInvalidOperationException.printStackTrace();
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
        }
        catch (VivaldiFrameworkProtocolErrorException vivaldiFrameworkProtocolErrorException) {
            NetworkToJavaConverter.intToByteArray(1, networkDataPacket.getDataBuffer());
            vivaldiFrameworkProtocolErrorException.printStackTrace();
        }
        int n2 = 1;
        byte[] byArray3 = networkDataPacket.getDataBuffer();
        n2 = NetworkToJavaConverter.byteArrayToInt(byArray3, 0);
        if (n2 != 0) {
            System.out.println("SASServer.processCCOHCommand() failed with retVal = " + n2);
            throw new VKOperationFailedException(n2);
        }
        return byArray3;
    }
}

