/*
 * Decompiled with CFR 0.152.
 */
package Services;

import SASKernel.LibraryAPI.StoreLib.MR_TIME_STAMP;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class KernelConstants {
    public static final int FRAMEWORK_PORT_NO = 3071;
    public static final int UNIT_BLOCKS = 999;
    public static final int UNIT_B = 0;
    public static final int UNIT_KB = 1;
    public static final int UNIT_MB = 2;
    public static final int UNIT_GB = 3;
    public static final int UNIT_TB = 4;
    public static final int UNIT_PB = 5;
    public static final int BLOCK_SIZE_4K = 4096;
    public static final int BLOCK_SIZE_512 = 512;
    public static final int UNIT_OF_PRECISION = 3;
    public static final byte EDIT_SCHEDULE_LD = 12;
    public static final byte EDIT_SCHEDULE_ALL_LDs = 13;
    public static final byte NEW_SCHEDULE_LD = 14;
    public static final int SCHEDULE_FREQUENCY_DAILY = 24;
    public static final int SCHEDULE_FREQUENCY_WEEKLY = 168;
    public static final int SCHEDULE_FREQUENCY_MONTHLY = 720;
    public static final int SCHEDULE_FREQUENCY_NONE = 0;
    public static final byte STATE_ENABLED = 1;
    public static final byte STATE_DISABLED = 0;
    public static final int TYPE_SPAN = 1;
    public static final int TYPE_SSCD = 2;
    public static final int TYPE_DG = 3;

    public static byte getBitValue(int n, int n2) {
        return (byte)(n2 < 0 ? n : n >> n2 & 1);
    }

    public static short getBitsValue(int n, short s, short s2) {
        short s3 = 0;
        for (short s4 = s; s4 < s2; s4 = (short)(s4 + 1)) {
            s3 = (short)(s3 + (KernelConstants.getBitValue(n, (int)s4) << s4));
        }
        return s3;
    }

    public static byte getBitValue(long l, int n) {
        return (byte)(n < 0 ? l : l >> n & 1L);
    }

    public static byte getBitPosition(int n) {
        for (int i = 0; i < 32; ++i) {
            if (KernelConstants.getBitValue(n, i) == 0) continue;
            return (byte)i;
        }
        return 100;
    }

    public static long BLK2MB(long l) {
        return l / 2048L;
    }

    public static long MB2BLK(long l) {
        return l * 2048L;
    }

    public static String getConvertedSize(double d) {
        BigDecimal bigDecimal = new BigDecimal(d * 512.0);
        BigDecimal bigDecimal2 = new BigDecimal(Math.pow(1024.0, 6.0));
        BigDecimal bigDecimal3 = new BigDecimal(Math.pow(1024.0, 5.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0 && bigDecimal.compareTo(bigDecimal2) < 0) {
            return "" + bigDecimal.divide(bigDecimal3, 3, 5) + " PB";
        }
        bigDecimal3 = new BigDecimal(Math.pow(1024.0, 4.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            return "" + bigDecimal.divide(bigDecimal3, 3, 5) + " TB";
        }
        bigDecimal3 = new BigDecimal(Math.pow(1024.0, 3.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            return "" + bigDecimal.divide(bigDecimal3, 3, 5) + " GB";
        }
        bigDecimal3 = new BigDecimal(Math.pow(1024.0, 2.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            return "" + bigDecimal.divide(bigDecimal3, 3, 5) + " MB";
        }
        bigDecimal3 = new BigDecimal(1024);
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            return "" + bigDecimal.divide(bigDecimal3, 3, 5) + " KB";
        }
        return "" + bigDecimal + " Bytes";
    }

    public static String getConvertedSize(double d, short s) {
        BigDecimal bigDecimal = new BigDecimal(d * (double)s);
        BigDecimal bigDecimal2 = new BigDecimal(Math.pow(1024.0, 6.0));
        BigDecimal bigDecimal3 = new BigDecimal(Math.pow(1024.0, 5.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0 && bigDecimal.compareTo(bigDecimal2) < 0) {
            return "" + bigDecimal.divide(bigDecimal3, 3, 5) + " PB";
        }
        bigDecimal3 = new BigDecimal(Math.pow(1024.0, 4.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            return "" + bigDecimal.divide(bigDecimal3, 3, 5) + " TB";
        }
        bigDecimal3 = new BigDecimal(Math.pow(1024.0, 3.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            return "" + bigDecimal.divide(bigDecimal3, 3, 5) + " GB";
        }
        bigDecimal3 = new BigDecimal(Math.pow(1024.0, 2.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            return "" + bigDecimal.divide(bigDecimal3, 3, 5) + " MB";
        }
        bigDecimal3 = new BigDecimal(1024);
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            return "" + bigDecimal.divide(bigDecimal3, 3, 5) + " KB";
        }
        return "" + bigDecimal + " Bytes";
    }

    public static long getSizeInBlocks(double d, int n) {
        switch (n) {
            case 0: {
                d /= 512.0;
                break;
            }
            case 1: {
                d *= 2.0;
                break;
            }
            case 2: {
                d *= 2048.0;
                break;
            }
            case 3: {
                d = d * 2048.0 * 1024.0;
                break;
            }
            case 4: {
                d = d * 2048.0 * 1024.0 * 1024.0;
            }
        }
        return (long)d;
    }

    public static long getSizeInBlocks(double d, int n, short s) {
        switch (n) {
            case 0: {
                d /= (double)s;
                break;
            }
            case 1: {
                d = d * 1024.0 / (double)s;
                break;
            }
            case 2: {
                d = d * Math.pow(1024.0, 2.0) / (double)s;
                break;
            }
            case 3: {
                d = d * Math.pow(1024.0, 3.0) / (double)s;
                break;
            }
            case 4: {
                d = d * Math.pow(1024.0, 4.0) / (double)s;
            }
        }
        return (long)d;
    }

    public static double[] getSizeAndUnit(double d) {
        double[] dArray = new double[2];
        BigDecimal bigDecimal = new BigDecimal(d * 512.0);
        BigDecimal bigDecimal2 = new BigDecimal(Math.pow(1024.0, 6.0));
        BigDecimal bigDecimal3 = new BigDecimal(Math.pow(1024.0, 5.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0 && bigDecimal.compareTo(bigDecimal2) < 0) {
            BigDecimal bigDecimal4 = bigDecimal.divide(bigDecimal3, 3, 5);
            dArray[0] = bigDecimal4.doubleValue();
            dArray[1] = 5.0;
            return dArray;
        }
        bigDecimal3 = new BigDecimal(Math.pow(1024.0, 4.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            BigDecimal bigDecimal5 = bigDecimal.divide(bigDecimal3, 3, 5);
            dArray[0] = bigDecimal5.doubleValue();
            dArray[1] = 4.0;
            return dArray;
        }
        bigDecimal3 = new BigDecimal(Math.pow(1024.0, 3.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            BigDecimal bigDecimal6 = bigDecimal.divide(bigDecimal3, 3, 5);
            dArray[0] = bigDecimal6.doubleValue();
            dArray[1] = 3.0;
            return dArray;
        }
        bigDecimal3 = new BigDecimal(Math.pow(1024.0, 2.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            BigDecimal bigDecimal7 = bigDecimal.divide(bigDecimal3, 3, 5);
            dArray[0] = bigDecimal7.doubleValue();
            dArray[1] = 2.0;
            return dArray;
        }
        bigDecimal3 = new BigDecimal(1024);
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            BigDecimal bigDecimal8 = bigDecimal.divide(bigDecimal3, 3, 5);
            dArray[0] = bigDecimal8.doubleValue();
            dArray[1] = 1.0;
            return dArray;
        }
        return dArray;
    }

    public static double[] getSizeAndUnit(double d, short s) {
        double[] dArray = new double[2];
        BigDecimal bigDecimal = new BigDecimal(d * (double)s);
        BigDecimal bigDecimal2 = new BigDecimal(Math.pow(1024.0, 6.0));
        BigDecimal bigDecimal3 = new BigDecimal(Math.pow(1024.0, 5.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0 && bigDecimal.compareTo(bigDecimal2) < 0) {
            BigDecimal bigDecimal4 = bigDecimal.divide(bigDecimal3, 3, 5);
            dArray[0] = bigDecimal4.doubleValue();
            dArray[1] = 5.0;
            return dArray;
        }
        bigDecimal3 = new BigDecimal(Math.pow(1024.0, 4.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            BigDecimal bigDecimal5 = bigDecimal.divide(bigDecimal3, 3, 5);
            dArray[0] = bigDecimal5.doubleValue();
            dArray[1] = 4.0;
            return dArray;
        }
        bigDecimal3 = new BigDecimal(Math.pow(1024.0, 3.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            BigDecimal bigDecimal6 = bigDecimal.divide(bigDecimal3, 3, 5);
            dArray[0] = bigDecimal6.doubleValue();
            dArray[1] = 3.0;
            return dArray;
        }
        bigDecimal3 = new BigDecimal(Math.pow(1024.0, 2.0));
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            BigDecimal bigDecimal7 = bigDecimal.divide(bigDecimal3, 3, 5);
            dArray[0] = bigDecimal7.doubleValue();
            dArray[1] = 2.0;
            return dArray;
        }
        bigDecimal3 = new BigDecimal(1024);
        if (bigDecimal.compareTo(bigDecimal3) >= 0) {
            BigDecimal bigDecimal8 = bigDecimal.divide(bigDecimal3, 3, 5);
            dArray[0] = bigDecimal8.doubleValue();
            dArray[1] = 1.0;
            return dArray;
        }
        return dArray;
    }

    public static double getSizeInSpecifiedUnit(double d, int n, int n2) {
        BigDecimal bigDecimal = n == 999 ? new BigDecimal(d * 512.0) : new BigDecimal(KernelConstants.getSizeInBlocks(d, n) * 512L);
        BigDecimal bigDecimal2 = new BigDecimal(0);
        switch (n2) {
            case 1: {
                bigDecimal2 = new BigDecimal(1024);
                break;
            }
            case 2: {
                bigDecimal2 = new BigDecimal(Math.pow(1024.0, 2.0));
                break;
            }
            case 3: {
                bigDecimal2 = new BigDecimal(Math.pow(1024.0, 3.0));
                break;
            }
            case 4: {
                bigDecimal2 = new BigDecimal(Math.pow(1024.0, 4.0));
                break;
            }
            case 5: {
                bigDecimal2 = new BigDecimal(Math.pow(1024.0, 5.0));
            }
        }
        BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, 3, 5);
        return bigDecimal3.doubleValue();
    }

    public static double getSizeInSpecifiedUnit(double d, int n, int n2, short s) {
        BigDecimal bigDecimal = n == 999 ? new BigDecimal(d * (double)s) : new BigDecimal(KernelConstants.getSizeInBlocks(d, n, s) * (long)s);
        BigDecimal bigDecimal2 = new BigDecimal(0);
        switch (n2) {
            case 1: {
                bigDecimal2 = new BigDecimal(1024);
                break;
            }
            case 2: {
                bigDecimal2 = new BigDecimal(Math.pow(1024.0, 2.0));
                break;
            }
            case 3: {
                bigDecimal2 = new BigDecimal(Math.pow(1024.0, 3.0));
                break;
            }
            case 4: {
                bigDecimal2 = new BigDecimal(Math.pow(1024.0, 4.0));
                break;
            }
            case 5: {
                bigDecimal2 = new BigDecimal(Math.pow(1024.0, 5.0));
            }
        }
        BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, 3, 5);
        return bigDecimal3.doubleValue();
    }

    public static void dumpByteArrayToFile(byte[] byArray) {
        String string = "easytofind.bin";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.close();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Could not dump byte array");
        }
    }

    public static long alignBlockToStripeSize(long l) {
        l = l / 8192L * 8192L;
        return l;
    }

    public static MR_TIME_STAMP getTimeStamp(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
        long l2 = gregorianCalendar.getTimeInMillis();
        long l3 = l * 1000L;
        TimeZone timeZone = TimeZone.getDefault();
        gregorianCalendar.setTimeInMillis(l2 + l3);
        boolean bl = timeZone.inDaylightTime(gregorianCalendar.getTime());
        if (bl) {
            int n = timeZone.getDSTSavings();
            gregorianCalendar.setTimeInMillis(l2 + l3 - (long)n);
        } else {
            gregorianCalendar.setTimeInMillis(l2 + l3);
        }
        MR_TIME_STAMP mR_TIME_STAMP = new MR_TIME_STAMP();
        mR_TIME_STAMP.setyear((short)gregorianCalendar.get(1));
        mR_TIME_STAMP.setmonth((byte)gregorianCalendar.get(2));
        mR_TIME_STAMP.setday((byte)gregorianCalendar.get(5));
        mR_TIME_STAMP.sethour((byte)gregorianCalendar.get(11));
        mR_TIME_STAMP.setmin((byte)gregorianCalendar.get(12));
        mR_TIME_STAMP.setsec((byte)gregorianCalendar.get(13));
        return mR_TIME_STAMP;
    }

    public static long GetTimeInMilliSecs(MR_TIME_STAMP mR_TIME_STAMP, int n, MR_TIME_STAMP mR_TIME_STAMP2) {
        long l = 0L;
        byte by = mR_TIME_STAMP.getmonth();
        int n2 = mR_TIME_STAMP.getday();
        short s = mR_TIME_STAMP.getyear();
        byte by2 = mR_TIME_STAMP.gethour();
        byte by3 = mR_TIME_STAMP.getmin();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(mR_TIME_STAMP2.getyear(), mR_TIME_STAMP2.getmonth() - 1, mR_TIME_STAMP2.getday(), mR_TIME_STAMP2.gethour(), mR_TIME_STAMP2.getmin(), mR_TIME_STAMP2.getsec());
        if (gregorianCalendar.get(1) == s) {
            if (by < gregorianCalendar.get(2)) {
                System.out.println("The specified date occurs in the past");
            } else if (by == gregorianCalendar.get(2) && n2 < gregorianCalendar.get(5)) {
                System.out.println("The specified date occurs in the past");
            } else if (by == gregorianCalendar.get(2) && n2 == gregorianCalendar.get(5) && by2 <= gregorianCalendar.get(11)) {
                if (by2 == gregorianCalendar.get(11)) {
                    if (by3 < gregorianCalendar.get(12)) {
                        n2 = n < 168 ? ++n2 : (n2 += 7);
                    }
                } else {
                    n2 = n < 168 ? ++n2 : (n2 += 7);
                }
                System.out.println("The specified date occurs in the past");
            }
        }
        gregorianCalendar.set(1, s);
        gregorianCalendar.set(2, by);
        gregorianCalendar.set(5, n2);
        gregorianCalendar.set(11, by2);
        gregorianCalendar.set(12, by3);
        gregorianCalendar.set(13, 0);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(2000, 0, 1, 0, 0, 0);
        TimeZone timeZone = TimeZone.getDefault();
        Date date = gregorianCalendar.getTime();
        long l2 = gregorianCalendar2.getTimeInMillis() / 1000L;
        long l3 = gregorianCalendar.getTimeInMillis() / 1000L;
        boolean bl = timeZone.inDaylightTime(date);
        if (bl) {
            int n3 = timeZone.getDSTSavings();
            l = (int)(l3 - l2 + (long)(n3 / 1000));
        } else {
            l = (int)(l3 - l2);
        }
        return l;
    }

    public static void main(String[] stringArray) {
        MR_TIME_STAMP mR_TIME_STAMP = KernelConstants.getTimeStamp(86400L);
        System.out.println(" Time " + mR_TIME_STAMP.getyear() + ":" + mR_TIME_STAMP.getmonth() + ":" + mR_TIME_STAMP.getday());
    }

    public static String getTimeText(MR_TIME_STAMP mR_TIME_STAMP) {
        String[] stringArray = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[mR_TIME_STAMP.getmonth()] + " ");
        stringBuffer.append(mR_TIME_STAMP.getday());
        if (mR_TIME_STAMP.gethour() == 0) {
            if (mR_TIME_STAMP.getmin() <= 9) {
                stringBuffer.append(", 12:0" + mR_TIME_STAMP.getmin() + "AM");
            } else {
                stringBuffer.append(", 12:" + mR_TIME_STAMP.getmin() + "AM");
            }
        } else if (mR_TIME_STAMP.gethour() == 12) {
            if (mR_TIME_STAMP.getmin() <= 9) {
                stringBuffer.append(", 12:0" + mR_TIME_STAMP.getmin() + "PM");
            } else {
                stringBuffer.append(", 12:" + mR_TIME_STAMP.getmin() + "PM");
            }
        } else {
            if (mR_TIME_STAMP.gethour() <= 9) {
                stringBuffer.append(", 0" + mR_TIME_STAMP.gethour() % 12);
            } else {
                stringBuffer.append(", " + mR_TIME_STAMP.gethour() % 12);
            }
            if (mR_TIME_STAMP.getmin() <= 9) {
                stringBuffer.append(":0" + mR_TIME_STAMP.getmin());
            } else {
                stringBuffer.append(":" + mR_TIME_STAMP.getmin());
            }
            int n = mR_TIME_STAMP.gethour() / 12;
            if (n > 0) {
                stringBuffer.append("PM");
            } else {
                stringBuffer.append("AM");
            }
        }
        return stringBuffer.toString();
    }
}

