/*
 * Decompiled with CFR 0.152.
 */
package Services;

public class NetworkToJavaConverter {
    public static void intToByteArray(int n, byte[] byArray) {
        NetworkToJavaConverter.intToByteArray(n, byArray, 0);
    }

    public static short U8ToShort(byte by) {
        return (short)(by & 0xFF);
    }

    public static void LongToByteArray(long l, byte[] byArray, int n) {
        int n2 = (int)l;
        int n3 = (int)(l >> 32);
        byArray[n + 0] = (byte)(n2 & 0xFF);
        byArray[n + 1] = (byte)((n2 & 0xFF00) >> 8);
        byArray[n + 2] = (byte)((n2 & 0xFF0000) >> 16);
        byArray[n + 3] = (byte)((n2 & 0xFF000000) >> 24);
        byArray[n + 4] = (byte)(n3 & 0xFF);
        byArray[n + 5] = (byte)((n3 & 0xFF00) >> 8);
        byArray[n + 6] = (byte)((n3 & 0xFF0000) >> 16);
        byArray[n + 7] = (byte)((n3 & 0xFF000000) >> 24);
    }

    public static void intToByteArray(int n, byte[] byArray, int n2) {
        byArray[n2 + 0] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)((n & 0xFF00) >> 8);
        byArray[n2 + 2] = (byte)((n & 0xFF0000) >> 16);
        byArray[n2 + 3] = (byte)((n & 0xFF000000) >> 24);
    }

    public static void shortTobyteArray(short s, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(s & 0xFF);
        byArray[n + 1] = (byte)((s & 0xFF00) >> 8);
    }

    public static void unsignedShortTobyteArray(short s, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(s & 0xFF);
        byArray[n + 1] = (byte)((s & 0xFF00) >> 8);
    }

    public static int byteArrayToInt(byte[] byArray) {
        return NetworkToJavaConverter.byteArrayToInt(byArray, 0);
    }

    public static short getUnsignedVal(byte by) {
        return by >= 0 ? (short)by : (short)(256 + (short)by);
    }

    public static short byteArrayToShort(byte[] byArray, int n) {
        short s = (short)(byArray[n] >= 0 ? byArray[n] : 256 + byArray[n]);
        short s2 = (short)(byArray[n + 1] >= 0 ? byArray[n + 1] : 256 + byArray[n + 1]);
        short s3 = (short)(s + (s2 << 8));
        return s3;
    }

    public static int byteArrayToUnsignedShort(byte[] byArray, int n) {
        int n2 = NetworkToJavaConverter.unsignedByteToInt(byArray[n]);
        int n3 = NetworkToJavaConverter.unsignedByteToInt(byArray[n + 1]);
        int n4 = n2 + (n3 << 8);
        return n4;
    }

    public static int byteArrayToInt(byte[] byArray, int n) {
        int n2 = byArray[n] >= 0 ? byArray[n] : 256 + byArray[n];
        int n3 = byArray[n + 1] >= 0 ? byArray[n + 1] : 256 + byArray[n + 1];
        int n4 = byArray[n + 2] >= 0 ? byArray[n + 2] : 256 + byArray[n + 2];
        int n5 = byArray[n + 3] >= 0 ? byArray[n + 3] : 256 + byArray[n + 3];
        int n6 = n2 + (n3 << 8) + (n4 << 16) + (n5 << 24);
        return n6;
    }

    public static long byteArrayToUnsignedInt(byte[] byArray, int n) {
        long l = NetworkToJavaConverter.unsignedByteToInt(byArray[n]);
        long l2 = NetworkToJavaConverter.unsignedByteToInt(byArray[n + 1]);
        long l3 = NetworkToJavaConverter.unsignedByteToInt(byArray[n + 2]);
        long l4 = NetworkToJavaConverter.unsignedByteToInt(byArray[n + 3]);
        long l5 = l + (l2 << 8) + (l3 << 16) + (l4 << 24);
        return l5;
    }

    public static long byteArrayToLong(byte[] byArray, int n) {
        long l = NetworkToJavaConverter.unsignedByteToInt(byArray[n]);
        long l2 = NetworkToJavaConverter.unsignedByteToInt(byArray[n + 1]);
        long l3 = NetworkToJavaConverter.unsignedByteToInt(byArray[n + 2]);
        long l4 = NetworkToJavaConverter.unsignedByteToInt(byArray[n + 3]);
        long l5 = NetworkToJavaConverter.unsignedByteToInt(byArray[n + 4]);
        long l6 = NetworkToJavaConverter.unsignedByteToInt(byArray[n + 5]);
        long l7 = NetworkToJavaConverter.unsignedByteToInt(byArray[n + 6]);
        long l8 = NetworkToJavaConverter.unsignedByteToInt(byArray[n + 7]);
        long l9 = l + (l2 << 8) + (l3 << 16) + (l4 << 24) + (l5 << 32) + (l6 << 40) + (l7 << 48) + (l8 << 56);
        return l9;
    }

    public static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    public static long unsignedIntToLong(int n) {
        return n & 0xFFFF;
    }

    public static int unsignedCharToInt(char c) {
        return c & 0xFFFFFFFF;
    }

    public static short signedByteToShort(byte[] byArray, int n) {
        short s = (short)(byArray[n] >= 0 ? byArray[n] : 256 + byArray[n]);
        int n2 = 0;
        short s2 = (short)(s + (n2 << 8));
        return s2;
    }

    public static void shortToSignedByte(short s, byte[] byArray, int n) {
        byArray[n + 0] = (byte)(s & 0xFF);
        byArray[n + 1] = 0;
    }

    public static String shortToHexString(short s) {
        String string = "";
        byte[] byArray = new byte[4];
        try {
            NetworkToJavaConverter.intToByteArray(0, byArray);
            NetworkToJavaConverter.unsignedShortTobyteArray(s, byArray, 0);
            string = "0x" + Integer.toHexString(NetworkToJavaConverter.byteArrayToInt(byArray));
        }
        catch (Exception exception) {
            System.out.println("NetworkToJavaConverter.shortToHexString() Exception @ conversion");
        }
        return string;
    }

    public static String subByteArraytoHexString(byte[] byArray, int n, int n2) {
        String string = "";
        for (int i = n; i <= n2; ++i) {
            string = string + Integer.toString((byArray[i] & 0xFF) + 256, 16).substring(1);
        }
        return string;
    }

    public static String byteToHex(byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toHexString(by >>> 4 & 0xF).toUpperCase());
        stringBuffer.append(Integer.toHexString(by & 0xF).toUpperCase());
        return stringBuffer.toString();
    }
}

