/*
 * Decompiled with CFR 0.152.
 */
package Services;

import Framework.AccessControllers.AccessControlManager;
import Framework.ClientManagers.ClientInfo;
import Framework.FrameworkManager;
import Framework.Network.NetworkManager;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Framework.PluginManagers.PluginDataInfo;
import Framework.PluginManagers.PluginInterface;
import Framework.PluginManagers.PluginManager;
import Services.FrameworkUtilities;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import java.util.ArrayList;

public class RoutingManager {
    public static ArrayList<String> ipList = RoutingManager.updateIPList();

    public static void routeCall(NetworkPacket networkPacket) throws VivaldiFrameworkProtocolErrorException {
        int n = networkPacket.getRequestType();
        String string = networkPacket.getReceiverIPAsString();
        if (!ipList.contains(string)) {
            RoutingManager.updateIPList();
        }
        switch (n) {
            case 4097: 
            case 4098: 
            case 4099: 
            case 4100: 
            case 4101: 
            case 4102: {
                break;
            }
            default: {
                if (ipList.contains(string)) break;
                System.out.println("route call" + PluginManager.CURRENTLY_USED_IP_ADDR);
                string = PluginManager.CURRENTLY_USED_IP_ADDR;
                System.out.println("updated IP=" + networkPacket.getReceiverIPAsString());
            }
        }
        if (!ipList.contains(string) || NetworkManager.getPort() != networkPacket.getReceiverPort()) {
            NetworkManager.forwardCallToDestination(networkPacket);
            return;
        }
        if ((networkPacket.getRequestType() & 0x100) != 0) {
            FrameworkManager.getFrameworkManager().handleFrameworkCalls(networkPacket);
        } else {
            if ((networkPacket.getRequestType() & 2) != 0 && (networkPacket.getRequestType() & 4) == 0 && AccessControlManager.isClientRegistered(networkPacket.getSenderWWN()) && PluginManager.getPluginInterface(0, 8) != null) {
                byte[] byArray = FrameworkManager.getFrameworkManager().getClientList();
                try {
                    int n2;
                    ClientInfo[] clientInfoArray = new ClientInfo[NetworkToJavaConverter.byteArrayToInt(byArray)];
                    for (n2 = 0; n2 < clientInfoArray.length; ++n2) {
                        clientInfoArray[n2] = new ClientInfo(byArray, 4 + n2 * 512);
                    }
                    for (n2 = 0; n2 < clientInfoArray.length; ++n2) {
                        if (!networkPacket.getReceiverWWN().equalsIgnoreCase(clientInfoArray[n2].getWWN())) continue;
                        PluginInterface pluginInterface = PluginManager.getPluginInterface(0, 8);
                        if (pluginInterface == null) {
                            byte[] byArray2 = new byte[4];
                            NetworkToJavaConverter.intToByteArray(0, byArray2);
                            networkPacket.setDatabuffer(byArray2);
                            return;
                        }
                        PluginDataInfo pluginDataInfo = new PluginDataInfo(networkPacket);
                        if (pluginInterface.processCommand(pluginDataInfo)) {
                            networkPacket.setDatabuffer(pluginDataInfo.getBuffer());
                        } else {
                            networkPacket.setDatabuffer(null);
                        }
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if ((networkPacket.getRequestType() & 2) != 0 && (networkPacket.getRequestType() & 4) != 0 && !AccessControlManager.isClientRegistered(networkPacket.getSenderWWN())) {
                networkPacket.setFrameworkError(2);
                return;
            }
            PluginManager.routeCallToPlugin(networkPacket);
        }
    }

    public static ArrayList<String> updateIPList() {
        ipList = FrameworkUtilities.getLocalHostAddressList();
        ipList.add("127.0.0.1");
        return ipList;
    }
}

