/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.FrameworkInterface;
import Framework.PluginManagers.PluginDataInfo;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_CLASS_LOCALE;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_LOG_INFO;
import SASKernel.LibraryAPI.StoreLib.SL_DCMD_INPUT_T;
import SASKernel.LibraryAPI.StoreLib.SL_EVENT_DETAIL_T;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import Services.CommonConstants;
import Services.NetworkDataPacket;
import Services.NetworkToJavaConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import plugins.ManageCIMOMServer;
import plugins.ProcessCommand;
import plugins.Utils.PluginsWWN;

public class AdapterRegistration
extends Thread {
    private FrameworkInterface m_objFramework = null;
    private MR_EVT_LOG_INFO m_mrEvtLogInfo = null;
    private static Hashtable m_uniqueAENIDHash = new Hashtable();
    private int m_ctrlIndex;
    private ArrayList m_ctrlList = null;
    private ArrayList m_ctrlTypeList = null;
    private boolean m_isCimomServer = false;
    private ManageCIMOMServer m_cimomDetails = null;
    public static String m_stdAdpPropertyFileName = "SASAdapterInfo_";
    public static final String ADAPTER_INDEX = "ADAPTER_INDEX";
    public static final String ADAPTER_ID = "ADAPTER_ID";
    public static final String ADAPTER_LAST_SEQNUM = "ADAPTER_LAST_SEQNUM";
    public static final String ADAPTER_LAST_SEQNUM_TIMESTAMP = "ADAPTER_LAST_SEQNUM_TIMESTAMP";
    public int m_lastSeqNumTimeStamp = 0;
    private String m_senderWWN = "";

    AdapterRegistration(FrameworkInterface frameworkInterface, ArrayList arrayList, ArrayList arrayList2, ManageCIMOMServer manageCIMOMServer, boolean bl) {
        this.m_objFramework = frameworkInterface;
        this.m_ctrlList = arrayList;
        this.m_ctrlTypeList = arrayList2;
        this.m_isCimomServer = bl;
        this.m_cimomDetails = manageCIMOMServer;
        try {
            this.m_senderWWN = this.m_isCimomServer ? PluginsWWN.getCIMOMMonitorWWN() : PluginsWWN.getMonitorWWN();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
    }

    @Override
    public void run() {
        block30: {
            try {
                ArrayList arrayList = null;
                if (this.m_ctrlList != null) {
                    arrayList = this.m_ctrlList;
                }
                ArrayList arrayList2 = null;
                if (this.m_ctrlTypeList != null) {
                    arrayList2 = this.m_ctrlTypeList;
                }
                String string = null;
                if (arrayList != null) {
                    block20: for (int i = 0; i < arrayList.size(); ++i) {
                        Integer n = (Integer)arrayList.get(i);
                        System.out.println("ctrl ID -> " + n);
                        this.m_ctrlIndex = i;
                        if (arrayList2 == null) continue;
                        Integer n2 = (Integer)arrayList2.get(i);
                        System.out.println("ctrl Type -> " + n2);
                        Properties properties = new Properties();
                        try {
                            switch (n2) {
                                case 1: {
                                    Object object2;
                                    string = PluginsWWN.getStorelibWWN();
                                    this.StoreAENSequenceInfo(n, string);
                                    String string2 = CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + new String(m_stdAdpPropertyFileName + i + ".properties");
                                    File file = new File(string2);
                                    if (!file.exists()) {
                                        try {
                                            file.createNewFile();
                                            object2 = new FileInputStream(file);
                                            properties.load((InputStream)object2);
                                            properties.setProperty(ADAPTER_INDEX, new Integer(i).toString());
                                            properties.setProperty(ADAPTER_ID, n.toString());
                                            properties.setProperty(ADAPTER_LAST_SEQNUM, new Integer(this.m_mrEvtLogInfo.getshutdownSeqNum()).toString());
                                            properties.store(new FileOutputStream(string2), null);
                                        }
                                        catch (IOException iOException) {
                                            System.out.println("Error @ creation of file " + string2);
                                        }
                                    }
                                    if (this.RegistrationCommandForAEN(n, string)) continue block20;
                                    System.out.println("AdapterRegistration.run() Adapter " + n + "not reg for AEN");
                                    break;
                                }
                                case 2: {
                                    Object object3;
                                    string = PluginsWWN.getStorelibIRWWN();
                                    this.StoreAENSequenceInfo(n, string);
                                    Object object2 = CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + new String(m_stdAdpPropertyFileName + i + ".properties");
                                    File file = new File((String)object2);
                                    if (!file.exists()) {
                                        try {
                                            file.createNewFile();
                                            object3 = new FileInputStream(file);
                                            properties.load((InputStream)object3);
                                            properties.setProperty(ADAPTER_INDEX, new Integer(i).toString());
                                            properties.setProperty(ADAPTER_ID, n.toString());
                                            properties.setProperty(ADAPTER_LAST_SEQNUM, new Integer(this.m_mrEvtLogInfo.getshutdownSeqNum()).toString());
                                            properties.store(new FileOutputStream((String)object2), null);
                                        }
                                        catch (IOException iOException) {
                                            System.out.println("Error @ creation of file " + (String)object2);
                                        }
                                    }
                                    if (this.RegistrationCommandForAEN(n, string)) continue block20;
                                    System.out.println("AdapterRegistration.run() Adapter " + n + "not reg for AEN");
                                    break;
                                }
                                case 3: {
                                    Object object4;
                                    string = PluginsWWN.getStorelibIRWWN();
                                    this.StoreAENSequenceInfo(n, string);
                                    Object object3 = CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + new String(m_stdAdpPropertyFileName + i + ".properties");
                                    File file = new File((String)object3);
                                    if (!file.exists()) {
                                        try {
                                            file.createNewFile();
                                            object4 = new FileInputStream(file);
                                            properties.load((InputStream)object4);
                                            properties.setProperty(ADAPTER_INDEX, new Integer(i).toString());
                                            properties.setProperty(ADAPTER_ID, n.toString());
                                            properties.setProperty(ADAPTER_LAST_SEQNUM, new Integer(this.m_mrEvtLogInfo.getshutdownSeqNum()).toString());
                                            properties.store(new FileOutputStream((String)object3), null);
                                        }
                                        catch (IOException iOException) {
                                            System.out.println("Error @ creation of file " + (String)object3);
                                        }
                                    }
                                    if (this.RegistrationCommandForAEN(n, string)) continue block20;
                                    System.out.println("AdapterRegistration.run() Adapter " + n + "not reg for AEN");
                                    break;
                                }
                                case 4: {
                                    Object object;
                                    string = PluginsWWN.getStorelibIRWWN();
                                    this.StoreAENSequenceInfo(n, string);
                                    Object object4 = CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + new String(m_stdAdpPropertyFileName + i + ".properties");
                                    File file = new File((String)object4);
                                    if (!file.exists()) {
                                        try {
                                            file.createNewFile();
                                            object = new FileInputStream(file);
                                            properties.load((InputStream)object);
                                            properties.setProperty(ADAPTER_INDEX, new Integer(i).toString());
                                            properties.setProperty(ADAPTER_ID, n.toString());
                                            properties.setProperty(ADAPTER_LAST_SEQNUM, new Integer(this.m_mrEvtLogInfo.getshutdownSeqNum()).toString());
                                            properties.store(new FileOutputStream((String)object4), null);
                                        }
                                        catch (IOException iOException) {
                                            System.out.println("Error @ creation of file " + (String)object4);
                                        }
                                    }
                                    if (this.RegistrationCommandForAEN(n, string)) continue block20;
                                    System.out.println("AdapterRegistration.run() Adapter " + n + "not reg for AEN");
                                    break;
                                }
                                default: {
                                    Object object;
                                    if (this.m_isCimomServer) {
                                        string = PluginsWWN.getCIMPluginWWN();
                                        this.StoreAENSequenceInfo(n, string);
                                        object = CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + new String(this.m_cimomDetails.getCIMMOMIP().toString().trim() + "_" + m_stdAdpPropertyFileName + i + ".properties");
                                        File file = new File((String)object);
                                        if (!file.exists()) {
                                            try {
                                                file.createNewFile();
                                                FileInputStream fileInputStream = new FileInputStream(file);
                                                properties.load(fileInputStream);
                                                properties.setProperty(ADAPTER_INDEX, new Integer(i).toString());
                                                properties.setProperty(ADAPTER_ID, n.toString());
                                                properties.setProperty(ADAPTER_LAST_SEQNUM, new Integer(this.m_mrEvtLogInfo.getshutdownSeqNum()).toString());
                                                properties.store(new FileOutputStream((String)object), null);
                                            }
                                            catch (IOException iOException) {
                                                System.out.println("Error @ creation of file " + (String)object);
                                            }
                                        }
                                        if (this.RegistrationCommandForAEN(n, string)) continue block20;
                                        System.out.println("AdapterRegistration.run() Adapter " + n + "not reg for AEN");
                                        break;
                                    }
                                    System.out.println("Invalid ctrl type, not Reg for AEN");
                                    break;
                                }
                            }
                            continue;
                        }
                        catch (VKOperationFailedException vKOperationFailedException) {
                            System.out.println("Exception in assigning ctrl type - REGAEN, not Reg for AEN");
                        }
                    }
                    break block30;
                }
                System.out.println("REG4 AEN -> Controller not found for REG AEN");
            }
            catch (Exception exception) {
                System.out.println("Exception @ adapter registration");
                exception.printStackTrace();
            }
        }
    }

    public void StoreAENSequenceInfo(int n, String string) {
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(7, 0, n, 20).getByteArray());
        try {
            int n2;
            Object object;
            try {
                object = new ProcessCommand(this.m_senderWWN, string, this.m_objFramework, this.m_cimomDetails, this.m_isCimomServer);
                n2 = ((ProcessCommand)object).fireDCMDCommand(networkDataPacket);
            }
            catch (Exception exception) {
                System.out.println("Exception in AENSequenceInfo fire");
            }
            object = networkDataPacket.getDataBuffer();
            n2 = NetworkToJavaConverter.byteArrayToInt((byte[])object);
            if (n2 != 0) {
                System.out.println("Failed to get Sequence Info, Status=" + Integer.toHexString(n2));
                return;
            }
            this.m_mrEvtLogInfo = new MR_EVT_LOG_INFO((byte[])object, 44);
        }
        catch (Exception exception) {
            System.out.println("AEN registration failed (Sequence Info Exception)");
            exception.printStackTrace();
            this.m_mrEvtLogInfo = null;
            return;
        }
    }

    public int getLastProcessedSeqNum(int n) {
        int n2 = 1;
        n2 = this.getSeqNumfromFile(n);
        System.out.println("AdapterRegistration.getLastProcessedSeqNum() clear " + this.m_mrEvtLogInfo.getshutdownSeqNum());
        System.out.println("AdapterRegistration.getLastProcessedSeqNum() boot " + this.m_mrEvtLogInfo.getbootSeqNum());
        System.out.println("AdapterRegistration.getLastProcessedSeqNum() new " + this.m_mrEvtLogInfo.getnewestSeqNum());
        if (n2 > this.m_mrEvtLogInfo.getnewestSeqNum()) {
            n2 = 1;
            return n2;
        }
        System.out.println("lastProcessedSeqNumber is" + n2);
        return n2;
    }

    private int getSeqNumfromFile(int n) {
        Object var2_2 = null;
        int n2 = this.m_mrEvtLogInfo.getnewestSeqNum();
        try {
            FileInputStream fileInputStream = null;
            Properties properties = new Properties();
            boolean bl = false;
            if (this.m_isCimomServer) {
                for (int i = 0; i < this.m_ctrlList.size(); ++i) {
                    int n3 = (Integer)this.m_ctrlList.get(i);
                    fileInputStream = new FileInputStream(CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + this.m_cimomDetails.getCIMMOMIP().toString().trim() + "_" + m_stdAdpPropertyFileName + i + ".properties");
                    properties.load(fileInputStream);
                    if (properties.getProperty(ADAPTER_ID) == null) {
                        System.out.println("AdapterRegistration.lastProcessedSeqNum()" + CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + this.m_cimomDetails.getCIMMOMIP().toString().trim() + "_" + m_stdAdpPropertyFileName + i + ".properties" + "File got corrupted...");
                        continue;
                    }
                    if (Integer.parseInt(properties.getProperty(ADAPTER_ID)) != n) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    String string = properties.getProperty(ADAPTER_LAST_SEQNUM);
                    System.out.println("AdapterRegistration.lastProcessedSeqNum() last processed seq no. from file = " + string.trim());
                    this.m_lastSeqNumTimeStamp = Integer.parseInt(properties.getProperty(ADAPTER_LAST_SEQNUM_TIMESTAMP));
                    System.out.println("AdapterRegistration.lastProcessedSeqNum() last processed seq no's time from file = " + this.m_lastSeqNumTimeStamp);
                    return Integer.parseInt(string.trim());
                }
                System.out.println("AdapterRegistration.lastProcessedSeqNum()" + CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + this.m_cimomDetails.getCIMMOMIP().toString().trim() + "_" + m_stdAdpPropertyFileName + n + ".properties" + "File got corrupted... returning last processed seq no. as clearSeqNum");
                return this.m_mrEvtLogInfo.getshutdownSeqNum();
            }
            for (int i = 0; i < this.m_ctrlList.size(); ++i) {
                int n4 = (Integer)this.m_ctrlList.get(i);
                fileInputStream = new FileInputStream(CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + m_stdAdpPropertyFileName + i + ".properties");
                properties.load(fileInputStream);
                if (properties.getProperty(ADAPTER_ID) == null) {
                    System.out.println("AdapterRegistration.lastProcessedSeqNum()" + CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + m_stdAdpPropertyFileName + i + ".properties" + "File got corrupted");
                    continue;
                }
                if (Integer.parseInt(properties.getProperty(ADAPTER_ID)) != n) continue;
                bl = true;
                break;
            }
            if (bl) {
                String string = properties.getProperty(ADAPTER_LAST_SEQNUM);
                System.out.println("AdapterRegistration.lastProcessedSeqNum() last processed seq no. from file = " + string.trim());
                this.m_lastSeqNumTimeStamp = Integer.parseInt(properties.getProperty(ADAPTER_LAST_SEQNUM_TIMESTAMP));
                System.out.println("AdapterRegistration.lastProcessedSeqNum() last processed seq no's time from file = " + this.m_lastSeqNumTimeStamp);
                return Integer.parseInt(string.trim());
            }
            System.out.println("AdapterRegistration.lastProcessedSeqNum()" + CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + m_stdAdpPropertyFileName + n + ".properties" + "File got corrupted.. returning last processed seq no. as clearSeqNum");
            return this.m_mrEvtLogInfo.getshutdownSeqNum();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.err.println("Error: in reading the m_qualified_log_file_name file.. returning last processed seq no. as clearSeqNum");
            return this.m_mrEvtLogInfo.getshutdownSeqNum();
        }
    }

    public int registerWithEventClass(int n, short s, byte by, int n2, String string) {
        int n3;
        byte[] byArray = new byte[316];
        byArray[4] = 0;
        byArray[5] = 1;
        NetworkToJavaConverter.intToByteArray(n2, byArray, 8);
        NetworkToJavaConverter.intToByteArray(112, byArray, 20);
        NetworkToJavaConverter.intToByteArray(72, byArray, 32);
        int n4 = 116;
        NetworkToJavaConverter.intToByteArray(1, byArray, n4);
        NetworkToJavaConverter.intToByteArray(n2, byArray, n4 + 4);
        NetworkToJavaConverter.unsignedShortTobyteArray(s, byArray, n4 + 8);
        byArray[n4 + 11] = by;
        NetworkToJavaConverter.intToByteArray(n, byArray, n4 + 12);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
        try {
            ProcessCommand processCommand = new ProcessCommand(this.m_senderWWN, string, this.m_objFramework, this.m_cimomDetails, this.m_isCimomServer);
            n3 = processCommand.fireDCMDCommand(networkDataPacket);
            if (n3 == 0) {
                System.out.println("Registartion fire Successful");
            } else {
                System.out.println("Registartion fire failure. return code = " + n3);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in Registartion fire");
        }
        byArray = networkDataPacket.getDataBuffer();
        int n5 = NetworkToJavaConverter.byteArrayToInt(byArray, 0);
        System.out.println("AdapterRegistration.registerWithEventClass() return value = " + n5);
        if (n5 != 0) {
            System.out.println("AdapterRegistration.registerWithEventClass() SL returned registarion failure");
            return n5;
        }
        n3 = NetworkToJavaConverter.byteArrayToInt(byArray, 44);
        System.out.println("********************************* ");
        System.out.println("Number of Controller registered for AEN= " + n3);
        m_uniqueAENIDHash.put(new Integer(n2), new Integer(NetworkToJavaConverter.byteArrayToInt(byArray, 112)));
        return n5;
    }

    public MR_EVT_LIST fireEventList(int n, int n2, int n3, String string) {
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(17040128);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[n2]);
        MR_EVT_CLASS_LOCALE mR_EVT_CLASS_LOCALE = new MR_EVT_CLASS_LOCALE();
        mR_EVT_CLASS_LOCALE.setlocale((short)-1);
        mR_EVT_CLASS_LOCALE.seteventClass((byte)0);
        int[] nArray = new int[3];
        nArray[0] = n;
        nArray[1] = NetworkToJavaConverter.byteArrayToInt(mR_EVT_CLASS_LOCALE.getByteArray());
        sL_DCMD_INPUT_T.setmbox(nArray);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(6, 3, n3, sL_DCMD_INPUT_T.getByteArray().length, sL_DCMD_INPUT_T.getByteArray()).getByteArray());
        byte[] byArray = null;
        MR_EVT_LIST mR_EVT_LIST = null;
        try {
            ProcessCommand processCommand = null;
            processCommand = new ProcessCommand(this.m_senderWWN, string, this.m_objFramework, this.m_cimomDetails, this.m_isCimomServer);
            int n4 = processCommand.fireDCMDCommand(networkDataPacket);
            byArray = new byte[sL_DCMD_INPUT_T.getByteArray().length];
            System.arraycopy(networkDataPacket.getDataBuffer(), 44, byArray, 0, byArray.length);
            mR_EVT_LIST = new MR_EVT_LIST(byArray, 32);
        }
        catch (Exception exception) {
            System.out.println("AdapterRegistration.fireEventList() Exception @ retrieving event list");
            return null;
        }
        return mR_EVT_LIST;
    }

    public ArrayList getEventList(int n, int n2, String string) {
        int n3;
        ArrayList<MR_EVT_DETAIL> arrayList = new ArrayList<MR_EVT_DETAIL>();
        int n4 = n;
        int n5 = this.m_mrEvtLogInfo.getnewestSeqNum();
        int n6 = n3 = n5 - n4 + 1;
        System.out.println("AdapterRegistration.getEventList() presisted event count to retrieve = " + n6);
        while (n6 > 0) {
            int n7 = 0;
            n7 = n6 > 32 ? 8200 : 264 + (n6 - 1) * 256;
            MR_EVT_LIST mR_EVT_LIST = this.fireEventList(n4, n7, n2, string);
            if (mR_EVT_LIST == null) break;
            for (int i = 0; i < mR_EVT_LIST.getcount(); ++i) {
                arrayList.add(mR_EVT_LIST.getEvent()[i]);
            }
            if (mR_EVT_LIST.getcount() >= 32) {
                n6 -= mR_EVT_LIST.getcount();
                n4 += mR_EVT_LIST.getcount();
                continue;
            }
            n6 = 0;
        }
        return arrayList;
    }

    public boolean RegistrationCommandForAEN(int n, String string) {
        boolean bl = false;
        int n2 = this.m_mrEvtLogInfo.getnewestSeqNum();
        if (this.m_mrEvtLogInfo != null) {
            int n3 = this.getLastProcessedSeqNum(n);
            System.out.println("AdapterRegistration.RegistrationCommandForAEN()lastPSeqNum from file = " + n3);
            ArrayList arrayList = new ArrayList();
            boolean bl2 = false;
            if (n3 == 1) {
                arrayList = this.getEventList(n3, n, string);
            } else {
                MR_EVT_DETAIL mR_EVT_DETAIL;
                arrayList = this.getEventList(n3, n, string);
                if (arrayList.size() == 1) {
                    mR_EVT_DETAIL = (MR_EVT_DETAIL)arrayList.get(0);
                    if (this.m_lastSeqNumTimeStamp != 0 && this.m_lastSeqNumTimeStamp == mR_EVT_DETAIL.gettimeStamp()) {
                        bl2 = true;
                        System.out.println("AdapterRegistration.RegistrationCommandForAEN() service got restarted");
                    }
                    arrayList.clear();
                } else if (arrayList.size() > 1) {
                    mR_EVT_DETAIL = (MR_EVT_DETAIL)arrayList.get(0);
                    if (this.m_lastSeqNumTimeStamp != 0 && this.m_lastSeqNumTimeStamp == mR_EVT_DETAIL.gettimeStamp()) {
                        arrayList.remove(0);
                        System.out.println("AdapterRegistration.RegistrationCommandForAEN() Timestamp is matching between file and eventlist entry");
                    } else {
                        arrayList.clear();
                    }
                }
            }
            if (arrayList.size() == 0 && !bl2) {
                int n4 = this.m_mrEvtLogInfo.getshutdownSeqNum();
                System.out.println("AdapterRegistration.RegistrationCommandForAEN() Try to get evtList from shutdown seq number = " + n4);
                arrayList = this.getEventList(n4, n, string);
            }
            System.out.println("AdapterRegistration.RegistrationCommandForAEN() presisted event list size = " + arrayList.size());
            if (arrayList.size() >= 1) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)arrayList.get(i);
                    System.out.println("AdapterRegistration.RegistrationCommandForAEN() event code = " + mR_EVT_DETAIL.getcode());
                    byte[] byArray = mR_EVT_DETAIL.getByteArray();
                    byte[] byArray2 = new byte[268];
                    for (int j = 0; j < byArray2.length; ++j) {
                        byArray2[j] = 0;
                    }
                    byte[] byArray3 = new byte[4];
                    NetworkToJavaConverter.intToByteArray(n, byArray3);
                    System.arraycopy(byArray3, 0, byArray2, 4, 4);
                    System.arraycopy(byArray, 0, byArray2, 12, byArray.length);
                    SL_EVENT_DETAIL_T sL_EVENT_DETAIL_T = new SL_EVENT_DETAIL_T(byArray2, 0);
                    PluginDataInfo pluginDataInfo = new PluginDataInfo();
                    pluginDataInfo.setBuffer(byArray2);
                    pluginDataInfo.setReceiverWWN(this.m_senderWWN);
                    pluginDataInfo.setSenderWWN(this.m_senderWWN);
                    if (this.m_isCimomServer) {
                        this.m_objFramework.ProcessCommand(4100, pluginDataInfo);
                        continue;
                    }
                    this.m_objFramework.ProcessCommand(4098, pluginDataInfo);
                }
            } else {
                System.out.println("AdapterRegistration.RegistrationCommandForAEN() presisted events notification got failed");
            }
            if (this.registerWithEventClass(n2 + 1, (short)-1, (byte)-1, n, string) != 0) {
                System.out.println("AdapterRegistration.RegistrationCommandForAEN() registration failure for controlleID = " + n);
            } else {
                bl = true;
            }
        } else {
            System.out.println("AdapterRegistration.RegistrationCommandForAEN() m_mrEvtLogInfo is null so, adapter registration failure ");
        }
        return bl;
    }

    public void unRegisterAEN() {
        Object object;
        System.out.println("Inside Controllers UnREG 4 AEN");
        if (!this.m_isCimomServer) {
            object = m_uniqueAENIDHash.keys();
            System.out.println("ennumuration have keys: " + object.hasMoreElements());
            if (!object.hasMoreElements()) {
                System.out.println("No need of unregistering");
                return;
            }
        }
        object = null;
        if (this.m_ctrlList != null) {
            object = this.m_ctrlList;
        }
        ArrayList arrayList = null;
        if (this.m_ctrlTypeList != null) {
            arrayList = this.m_ctrlTypeList;
        }
        String string = null;
        if (object != null) {
            block8: for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                Integer n = (Integer)((ArrayList)object).get(i);
                System.out.println("ctrl ID -> " + n);
                if (arrayList == null) continue;
                Integer n2 = (Integer)arrayList.get(i);
                System.out.println("ctrl Type -> " + n2);
                try {
                    switch (n2) {
                        case 1: {
                            string = PluginsWWN.getStorelibWWN();
                            if (!m_uniqueAENIDHash.containsKey(n)) continue block8;
                            this.UnRegistrationCommandForAEN(n, string);
                            break;
                        }
                        case 2: {
                            string = PluginsWWN.getStorelibIRWWN();
                            if (!m_uniqueAENIDHash.containsKey(n)) continue block8;
                            this.UnRegistrationCommandForAEN(n, string);
                            break;
                        }
                        case 3: {
                            string = PluginsWWN.getStorelibIRWWN();
                            if (!m_uniqueAENIDHash.containsKey(n)) continue block8;
                            this.UnRegistrationCommandForAEN(n, string);
                            break;
                        }
                        case 4: {
                            string = PluginsWWN.getCIMPluginWWN();
                            this.UnRegistrationCommandForAEN(n, string);
                            break;
                        }
                        default: {
                            System.out.println("Invalid ctrl type");
                            break;
                        }
                    }
                    continue;
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    System.out.println("Exception in assigning ctrl type - Reg4AEN");
                }
            }
        } else {
            System.out.println("REG4 AEN -> Controller not found for UNREG AEN");
        }
    }

    private void UnRegistrationCommandForAEN(int n, String string) {
        byte[] byArray = new byte[48];
        byArray[4] = 0;
        byArray[5] = 2;
        NetworkToJavaConverter.intToByteArray(n, byArray, 8);
        NetworkToJavaConverter.intToByteArray(4, byArray, 32);
        NetworkToJavaConverter.intToByteArray((Integer)m_uniqueAENIDHash.get(new Integer(n)), byArray, 20);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
        try {
            ProcessCommand processCommand = new ProcessCommand(this.m_senderWWN, string, this.m_objFramework, this.m_cimomDetails, this.m_isCimomServer);
            int n2 = processCommand.fireDCMDCommand(networkDataPacket);
            if (n2 == 0) {
                System.out.println("ctrlID: " + n + " Unique ID: " + (Integer)m_uniqueAENIDHash.get(new Integer(n)));
                System.out.println("UnRegistartion fire Successful");
            } else {
                System.out.println("ctrlID: " + n + " Unique ID: " + (Integer)m_uniqueAENIDHash.get(new Integer(n)));
                System.out.println("UnRegistartion fire failure");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in UnRegistartion fire");
        }
    }
}

