/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.FrameworkInterface;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_TIME_STAMP;
import SASKernel.LibraryAPI.StoreLib.SL_DCMD_INPUT_T;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import Services.NetworkDataPacket;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import plugins.ManageCIMOMServer;
import plugins.ProcessCommand;
import plugins.Utils.PluginsWWN;

public class AdapterSetTime {
    private FrameworkInterface m_objFramework = null;
    private int m_hour = 0;
    private int m_minute = 0;
    private int m_second = 0;
    private int m_year = 0;
    private int m_month = 0;
    private int m_day = 0;
    private ArrayList m_adpList = null;
    private ArrayList m_adpTypeList = null;
    private ManageCIMOMServer m_cimDetails = null;
    private boolean m_isCIMOM = false;
    private String m_senderWWN = null;
    private ArrayList m_uniqueAENIDList = new ArrayList();

    public AdapterSetTime(FrameworkInterface frameworkInterface, ArrayList arrayList, ArrayList arrayList2, ManageCIMOMServer manageCIMOMServer, boolean bl) {
        this.m_objFramework = frameworkInterface;
        this.m_adpList = arrayList;
        this.m_adpTypeList = arrayList2;
        this.m_cimDetails = manageCIMOMServer;
        this.m_isCIMOM = bl;
        try {
            this.m_senderWWN = this.m_isCIMOM ? PluginsWWN.getCIMOMMonitorWWN() : PluginsWWN.getMonitorWWN();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
    }

    public void setTime() {
        String string = null;
        if (this.m_adpList != null) {
            block8: for (int i = 0; i < this.m_adpList.size(); ++i) {
                Integer n = (Integer)this.m_adpList.get(i);
                Integer n2 = (Integer)this.m_adpTypeList.get(i);
                try {
                    switch (n2) {
                        case 1: {
                            string = PluginsWWN.getStorelibWWN();
                            long l = this.getControllerTimeMilliSecond(n, string);
                            long l2 = this.getSystemTimeMilliSecond();
                            long l3 = (l2 - l) / 1000L;
                            System.out.println("AdapterSetTime.setTime() difference Time = " + l3);
                            if (l3 <= 90L && l3 >= -90L) continue block8;
                            this.SetAdapterTimeDCMD(n, string);
                            break;
                        }
                        case 2: {
                            string = PluginsWWN.getStorelibIRWWN();
                            long l = this.getControllerTimeMilliSecond(n, string);
                            long l4 = this.getSystemTimeMilliSecond();
                            long l5 = (l4 - l) / 1000L;
                            System.out.println("AdapterSetTime.setTime() difference Time = " + l5);
                            if (l5 <= 90L && l5 >= -90L) continue block8;
                            this.SetAdapterTimeDCMD(n, string);
                            break;
                        }
                        case 3: {
                            string = PluginsWWN.getStorelibIRWWN();
                            long l = this.getControllerTimeMilliSecond(n, string);
                            long l6 = this.getSystemTimeMilliSecond();
                            long l7 = (l6 - l) / 1000L;
                            System.out.println("AdapterSetTime.setTime() difference Time = " + l7);
                            if (l7 <= 90L && l7 >= -90L) continue block8;
                            this.SetAdapterTimeDCMD(n, string);
                            break;
                        }
                        case 4: {
                            string = PluginsWWN.getStorelibIRWWN();
                            long l = this.getControllerTimeMilliSecond(n, string);
                            long l8 = this.getSystemTimeMilliSecond();
                            long l9 = (l8 - l) / 1000L;
                            System.out.println("AdapterSetTime.setTime() difference Time = " + l9);
                            if (l9 <= 90L && l9 >= -90L) continue block8;
                            this.SetAdapterTimeDCMD(n, string);
                            break;
                        }
                        default: {
                            if (this.m_isCIMOM) {
                                string = PluginsWWN.getCIMPluginWWN();
                                long l = this.getControllerTimeMilliSecond(n, string);
                                long l10 = this.getSystemTimeMilliSecond();
                                long l11 = (l10 - l) / 1000L;
                                System.out.println("AdapterSetTime.setTime() difference Time = " + l11);
                                if (l11 <= 90L && l11 >= -90L) continue block8;
                                this.SetAdapterTimeDCMD(n, string);
                                break;
                            }
                            System.out.println("Invalid ctrl type");
                            break;
                        }
                    }
                    continue;
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    System.out.println("Exception in assigning ctrl type - setTimeThread");
                }
            }
        } else {
            System.out.println("SetTimeThread -> Controller not found for setting the time");
        }
    }

    public void SetAdapterTimeDCMD(int n, String string) {
        this.getSystemTime();
        MR_TIME_STAMP mR_TIME_STAMP = new MR_TIME_STAMP();
        mR_TIME_STAMP.setyear((short)this.m_year);
        mR_TIME_STAMP.setmonth((byte)this.m_month);
        mR_TIME_STAMP.setday((byte)this.m_day);
        mR_TIME_STAMP.sethour((byte)this.m_hour);
        mR_TIME_STAMP.setmin((byte)this.m_minute);
        mR_TIME_STAMP.setsec((byte)this.m_second);
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(17301762);
        sL_DCMD_INPUT_T.setflags('\u0001');
        sL_DCMD_INPUT_T.setpData(mR_TIME_STAMP.getByteArray());
        int[] nArray = new int[3];
        nArray[0] = 0;
        sL_DCMD_INPUT_T.setmbox(nArray);
        NetworkDataPacket networkDataPacket = null;
        Object var7_7 = null;
        networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(6, 3, n, sL_DCMD_INPUT_T.getByteArray().length, sL_DCMD_INPUT_T.getByteArray()).getByteArray());
        try {
            ProcessCommand processCommand = null;
            processCommand = new ProcessCommand(this.m_senderWWN, string, this.m_objFramework, this.m_cimDetails, this.m_isCIMOM);
            int n2 = processCommand.fireDCMDCommand(networkDataPacket);
            if (n2 == 0) {
                System.out.println("set Ctrl time fire Successful");
            } else {
                System.out.println("set Ctrl time fire failure");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in set Ctrl time fire");
        }
    }

    public long getControllerTimeMilliSecond(int n, String string) {
        MR_TIME_STAMP mR_TIME_STAMP = null;
        long l = 0L;
        SL_DCMD_INPUT_T sL_DCMD_INPUT_T = new SL_DCMD_INPUT_T(new byte[32], 0);
        sL_DCMD_INPUT_T.setopCode(0x1080101);
        sL_DCMD_INPUT_T.setflags('\u0002');
        sL_DCMD_INPUT_T.setpData(new byte[8]);
        int[] nArray = new int[3];
        sL_DCMD_INPUT_T.setmbox(nArray);
        byte[] byArray = null;
        NetworkDataPacket networkDataPacket = null;
        networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(6, 3, n, sL_DCMD_INPUT_T.getByteArray().length, sL_DCMD_INPUT_T.getByteArray()).getByteArray());
        try {
            ProcessCommand processCommand = null;
            processCommand = new ProcessCommand(this.m_senderWWN, string, this.m_objFramework, this.m_cimDetails, this.m_isCIMOM);
            int n2 = processCommand.fireDCMDCommand(networkDataPacket);
            byArray = new byte[sL_DCMD_INPUT_T.getByteArray().length];
            System.arraycopy(networkDataPacket.getDataBuffer(), 44, byArray, 0, byArray.length);
            mR_TIME_STAMP = new MR_TIME_STAMP(byArray, 32);
            System.out.println("AdapterSetTime.fireGetTimerDCMD() ctrl timestamp = " + mR_TIME_STAMP.toString());
        }
        catch (Exception exception) {
            System.out.println("Exception in get Ctrl time fire");
            return 0L;
        }
        l = new GregorianCalendar(new Short(mR_TIME_STAMP.getyear()).intValue(), new Byte(mR_TIME_STAMP.getmonth()).intValue(), new Byte(mR_TIME_STAMP.getday()).intValue(), new Byte(mR_TIME_STAMP.gethour()).intValue(), new Byte(mR_TIME_STAMP.getmin()).intValue(), new Byte(mR_TIME_STAMP.getsec()).intValue()).getTimeInMillis();
        return l;
    }

    public void getSystemTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(11);
        int n2 = gregorianCalendar.get(12);
        int n3 = gregorianCalendar.get(13);
        int n4 = gregorianCalendar.get(1);
        int n5 = gregorianCalendar.get(2) + 1;
        int n6 = gregorianCalendar.get(5);
        this.m_hour = n;
        this.m_minute = n2;
        this.m_second = n3;
        this.m_year = n4;
        this.m_month = n5;
        this.m_day = n6;
    }

    public long getSystemTimeMilliSecond() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        byte by = (byte)gregorianCalendar.get(11);
        byte by2 = (byte)gregorianCalendar.get(12);
        byte by3 = (byte)gregorianCalendar.get(13);
        short s = (short)gregorianCalendar.get(1);
        byte by4 = (byte)(gregorianCalendar.get(2) + 1);
        byte by5 = (byte)gregorianCalendar.get(5);
        MR_TIME_STAMP mR_TIME_STAMP = new MR_TIME_STAMP();
        mR_TIME_STAMP.setday(by5);
        mR_TIME_STAMP.setmonth(by4);
        mR_TIME_STAMP.setyear(s);
        mR_TIME_STAMP.sethour(by);
        mR_TIME_STAMP.setmin(by2);
        mR_TIME_STAMP.setsec(by3);
        long l = 0L;
        System.out.println("AdapterSetTime.getSystemTimeStamp()System Time = " + mR_TIME_STAMP.toString());
        l = new GregorianCalendar(new Short(mR_TIME_STAMP.getyear()).intValue(), new Byte(mR_TIME_STAMP.getmonth()).intValue(), new Byte(mR_TIME_STAMP.getday()).intValue(), new Byte(mR_TIME_STAMP.gethour()).intValue(), new Byte(mR_TIME_STAMP.getmin()).intValue(), new Byte(mR_TIME_STAMP.getsec()).intValue()).getTimeInMillis();
        return l;
    }
}

