/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import plugins.AlertAction;
import plugins.AlertEventDetails;
import plugins.AlertSeverity;
import plugins.AlertsConfigData;
import plugins.AlertsGlobalConfig;

public class AlertConfigWriter {
    private Document doc;
    private String filename = null;

    public AlertConfigWriter() {
    }

    public AlertConfigWriter(String string) {
        this.filename = string;
    }

    public Element createXMLConfig(Document document, AlertsConfigData alertsConfigData) {
        this.doc = document;
        if (alertsConfigData == null) {
            System.out.println("no config");
        }
        Element element = this.doc.createElement("monitor-config");
        Element element2 = this.getActionsElement(alertsConfigData);
        Element element3 = this.getGlobalsElement(alertsConfigData);
        Element element4 = this.getEventsElement(alertsConfigData);
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        return element;
    }

    public void write(AlertsConfigData alertsConfigData) {
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exception) {
            return;
        }
        Element element = this.createXMLConfig(documentBuilder.newDocument(), alertsConfigData);
        this.doc.appendChild(element);
        DOMSource dOMSource = new DOMSource(this.doc);
        if (this.filename == null) {
            this.filename = "test.xml";
        }
        StreamResult streamResult = new StreamResult(this.filename);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            return;
        }
    }

    private Element getActionsElement(AlertsConfigData alertsConfigData) {
        Element element = this.doc.createElement("actions");
        if (alertsConfigData != null) {
            Enumeration enumeration = alertsConfigData.getActions();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                System.out.println(string);
                AlertAction alertAction = alertsConfigData.getAction(string);
                element.appendChild(this.getActionElement(alertAction));
            }
        }
        return element;
    }

    private Element getActionElement(AlertAction alertAction) {
        Element element = this.doc.createElement(alertAction.getName());
        Enumeration enumeration = alertAction.getParams();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = alertAction.getParam(string);
            for (int i = 0; i < arrayList.size(); ++i) {
                Element element2 = this.doc.createElement(string);
                Text text = this.doc.createTextNode((String)arrayList.get(i));
                element2.appendChild(text);
                element.appendChild(element2);
            }
        }
        return element;
    }

    private Element getGlobalsElement(AlertsConfigData alertsConfigData) {
        Element element = this.doc.createElement("global");
        Enumeration enumeration = alertsConfigData.getGlobals();
        while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            AlertsGlobalConfig alertsGlobalConfig = alertsConfigData.getGlobal(n);
            element.appendChild(this.getGlobalElement(alertsGlobalConfig));
        }
        return element;
    }

    private Element getGlobalElement(AlertsGlobalConfig alertsGlobalConfig) {
        Element element = this.doc.createElement("severity");
        Attr attr = this.doc.createAttribute("level");
        attr.setValue(AlertSeverity.getSeverityName(alertsGlobalConfig.getSeverity()));
        element.setAttributeNode(attr);
        int n = alertsGlobalConfig.getActionsCount();
        for (int i = 0; i < n; ++i) {
            AlertAction alertAction = alertsGlobalConfig.getAction(i);
            Element element2 = this.doc.createElement("do-" + alertAction.getName());
            element.appendChild(element2);
        }
        return element;
    }

    private Element getEventsElement(AlertsConfigData alertsConfigData) {
        Element element = this.doc.createElement("events");
        Enumeration enumeration = alertsConfigData.getAlertEvents();
        while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            AlertEventDetails alertEventDetails = alertsConfigData.getAlertEvent(n);
            element.appendChild(this.getEventElement(alertEventDetails));
        }
        return element;
    }

    private Element getEventElement(AlertEventDetails alertEventDetails) {
        Element element = this.doc.createElement("event");
        Attr attr = this.doc.createAttribute("id");
        attr.setValue(Integer.toString(alertEventDetails.getId()));
        Attr attr2 = this.doc.createAttribute("severity");
        attr2.setValue(AlertSeverity.getSeverityName(alertEventDetails.getSeverity()));
        element.setAttributeNode(attr);
        element.setAttributeNode(attr2);
        if (alertEventDetails.usesGlobal()) {
            Element element2 = this.doc.createElement("apply-global");
            element.appendChild(element2);
        }
        int n = alertEventDetails.getActionsCount();
        for (int i = 0; i < n; ++i) {
            AlertAction alertAction = alertEventDetails.getAction(i);
            Element element3 = this.doc.createElement("do-" + alertAction.getName());
            element.appendChild(element3);
        }
        return element;
    }
}

