/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.FrameworkInterface;
import Framework.PluginManagers.PluginDataInfo;
import Framework.PluginManagers.PluginInfo;
import Framework.PluginManagers.PluginInterface;
import Services.NetworkToJavaConverter;
import Services.StringEncoder;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Hashtable;

public class AuthenticatePlugIn
implements PluginInterface {
    private static final int majorGroup = 0;
    private static final int minorGroup = 1;
    private static final String version = "1.01";
    private static String description = "Authenticate Plugin version: 1.01";
    private static final String authenticatelibName = "Authenticate";
    private PluginInfo pluginInfo = new PluginInfo();
    private FrameworkInterface framework = null;
    private static Hashtable hash = new Hashtable();
    public static final long PASS_KEY_TIMEOUT = 300000L;
    public static final int FAILURE_PASSKEY_EXPIRED = 2;
    private static final String EXT_LAUNCH_FILE = "paosjhqahd.ashqk";
    private static final String SIGNATURE_ENCRYPTION_PASSWORD = "mso5fjq";

    @Override
    public boolean init(String string, FrameworkInterface frameworkInterface) {
        this.pluginInfo.setMajorGroup(0);
        this.pluginInfo.setMinorGroup(1);
        this.pluginInfo.setVersion(version);
        this.pluginInfo.setWWN(string);
        description = description + "  Native library: " + this.getNativeVersion();
        this.pluginInfo.setDescription(description);
        this.framework = frameworkInterface;
        return true;
    }

    @Override
    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    @Override
    public void shutdown() {
    }

    public native boolean processNativeCommand(byte[] var1);

    public native boolean isUnicodeSupported();

    private native String getNativeVersion();

    private boolean authenticateUser(PluginDataInfo pluginDataInfo) {
        try {
            byte[] byArray = pluginDataInfo.getBuffer();
            boolean bl = false;
            try {
                bl = this.isUnicodeSupported();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            if (!bl) {
                byte[] byArray2 = new String(byArray, 2, 256, "UTF-16LE").getBytes();
                byte[] byArray3 = new String(byArray, 258, 256, "UTF-16LE").getBytes();
                Arrays.fill(byArray, 2, byArray.length, (byte)0);
                System.arraycopy(byArray2, 0, byArray, 2, byArray2.length);
                System.arraycopy(byArray3, 0, byArray, 258, byArray3.length);
                pluginDataInfo.setBuffer(byArray);
            }
            return this.processNativeCommand(pluginDataInfo.getBuffer());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private boolean isSignatureTrusted(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(EXT_LAUNCH_FILE));
            String string2 = bufferedReader.readLine();
            StringEncoder stringEncoder = new StringEncoder(SIGNATURE_ENCRYPTION_PASSWORD);
            String string3 = stringEncoder.decrypt(string2);
            bufferedReader.close();
            return string3.equals(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private boolean generatePassKey(PluginDataInfo pluginDataInfo) {
        int n;
        byte[] byArray = pluginDataInfo.getBuffer();
        String string = new String(byArray, 8, n = NetworkToJavaConverter.byteArrayToInt(byArray, 4));
        if (!this.isSignatureTrusted(string)) {
            byte[] byArray2 = new byte[4];
            NetworkToJavaConverter.intToByteArray(1, byArray2);
            pluginDataInfo.setBuffer(byArray2);
            return false;
        }
        String string2 = "";
        boolean bl = false;
        do {
            if (hash.containsKey(string2 = new Long(Math.round(Math.random() * 100000.0)).toString())) continue;
            bl = true;
        } while (!bl);
        Long l = new Long(System.currentTimeMillis());
        byte[] byArray3 = new byte[4 + string2.length()];
        NetworkToJavaConverter.intToByteArray(string2.length(), byArray3);
        System.arraycopy(string2.getBytes(), 0, byArray3, 4, string2.length());
        hash.put(string2, l);
        pluginDataInfo.setBuffer(byArray3);
        return true;
    }

    private boolean validatePassKey(PluginDataInfo pluginDataInfo) {
        long l = System.currentTimeMillis();
        byte[] byArray = pluginDataInfo.getBuffer();
        int n = NetworkToJavaConverter.byteArrayToInt(byArray, 4);
        String string = new String(byArray, 8, n);
        Long l2 = (Long)hash.remove(string);
        byte[] byArray2 = new byte[4];
        if (l2 == null) {
            NetworkToJavaConverter.intToByteArray(1, byArray2);
        } else if (l - l2 > 300000L) {
            NetworkToJavaConverter.intToByteArray(2, byArray2);
        }
        pluginDataInfo.setBuffer(byArray2);
        return true;
    }

    @Override
    public boolean processCommand(PluginDataInfo pluginDataInfo) {
        short s = NetworkToJavaConverter.byteArrayToShort(pluginDataInfo.getBuffer(), 0);
        switch (s) {
            case 1: {
                return this.authenticateUser(pluginDataInfo);
            }
            case 2: {
                return this.generatePassKey(pluginDataInfo);
            }
            case 3: {
                return this.validatePassKey(pluginDataInfo);
            }
        }
        return false;
    }

    @Override
    public void preShutdown() {
    }

    @Override
    public void startupOperations() {
    }

    static {
        System.loadLibrary(authenticatelibName);
    }
}

