/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.ClientManagers.ClientInfo;
import Framework.ClientManagers.ClientManager;
import Framework.FrameworkInterface;
import Framework.PluginManagers.PluginDataInfo;
import Framework.PluginManagers.PluginInfo;
import Framework.PluginManagers.PluginInterface;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_ENCL_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_LOG_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_PD_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_TIME_STAMP;
import SASKernel.LibraryAPI.StoreLib.SL_EVENT_DETAIL_T;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import Services.CommonConstants;
import Services.KernelConstants;
import Services.LogXMLParser;
import Services.NetworkDataPacket;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import Services.WWNExtractor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import plugins.AdapterDetails;
import plugins.AdapterInfo;
import plugins.AdapterRegistration;
import plugins.AlertActionEmail;
import plugins.AlertConfigWriter;
import plugins.AlertEventDetails;
import plugins.AlertsConfigData;
import plugins.AlertsGlobalConfig;
import plugins.CIMOMStartups;
import plugins.EmailContent;
import plugins.EnclosureList;
import plugins.EventXMLFormation;
import plugins.Localization;
import plugins.MR_EVENT_ARGS;
import plugins.ManageCIMOMServer;
import plugins.ParseXMLString;
import plugins.PhysicalDeviceList;
import plugins.StorelibPlugin;
import plugins.Utils.PluginsWWN;
import plugins.Utils.Resource;
import plugins.XMLParser;

public class CIMOMMonitorService
implements PluginInterface,
CommonConstants,
MR_EVENT_ARGS {
    private static final int majorGroup = 0;
    private static final int minorGroup = 11;
    private static final String version = "1.10";
    private static final String description = "CIMMOM Monitor Plugin version: 1.10";
    private PluginInfo pluginInfo = new PluginInfo();
    public static FrameworkInterface m_objFramework = null;
    private String m_xmlString = "";
    private String m_localizedStr = "";
    private PluginDataInfo m_pluginDataInfo = null;
    public static SL_EVENT_DETAIL_T m_slObject = null;
    public static AdapterInfo[] m_ctrlInfo = null;
    public EventXMLFormation m_evtDesc = null;
    private AlertsConfigData m_alertConfig;
    private ManageCIMOMServer m_mangecimmom = null;
    private Hashtable m_cimomHash = new Hashtable();
    private Hashtable m_cimomClientHash = new Hashtable();
    private Hashtable m_cimomClientWWNHash = new Hashtable();
    private ArrayList<ManageCIMOMServer> m_cimomList = new ArrayList();
    private String m_qualified_popup_log_file_name = null;
    private int m_OldSequenceNum = 0;
    private static boolean m_isPopupStarted = false;

    @Override
    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    @Override
    public boolean init(String string, FrameworkInterface frameworkInterface) {
        System.out.println("Inside CIMMOMMonitor init");
        m_objFramework = frameworkInterface;
        this.pluginInfo.setMajorGroup(0);
        this.pluginInfo.setMinorGroup(11);
        this.pluginInfo.setVersion(version);
        this.pluginInfo.setWWN(string);
        this.pluginInfo.setDescription(description);
        this.m_qualified_popup_log_file_name = System.getProperty("user.dir") + File.separator + "popinit.logfrmboot";
        System.out.println("CIMMOMMonitor init over");
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean processCommand(PluginDataInfo var1_1) {
        this.m_pluginDataInfo = var1_1;
        var2_2 = this.m_pluginDataInfo.getCmd();
        switch (var2_2) {
            case 277: {
                System.out.println("CIMOMMonitorService.processCommand() Inside GET_CIMOM_VIVALDI_LOG_CFG");
                var3_3 = new WWNExtractor(this.m_pluginDataInfo.getSenderWWN());
                var4_7 = "";
                var5_11 = var3_3.getIP();
                for (var6_15 = 0; var6_15 < var5_11.length; ++var6_15) {
                    if (var6_15 != 0) {
                        var4_7 = var4_7 + ".";
                    }
                    var7_21 = var5_11[var6_15];
                    var4_7 = var4_7 + var7_21;
                }
                System.out.println("CIMOM sendVivaldiCfgtoCIMClients() Sender IPAddress = " + var4_7);
                var6_16 = (String)this.m_cimomClientHash.get(var4_7);
                var7_22 = (ManageCIMOMServer)this.m_cimomHash.get(var6_16);
                if (var7_22 == null) {
                    System.out.println("sendVivaldiCfgtoCIMClients() mangecimmom is null fill with default config");
                    var8_28 = new XMLParser();
                    try {
                        var8_28.parse(new FileInputStream(CIMOMStartups.m_stdDefaultConfigFilePath));
                    }
                    catch (IOException var9_33) {
                        System.out.println("I/O Exception");
                        var9_33.printStackTrace();
                        return false;
                    }
                    var9_34 = var8_28.getConfig();
                    if (var9_34 == null) {
                        System.out.println("Config is Null");
                        return false;
                    }
                    var10_42 = this.getVivaldiConfig(var9_34);
                    var1_1.setBuffer(var10_42);
                    return true;
                }
                var8_29 = new XMLParser();
                try {
                    var8_29.parse(new FileInputStream(var7_22.getConfigFileName()));
                }
                catch (IOException var9_35) {
                    System.out.println("I/O Exception");
                    var9_35.printStackTrace();
                    return false;
                }
                var9_36 = var8_29.getConfig();
                if (var9_36 == null) {
                    System.out.println("Config is Null");
                    return false;
                }
                var10_43 = this.getVivaldiConfig(var9_36);
                var1_1.setBuffer(var10_43);
                return true;
            }
            case 279: {
                System.out.println("CIMOMMonitorService.processCommand() inside GET_CIM_INITIAL_LOG_AS_STRING_ARRAY");
                this.getCIMInitialLog(this.m_pluginDataInfo);
                return true;
            }
            case 278: {
                System.out.println("CIMOMMonitorService.processCommand() inside POPUP_NOTIFICATION2MONITOR");
                CIMOMMonitorService.m_isPopupStarted = true;
                return true;
            }
            case 280: {
                System.out.println("CIMOMMonitorService.processCommand() inside GET_CIM_INITIAL_LOG_AS_STRING_ARRAY");
                this.clearCIMInitialLog(this.m_pluginDataInfo);
                return true;
            }
            case 276: {
                System.out.println("Inside MANAGE_CIMMOM_MONITOR");
                var3_4 = new ManageCIMOMServer(this.m_pluginDataInfo.getBuffer());
                var4_8 = new String(var3_4.getCIMMOMIP()).trim();
                System.out.println("IpAddress in manageCIMOM = " + var4_8);
                var5_12 = "";
                var6_17 = new WWNExtractor(var1_1.getSenderWWN());
                var7_23 = var6_17.getIP();
                for (var8_30 = 0; var8_30 < var7_23.length; ++var8_30) {
                    if (var8_30 != 0) {
                        var5_12 = var5_12 + ".";
                    }
                    var9_37 = var7_23[var8_30];
                    var5_12 = var5_12 + var9_37;
                }
                System.out.println("CIMOMMonitorService.processCommand() senderIP " + var5_12);
                this.m_cimomClientHash.put(var5_12, var4_8);
                this.m_cimomClientWWNHash.put(var1_1.getSenderWWN(), var4_8);
                var8_30 = 0;
                var9_38 = new byte[4];
                NetworkToJavaConverter.intToByteArray(var8_30, var9_38);
                var1_1.setBuffer(var9_38);
                if (!this.m_cimomHash.containsKey(var4_8)) {
                    var10_44 = new CIMOMStartups(var3_4, CIMOMMonitorService.m_objFramework);
                    System.out.println("mangecimmom obj Startup started");
                    this.m_cimomHash.put(var4_8, var3_4);
                    this.m_cimomList.add(var3_4);
                } else {
                    System.out.println("CIMOMMonitorService.processCommand() already managing this server");
                }
                return true;
            }
            case 4100: {
                System.out.println("PLUGIN_CIM_CALLBACK");
                CIMOMMonitorService.m_slObject = new SL_EVENT_DETAIL_T(this.m_pluginDataInfo.getBuffer(), 0);
                System.out.println("Event id = " + CIMOMMonitorService.m_slObject.getevtDetail().getcode() + "\n" + "Sequnce number = " + CIMOMMonitorService.m_slObject.getevtDetail().getseqNum() + "\n" + "Event Description = " + new String(CIMOMMonitorService.m_slObject.getevtDetail().getdescription()));
                if (CIMOMMonitorService.m_slObject.getevtDetail().getcl().geteventClass() == -1) break;
                var3_5 = new WWNExtractor(var1_1.getSenderWWN());
                var4_9 = "";
                var5_13 = var3_5.getIP();
                for (var6_18 = 0; var6_18 < var5_13.length; ++var6_18) {
                    if (var6_18 != 0) {
                        var4_9 = var4_9 + ".";
                    }
                    var7_24 = var5_13[var6_18];
                    var4_9 = var4_9 + var7_24;
                }
                System.out.println("CIMOM Server IPAddress = " + var4_9);
                this.m_mangecimmom = (ManageCIMOMServer)this.m_cimomHash.get(var4_9);
                if (this.m_mangecimmom == null) {
                    System.out.println("mangecimmom is nnull can't handle this event");
                    break;
                }
                CIMOMMonitorService.m_ctrlInfo = this.m_mangecimmom.getArrayOfAdapterInfo();
                if (CIMOMMonitorService.m_slObject == null) {
                    System.out.println("mrObject||  slObject is nnull can't handle this event");
                    break;
                }
                var6_19 = new XMLParser();
                try {
                    var6_19.parse(new FileInputStream(this.m_mangecimmom.getConfigFileName()));
                }
                catch (IOException var7_25) {
                    System.out.println("I/O Exception while loading config file");
                    var7_25.printStackTrace();
                }
                this.m_alertConfig = var6_19.getConfig();
                if (this.m_alertConfig == null) {
                    System.out.println("Config is Null");
                    break;
                }
                this.m_mangecimmom.updateEmailCfg(this.m_alertConfig);
                var7_26 = this.m_mangecimmom.getControllerList();
                var8_31 = this.getControllerIndex(CIMOMMonitorService.m_slObject.getctrlId(), var7_26);
                switch (CIMOMMonitorService.m_slObject.getevtDetail().getcode()) {
                    case 91: 
                    case 112: 
                    case 166: 
                    case 167: 
                    case 462: 
                    case 463: {
                        if (this.storeLatestSequenceNumber()) {
                            if (this.getSeqNum() >= this.m_OldSequenceNum) {
                                var9_39 = null;
                                try {
                                    var9_39 = new EnclosureList(CIMOMMonitorService.m_slObject.getctrlId(), PluginsWWN.getCIMOMMonitorWWN(), PluginsWWN.getCIMPluginWWN(), CIMOMMonitorService.m_objFramework, this.m_mangecimmom, true);
                                    var10_45 = var9_39.getMR_ENCL_LIST();
                                    CIMOMMonitorService.m_ctrlInfo[var8_31].setEnclList((MR_ENCL_LIST)var10_45);
                                }
                                catch (VKOperationFailedException var10_46) {
                                    System.out.println("Exception at getting EnclList once got MR_EVT_ENCL_COMMUNICATION_LOST | MR_EVT_ENCL_COMMUNICATION_Restored Event");
                                }
                                var10_45 = null;
                                try {
                                    var10_45 = new PhysicalDeviceList(CIMOMMonitorService.m_slObject.getctrlId(), PluginsWWN.getCIMOMMonitorWWN(), PluginsWWN.getCIMPluginWWN(), CIMOMMonitorService.m_objFramework, this.m_mangecimmom, true);
                                    var11_60 = var10_45.getMR_PD_LIST();
                                    CIMOMMonitorService.m_ctrlInfo[var8_31].setPDList((MR_PD_LIST)var11_60);
                                }
                                catch (VKOperationFailedException var11_61) {
                                    System.out.println("Exception at getting PDList once got MR_EVT_ENCL_COMMUNICATION_LOST | MR_EVT_ENCL_COMMUNICATION_Restored Event");
                                }
                            }
                        } else {
                            var9_39 = null;
                            try {
                                var9_39 = new EnclosureList(CIMOMMonitorService.m_slObject.getctrlId(), PluginsWWN.getCIMOMMonitorWWN(), PluginsWWN.getCIMPluginWWN(), CIMOMMonitorService.m_objFramework, this.m_mangecimmom, true);
                                var10_45 = var9_39.getMR_ENCL_LIST();
                                CIMOMMonitorService.m_ctrlInfo[var8_31].setEnclList((MR_ENCL_LIST)var10_45);
                            }
                            catch (VKOperationFailedException var10_47) {
                                System.out.println("Exception at getting EnclList once got MR_EVT_ENCL_COMMUNICATION_LOST | MR_EVT_ENCL_COMMUNICATION_Restored Event");
                            }
                            var10_45 = null;
                            try {
                                var10_45 = new PhysicalDeviceList(CIMOMMonitorService.m_slObject.getctrlId(), PluginsWWN.getCIMOMMonitorWWN(), PluginsWWN.getCIMPluginWWN(), CIMOMMonitorService.m_objFramework, this.m_mangecimmom, true);
                                var11_60 = var10_45.getMR_PD_LIST();
                                CIMOMMonitorService.m_ctrlInfo[var8_31].setPDList((MR_PD_LIST)var11_60);
                            }
                            catch (VKOperationFailedException var11_62) {
                                System.out.println("Exception at getting PDList once got MR_EVT_ENCL_COMMUNICATION_LOST | MR_EVT_ENCL_COMMUNICATION_Restored Event");
                            }
                        }
                        this.m_mangecimmom.updtaeArrayOfAdapterInfo(CIMOMMonitorService.m_ctrlInfo);
                        break;
                    }
                    case 141: 
                    case 161: {
                        if (this.storeLatestSequenceNumber()) {
                            if (this.getSeqNum() >= this.m_OldSequenceNum) {
                                var9_39 = null;
                                try {
                                    var9_39 = new PhysicalDeviceList(CIMOMMonitorService.m_slObject.getctrlId(), PluginsWWN.getCIMOMMonitorWWN(), PluginsWWN.getCIMPluginWWN(), CIMOMMonitorService.m_objFramework, this.m_mangecimmom, true);
                                    var10_45 = var9_39.getMR_PD_LIST();
                                    CIMOMMonitorService.m_ctrlInfo[var8_31].setPDList((MR_PD_LIST)var10_45);
                                }
                                catch (VKOperationFailedException var10_48) {
                                    System.out.println("Exception at getting PDList once got a Event");
                                }
                            }
                        } else {
                            var9_39 = null;
                            try {
                                var9_39 = new PhysicalDeviceList(CIMOMMonitorService.m_slObject.getctrlId(), PluginsWWN.getCIMOMMonitorWWN(), PluginsWWN.getCIMPluginWWN(), CIMOMMonitorService.m_objFramework, this.m_mangecimmom, true);
                                var10_45 = var9_39.getMR_PD_LIST();
                                CIMOMMonitorService.m_ctrlInfo[var8_31].setPDList((MR_PD_LIST)var10_45);
                            }
                            catch (VKOperationFailedException var10_49) {
                                System.out.println("Exception at getting PDList once got a Event");
                            }
                        }
                        this.m_mangecimmom.updtaeArrayOfAdapterInfo(CIMOMMonitorService.m_ctrlInfo);
                        break;
                    }
                    case 1: {
                        try {
                            var9_39 = new EmailContent(CIMOMMonitorService.m_slObject.getctrlId(), PluginsWWN.getCIMOMMonitorWWN(), PluginsWWN.getCIMPluginWWN(), CIMOMMonitorService.m_objFramework, this.m_mangecimmom, true, CIMOMMonitorService.m_ctrlInfo[var8_31].getMR_CTRL_INFO());
                            CIMOMMonitorService.m_ctrlInfo[var8_31].setEmailContent((EmailContent)var9_39);
                            break;
                        }
                        catch (Exception var9_40) {
                            System.out.println("CIMOMMonitorService.processCommand() exception while updating the FW version");
                            var9_40.printStackTrace();
                        }
                    }
                }
                try {
                    var10_50 = CIMOMMonitorService.m_slObject.getevtDetail().getcode();
                    var9_39 = this.m_alertConfig.getAlertEvent(var10_50);
                    if (var9_39.usesGlobal()) {
                        var11_60 = this.m_alertConfig.getGlobal(var9_39.getSeverity());
                        if (var11_60 != null && var11_60.getActionsCount() <= 0) {
                            break;
                        }
                    } else if (var9_39.getActionsCount() <= 0) {
                    }
                    ** GOTO lbl218
                }
                catch (Exception var10_51) {
                    System.out.println("Don't have a alert Event");
                }
                break;
lbl218:
                // 2 sources

                this.m_evtDesc.setAdapterInformation(CIMOMMonitorService.m_ctrlInfo);
                this.m_evtDesc.setControllerIndex(var8_31);
                this.m_xmlString = this.m_evtDesc.getEventXMLFormat(true, var4_9, CIMOMMonitorService.m_slObject);
                var10_52 = new LogXMLParser(this.m_xmlString);
                var11_63 = var9_39.getSeverity();
                var10_52.setTagValue("class", Integer.toString(var11_63));
                this.m_xmlString = var10_52.getXML();
                this.m_localizedStr = this.getEventinLocFormat(this.m_xmlString);
                var12_69 = var10_52.getMessageClass();
                var13_73 = this.m_xmlString;
                try {
                    var14_77 = new PrintWriter(new BufferedWriter(new FileWriter(this.m_mangecimmom.getLogFileName(), true)));
                    var14_77.println(var13_73);
                    var14_77.close();
                }
                catch (IOException var14_78) {
                    System.out.println("IOException in CIMOM Monitor Service -> SlCallback write a event in a file");
                }
                var14_79 = CIMOMMonitorService.m_slObject.getctrlId();
                var15_83 = new Properties();
                try {
                    var16_86 = new File(CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + this.m_mangecimmom.getCIMMOMIP().toString().trim() + "_" + AdapterRegistration.m_stdAdpPropertyFileName + var8_31 + ".properties");
                    if (var16_86.exists()) {
                        var15_83.load(new FileInputStream((File)var16_86));
                        if (var15_83.getProperty("ADAPTER_ID") == null) {
                            var15_83.setProperty("ADAPTER_INDEX", new Integer(var8_31).toString());
                            var15_83.setProperty("ADAPTER_ID", new Integer(var14_79).toString());
                            var15_83.setProperty("ADAPTER_LAST_SEQNUM", new Integer(CIMOMMonitorService.m_slObject.getevtDetail().getseqNum()).toString());
                            var15_83.setProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP", new Integer(CIMOMMonitorService.m_slObject.getevtDetail().gettimeStamp()).toString());
                        } else if (Integer.parseInt(var15_83.getProperty("ADAPTER_ID")) == var14_79) {
                            var15_83.remove("ADAPTER_LAST_SEQNUM");
                            var15_83.setProperty("ADAPTER_LAST_SEQNUM", new Integer(CIMOMMonitorService.m_slObject.getevtDetail().getseqNum()).toString());
                            if (var15_83.getProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP") == null) {
                                var15_83.setProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP", new Integer(CIMOMMonitorService.m_slObject.getevtDetail().gettimeStamp()).toString());
                            } else {
                                var15_83.remove("ADAPTER_LAST_SEQNUM_TIMESTAMP");
                                var15_83.setProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP", new Integer(CIMOMMonitorService.m_slObject.getevtDetail().gettimeStamp()).toString());
                            }
                        } else {
                            var15_83.remove("ADAPTER_LAST_SEQNUM");
                            var15_83.remove("ADAPTER_ID");
                            var15_83.remove("ADAPTER_INDEX");
                            var15_83.setProperty("ADAPTER_INDEX", new Integer(var8_31).toString());
                            var15_83.setProperty("ADAPTER_ID", new Integer(var14_79).toString());
                            var15_83.setProperty("ADAPTER_LAST_SEQNUM", new Integer(CIMOMMonitorService.m_slObject.getevtDetail().getseqNum()).toString());
                            if (var15_83.getProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP") == null) {
                                var15_83.setProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP", new Integer(CIMOMMonitorService.m_slObject.getevtDetail().gettimeStamp()).toString());
                            } else {
                                var15_83.remove("ADAPTER_LAST_SEQNUM_TIMESTAMP");
                                var15_83.setProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP", new Integer(CIMOMMonitorService.m_slObject.getevtDetail().gettimeStamp()).toString());
                            }
                        }
                    } else {
                        System.out.println("CIMOMMonitorService.processCommand() file not found " + var16_86.getName());
                        var16_86.createNewFile();
                        var15_83.load(new FileInputStream((File)var16_86));
                        var15_83.setProperty("ADAPTER_INDEX", new Integer(var8_31).toString());
                        var15_83.setProperty("ADAPTER_ID", new Integer(var14_79).toString());
                        var15_83.setProperty("ADAPTER_LAST_SEQNUM", new Integer(CIMOMMonitorService.m_slObject.getevtDetail().getseqNum()).toString());
                        var15_83.setProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP", new Integer(CIMOMMonitorService.m_slObject.getevtDetail().gettimeStamp()).toString());
                    }
                    var15_83.store(new FileOutputStream((File)var16_86), null);
                }
                catch (Exception var16_87) {
                    var16_87.printStackTrace();
                }
                if (var12_69 < 0 || var12_69 > 4) {
                    System.out.println("Severity = " + var12_69 + " Seq Num = " + CIMOMMonitorService.m_slObject.getevtDetail().getseqNum());
                    var12_69 = 0;
                }
                try {
                    if (var9_39.usesGlobal()) {
                        System.out.println("using global");
                        var16_86 = this.m_alertConfig.getGlobal(var12_69);
                        if (var16_86 == null) break;
                        if (var16_86.hasAction("vivaldilog")) {
                            // empty if block
                        }
                        if (var16_86.hasAction("email")) {
                            var17_100 = Resource.getString("EVENT_ID", "Event ID:");
                            this.m_localizedStr = this.m_localizedStr + '\n' + var17_100 + this.getEventCode();
                            this.alertActionEmail(this.m_localizedStr, var12_69);
                        }
                        if (var16_86.hasAction("systemlog")) {
                            this.alertActionSysLog(this.m_localizedStr, var12_69);
                        }
                        if (!var16_86.hasAction("popup")) break;
                        this.alertActionPopup(var13_73);
                        break;
                    }
                    System.out.println("not using global");
                    var16_88 = var9_39.getActionsCount();
                    System.out.println("action Count ->" + var16_88);
                    if (var9_39.hasAction("vivaldilog")) {
                        // empty if block
                    }
                    if (var9_39.hasAction("email")) {
                        var17_101 = Resource.getString("EVENT_ID", "Event ID:");
                        this.m_localizedStr = this.m_localizedStr + '\n' + var17_101 + this.getEventCode();
                        this.alertActionEmail(this.m_localizedStr, var12_69);
                    }
                    if (var9_39.hasAction("systemlog")) {
                        this.alertActionSysLog(this.m_localizedStr, var12_69);
                    }
                    if (!var9_39.hasAction("popup")) break;
                    this.alertActionPopup(var13_73);
                }
                catch (Exception var16_89) {
                    System.out.println("Don't have a alert Action");
                }
                break;
            }
            case 2: {
                System.out.println("CIMOMMonitorService.processCommand() inside REQUEST_TYPE_CLIENT_PASSTHROUGH ");
                var3_6 = this.m_pluginDataInfo.getBuffer();
                var4_10 = new String(var3_6);
                var5_14 = new ParseXMLString();
                var6_20 = var5_14.getAction(var4_10);
                System.out.println(var6_20);
                var7_27 = new WWNExtractor(var1_1.getSenderWWN());
                var8_32 = "";
                var9_41 = var7_27.getIP();
                for (var10_53 = 0; var10_53 < var9_41.length; ++var10_53) {
                    if (var10_53 != 0) {
                        var8_32 = var8_32 + ".";
                    }
                    var11_64 = var9_41[var10_53];
                    var8_32 = var8_32 + var11_64;
                }
                System.out.println("CIMOMMonitorService.processCommand() senderIP " + var8_32);
                this.m_mangecimmom = (ManageCIMOMServer)this.m_cimomHash.get(this.m_cimomClientHash.get(var8_32));
                if (var6_20.equalsIgnoreCase("config-request")) {
                    try {
                        var10_54 = new FileInputStream(this.m_mangecimmom.getConfigFileName());
                        var11_65 = new DataInputStream(var10_54);
                        var12_70 = new BufferedReader(new InputStreamReader(var11_65));
                        var13_74 = "";
                        while ((var14_80 = var12_70.readLine()) != null) {
                            var13_74 = var13_74 + var14_80;
                        }
                        var11_65.close();
                        this.m_pluginDataInfo.setBuffer(var13_74.getBytes());
                    }
                    catch (Exception var10_55) {
                        var11_66 = "<monitorcontrol><error/></monitorcontrol>";
                        this.m_pluginDataInfo.setBuffer(var11_66.getBytes());
                        System.err.println("File read Error: " + var10_55.getMessage());
                    }
                    break;
                }
                if (var6_20.equalsIgnoreCase("monitor-config")) {
                    var10_56 = var5_14.getNode(var4_10);
                    var11_67 = new XMLParser();
                    if (var10_56 != null) {
                        var11_67.treatConfig(var10_56);
                    }
                    var12_71 = var11_67.getConfig();
                    var13_75 = var12_71.getAction("email");
                    var14_81 = new ArrayList<String>();
                    var15_84 = null;
                    if (var13_75 != null) {
                        try {
                            var16_90 = false;
                            var17_102 = null;
                            var17_102 = InetAddress.getByName((String)var13_75.getParam("nic").get(0));
                            var18_104 = InetAddress.getByName((String)var13_75.getParam("servername").get(0));
                            var19_106 = NetworkInterface.getByInetAddress((InetAddress)var17_102);
                            if (var19_106 != null && !var19_106.isLoopback()) {
                                var16_90 = this.isSMTPReachable((InetAddress)var18_104, (InetAddress)var17_102);
                            }
                            System.out.println("CURRENT IP IS::" + var17_102.getHostAddress() + " SMTP IP IS::" + var18_104.getHostAddress() + " \n LOCAL IP IS::" + var13_75.getParam("nic").get(0));
                            if (!var16_90 && (var15_84 = this.isSmtpInSameSubnet((String)var13_75.getParam("servername").get(0))) != null) {
                                var14_81.add(var15_84);
                                var13_75.setParam("nic", var14_81);
                            }
                        }
                        catch (UnknownHostException var16_91) {
                            var16_91.printStackTrace();
                        }
                        catch (SocketException var16_92) {
                            var16_92.printStackTrace();
                        }
                        catch (IOException var16_93) {
                            var16_93.printStackTrace();
                            return false;
                        }
                    }
                    this.m_alertConfig = var12_71;
                    var16_94 = var11_67.getConfig();
                    this.sendVivaldiCfgtoCIMClients(var16_94);
                    var17_102 = new AlertConfigWriter(this.m_mangecimmom.getConfigFileName());
                    var17_102.write(this.m_alertConfig);
                    this.m_mangecimmom.updateEmailCfg(this.m_alertConfig);
                    var18_104 = "<monitorcontrol><done/></monitorcontrol>";
                    this.m_pluginDataInfo.setBuffer(var18_104.getBytes());
                    break;
                }
                if (var6_20.equalsIgnoreCase("test-mail")) {
                    var10_57 = var5_14.getChildNode(var4_10);
                    var11_68 = new XMLParser();
                    if (var10_57 != null) {
                        var11_68.treatConfig(var10_57);
                    }
                    var12_72 = var11_68.getConfig();
                    var13_76 = var12_72.getAction("email");
                    var14_82 = new ArrayList<String>();
                    var15_85 = null;
                    if (var13_76 != null) {
                        try {
                            var16_95 = false;
                            var17_103 = null;
                            var13_76.setParam("nic", this.m_alertConfig.getAction("email").getParam("nic"));
                            var17_103 = InetAddress.getByName((String)var13_76.getParam("nic").get(0));
                            var18_105 = Inet4Address.getByName((String)var13_76.getParam("servername").get(0));
                            var19_107 = NetworkInterface.getByInetAddress((InetAddress)var17_103);
                            if (var19_107 != null && !var19_107.isLoopback()) {
                                var16_95 = this.isSMTPReachable((InetAddress)var18_105, (InetAddress)var17_103);
                            }
                            System.out.println("CURRENT IP IS::" + var17_103.getHostAddress() + " SMTP IP IS::" + var18_105.getHostAddress() + " \n LOCAL IP IS::" + var13_76.getParam("nic").get(0));
                            if (!var16_95 && (var15_85 = this.isSmtpInSameSubnet((String)var13_76.getParam("servername").get(0))) != null) {
                                var14_82.add(var15_85);
                                var13_76.setParam("nic", var14_82);
                            }
                        }
                        catch (UnknownHostException var16_96) {
                            var16_96.printStackTrace();
                        }
                        catch (SocketException var16_97) {
                            var16_97.printStackTrace();
                        }
                        catch (IOException var16_98) {
                            var16_98.printStackTrace();
                        }
                    }
                    this.m_alertConfig = var12_72;
                    var16_99 = new AlertConfigWriter(this.m_mangecimmom.getConfigFileName());
                    var16_99.write(this.m_alertConfig);
                    this.m_mangecimmom.updateEmailCfg(this.m_alertConfig);
                    var17_103 = new AlertActionEmail();
                    var17_103.setServerName(this.m_mangecimmom.getEmailServerName());
                    var17_103.setSenderName(this.m_mangecimmom.getSenderMail());
                    var17_103.setTargetName(this.m_mangecimmom.getTarget());
                    var17_103.setUserName(this.m_mangecimmom.getUserName());
                    var17_103.setPassword(this.m_mangecimmom.getPassword());
                    var17_103.setAuthentication(this.m_mangecimmom.getAuthenticationType());
                    var17_103.setSMTPPortNum(this.m_mangecimmom.getSMTPPortNum());
                    var17_103.setSenderNICAddress(this.m_mangecimmom.getLocalServerNICAddr());
                    var18_105 = var11_68.getConfig();
                    this.sendVivaldiCfgtoCIMClients((AlertsConfigData)var18_105);
                    var17_103.setMailSubject(this.getMailSubject(0));
                    var19_107 = new StringBuffer();
                    var19_107.append(Resource.getString("TEST_EMAIL", "Testing the Email Configuration."));
                    var19_107.append("\n");
                    var19_107.append(Resource.getString("GENERATE", "Generated On: "));
                    var20_108 = new Date();
                    var19_107.append(var20_108.toString());
                    var17_103.setMailBody(new String((StringBuffer)var19_107));
                    var21_109 = "";
                    var22_110 = var17_103.sendTestMail();
                    if (var22_110) {
                        System.out.println("Mail delivered successfully");
                        var21_109 = "<monitorcontrol><done/></monitorcontrol>";
                    } else {
                        System.out.println("Exception @ sending test email");
                        var21_109 = "<monitorcontrol><error/></monitorcontrol>";
                    }
                    this.m_pluginDataInfo.setBuffer(var21_109.getBytes());
                    break;
                }
                if (var6_20.equalsIgnoreCase("stop")) {
                    var10_58 = "<monitorcontrol><done/></monitorcontrol>";
                    this.m_pluginDataInfo.setBuffer(var10_58.getBytes());
                    break;
                }
                System.out.println("no cfg related operation");
                var10_59 = "<monitorcontrol><error/></monitorcontrol>";
                this.m_pluginDataInfo.setBuffer(var10_59.getBytes());
                break;
            }
            default: {
                System.out.println("Default Command frm Monitor");
                System.out.println("Req Type-> " + var2_2);
            }
        }
        return true;
    }

    public int getControllerIndex(int n, ArrayList arrayList) {
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            AdapterDetails adapterDetails = (AdapterDetails)arrayList.get(i);
            if (n != adapterDetails.getControllerID()) continue;
            n2 = adapterDetails.getControllerIndex();
            break;
        }
        return n2;
    }

    private void alertActionEmail(String string, int n) {
        String string2;
        int n2;
        System.out.println("Do Email");
        AlertActionEmail alertActionEmail = new AlertActionEmail();
        alertActionEmail.setServerName(this.m_mangecimmom.getEmailServerName());
        alertActionEmail.setSenderName(this.m_mangecimmom.getSenderMail());
        alertActionEmail.setTargetName(this.m_mangecimmom.getTarget());
        alertActionEmail.setUserName(this.m_mangecimmom.getUserName());
        alertActionEmail.setPassword(this.m_mangecimmom.getPassword());
        alertActionEmail.setAuthentication(this.m_mangecimmom.getAuthenticationType());
        alertActionEmail.setSenderNICAddress(this.m_mangecimmom.getLocalServerNICAddr());
        alertActionEmail.setSMTPPortNum(this.m_mangecimmom.getSMTPPortNum());
        alertActionEmail.setMailSubject(this.getMailSubject(n));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("\n");
        stringBuffer.append(Resource.getString("GENERATE", "Generated On: "));
        MR_TIME_STAMP mR_TIME_STAMP = KernelConstants.getTimeStamp(m_slObject.getevtDetail().gettimeStamp());
        Date date = new Date(mR_TIME_STAMP.getyear(), mR_TIME_STAMP.getmonth(), mR_TIME_STAMP.getday(), mR_TIME_STAMP.gethour(), mR_TIME_STAMP.getmin(), mR_TIME_STAMP.getsec());
        stringBuffer.append(date.toString());
        stringBuffer.append("\n\n");
        ArrayList arrayList = this.m_mangecimmom.getControllerList();
        int n3 = this.getControllerIndex(m_slObject.getctrlId(), arrayList);
        EmailContent emailContent = m_ctrlInfo[n3].getEmailContent();
        for (n2 = 0; n2 < emailContent.getDriverDetails().size(); ++n2) {
            string2 = (String)emailContent.getDriverDetails().get(n2);
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        for (n2 = 0; n2 < emailContent.getImageDetails().size(); ++n2) {
            string2 = (String)emailContent.getImageDetails().get(n2);
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
        alertActionEmail.setMailBody(new String(stringBuffer));
        alertActionEmail.sendTestMail();
    }

    private void alertActionMSMLog(String string) {
        byte[] byArray = string.getBytes();
        System.out.println("do msm log");
        PluginDataInfo pluginDataInfo = new PluginDataInfo();
        pluginDataInfo.setBuffer(byArray);
        pluginDataInfo.setCmd(1);
        try {
            pluginDataInfo.setReceiverWWN(PluginsWWN.getLoggerWWN());
            pluginDataInfo.setSenderWWN(PluginsWWN.getCIMOMMonitorWWN());
            m_objFramework.ProcessCommand(1, pluginDataInfo);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("Error - assigning Logger WWN as receiver in Monitorplugin");
        }
    }

    private void alertActionPopup(String string) {
        byte[] byArray = string.getBytes();
        System.out.println("Do Pop Up");
        PluginDataInfo pluginDataInfo = new PluginDataInfo();
        pluginDataInfo.setBuffer(byArray);
        boolean bl = false;
        pluginDataInfo.setCmd(2);
        try {
            PrintWriter printWriter;
            if (m_isPopupStarted) {
                pluginDataInfo.setReceiverWWN(this.getPopupWWN());
                pluginDataInfo.setSenderWWN(PluginsWWN.getMonitorWWN());
                bl = m_objFramework.ProcessCommand(2, pluginDataInfo);
            } else {
                try {
                    bl = true;
                    printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.m_qualified_popup_log_file_name, true)));
                    printWriter.println(string);
                    printWriter.close();
                    System.out.println("Event writted in m_qualified_popup_log_file_name file");
                }
                catch (IOException iOException) {
                    System.out.println("IOException in Monitor Service -> DOPopUp write a event in a file");
                }
            }
            if (!bl) {
                m_isPopupStarted = false;
                try {
                    printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.m_qualified_popup_log_file_name, true)));
                    printWriter.println(string);
                    printWriter.close();
                }
                catch (IOException iOException) {
                    System.out.println("IOException in CIMOMMonitor Service -> DOPopUp write a event in a file");
                }
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            m_isPopupStarted = false;
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.m_qualified_popup_log_file_name, true)));
                printWriter.println(string);
                printWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("IOException in CIMOMMonitor Service -> DOPopUp write a event in a file");
            }
        }
    }

    private void alertActionSysLog(String string, int n) {
        StorelibPlugin.doSystemLog(this.m_pluginDataInfo, string, n);
    }

    @Override
    public void startupOperations() {
        this.m_evtDesc = new EventXMLFormation();
    }

    public boolean storeLatestSequenceNumber() {
        MR_EVT_LOG_INFO mR_EVT_LOG_INFO = null;
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(7, 0, this.getCtrlID(), 20).getByteArray());
        try {
            int n = 6;
            byte[] byArray = new byte[60];
            NetworkToJavaConverter.intToByteArray(n, byArray, 0);
            System.arraycopy(NetworkPacket.convertWWNStringToByteArray(PluginsWWN.getCIMOMMonitorWWN()), 0, byArray, 4, 24);
            System.arraycopy(NetworkPacket.convertWWNStringToByteArray(PluginsWWN.getCIMPluginWWN()), 0, byArray, 28, 24);
            NetworkToJavaConverter.intToByteArray(networkDataPacket.getDataBuffer().length, byArray, 56);
            byte[] byArray2 = networkDataPacket.getDataBuffer();
            PluginDataInfo pluginDataInfo = null;
            pluginDataInfo = new PluginDataInfo(PluginsWWN.getCIMOMMonitorWWN(), PluginsWWN.getCIMPluginWWN(), byArray2);
            boolean bl = m_objFramework.ProcessCommand(4098, pluginDataInfo);
            if (bl) {
                byte[] byArray3 = networkDataPacket.getDataBuffer();
                int n2 = NetworkToJavaConverter.byteArrayToInt(byArray3);
                if (n2 != 0) {
                    System.out.println("Failed to get Sequence Info, Status=" + Integer.toHexString(n2));
                    return true;
                }
                mR_EVT_LOG_INFO = new MR_EVT_LOG_INFO(byArray3, 44);
                if (this.m_OldSequenceNum == 0) {
                    this.m_OldSequenceNum = mR_EVT_LOG_INFO.getnewestSeqNum();
                    return true;
                }
                if (this.m_OldSequenceNum != mR_EVT_LOG_INFO.getnewestSeqNum()) {
                    this.m_OldSequenceNum = mR_EVT_LOG_INFO.getnewestSeqNum();
                    return true;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("AEN registration failed (Sequence Info Exception)");
            exception.printStackTrace();
            mR_EVT_LOG_INFO = null;
            return true;
        }
        return false;
    }

    public String isSmtpInSameSubnet(String string) {
        InetAddress inetAddress = null;
        boolean bl = false;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        ArrayList arrayList = new ArrayList();
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        Object var6_8 = null;
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            InetAddress inetAddress2 = null;
            if (!enumeration2.hasMoreElements()) continue;
            inetAddress2 = enumeration2.nextElement();
            try {
                if (networkInterface.isLoopback()) continue;
                System.out.println("IP OF LOCAL HOST IS::" + inetAddress2.getHostAddress());
                bl = this.isSMTPReachable(inetAddress, inetAddress2);
                if (!bl) continue;
                System.out.println("IP::" + inetAddress2.getHostAddress() + " IS IN SAME SUBNET of SMTP");
                return inetAddress2.getHostAddress();
            }
            catch (SocketException socketException) {
                socketException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public boolean isSMTPReachable(InetAddress inetAddress, InetAddress inetAddress2) {
        System.out.println("CIMOMMonitorService.isSMTPReachable()");
        boolean bl = false;
        try {
            Socket socket = new Socket(inetAddress, 25, inetAddress2, this.getAFreePort());
            socket.close();
            bl = true;
        }
        catch (IOException iOException) {
            bl = false;
            System.out.println("CIMOMMonitorService.isSMTPReachable() @ exception");
        }
        return bl;
    }

    public int getAFreePort() {
        int n;
        System.out.println("CIMOMMonitorService.getAFreePort()");
        int n2 = 49257;
        int n3 = 800;
        int n4 = n2;
        for (n = 0; n <= n3; ++n) {
            try {
                ServerSocket serverSocket = null;
                serverSocket = new ServerSocket(++n4);
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                    if (!enumeration2.hasMoreElements()) continue;
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress instanceof Inet4Address) {
                        serverSocket.close();
                        serverSocket = null;
                        serverSocket = new ServerSocket(n4, 0, inetAddress);
                    }
                    serverSocket.close();
                    System.out.println("CIMOMMonitorService.getAFreePort() free port = " + n4);
                    return n4;
                }
                serverSocket.close();
                break;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        if (n > n3) {
            n4 = 0;
        }
        return n4;
    }

    public int getCtrlID() {
        return m_slObject.getctrlId();
    }

    public short getSeqNum() {
        return (short)m_slObject.getevtDetail().getseqNum();
    }

    public int getEventCode() {
        return m_slObject.getevtDetail().getcode();
    }

    public int getEventClass() {
        return m_slObject.getevtDetail().getcl().geteventClass();
    }

    public int getargType() {
        return m_slObject.getevtDetail().getargType();
    }

    public String getEventinLocFormat(String string) {
        LogXMLParser logXMLParser = new LogXMLParser(string);
        byte[] byArray = Locale.getDefault().getLanguage().getBytes();
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = Locale.getDefault().getCountry().getBytes();
        System.arraycopy(byArray3, 0, byArray2, 0, Math.min(byArray2.length, byArray3.length));
        String string2 = new String(byArray);
        String string3 = new String(byArray2);
        Localization localization = new Localization(string2, string3);
        logXMLParser.setTagValue("languageCode", localization.getLanguage());
        String string4 = localization.getLocalizedStringWithoutUnicodeConversion(logXMLParser.getTagValue("id").trim(), logXMLParser.getParams());
        logXMLParser.setTagValue("localizedMessage", string4);
        return string4;
    }

    public static byte[] getClientList() {
        int n;
        Object[] objectArray = ClientManager.getClientList();
        byte[] byArray = null;
        if (objectArray.length != 0) {
            byArray = ((ClientInfo)objectArray[0]).getBytes();
            n = byArray.length;
        } else {
            n = 0;
        }
        byte[] byArray2 = new byte[objectArray.length * n + 4];
        int n2 = 0;
        NetworkToJavaConverter.intToByteArray(objectArray.length, byArray2);
        if (objectArray.length == 0) {
            return byArray2;
        }
        System.arraycopy(byArray, 0, byArray2, n2 += 4, n);
        n2 += n;
        for (int i = 1; i < objectArray.length; ++i) {
            System.arraycopy(((ClientInfo)objectArray[i]).getBytes(), 0, byArray2, n2, n);
            n2 += n;
        }
        return byArray2;
    }

    private String getPopupWWN() throws VKOperationFailedException {
        byte[] byArray = CIMOMMonitorService.getClientList();
        ClientInfo[] clientInfoArray = new ClientInfo[NetworkToJavaConverter.byteArrayToInt(byArray)];
        for (int i = 0; i < clientInfoArray.length; ++i) {
            clientInfoArray[i] = new ClientInfo(byArray, 4 + i * 512);
            System.out.println("Client Minor number: " + clientInfoArray[i].getMinorNumber());
        }
        for (ClientInfo clientInfo : clientInfoArray) {
            if (clientInfo.getMajorNumber() != 0 || clientInfo.getMinorNumber() != 10) continue;
            return clientInfo.getWWN();
        }
        System.out.println("Error - assigning Popup WWN as receiver in CIMOMMonitorplugin");
        throw new VKOperationFailedException(4096);
    }

    @Override
    public void preShutdown() {
        System.out.println("CIMOMMonitorService.preShutdown() Inside ");
        try {
            for (int i = 0; i < this.m_cimomList.size(); ++i) {
                ManageCIMOMServer manageCIMOMServer = this.m_cimomList.get(i);
                manageCIMOMServer.stopTimeSyncThread();
                manageCIMOMServer.UnRegisterForAEN();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("CIMOMMonitorService.preShutdown() Exception @ ");
        }
    }

    @Override
    public void shutdown() {
        System.out.println("CIMOMMonitor plugin shutdown");
    }

    private String getMailSubject(int n) {
        String string = this.getSeverityString(n);
        String string2 = Resource.getString("DESC", "Event occurred on: ");
        String string3 = "";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string3 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            System.out.println("MonitorService.getMailSubject() exception while getting hostname");
        }
        return string + " | " + string2 + string3;
    }

    public String getSeverityString(int n) {
        String string = Resource.getString("INFO", "Information");
        if (n == 0) {
            string = Resource.getString("INFO", "Information");
        } else if (n == 1) {
            string = Resource.getString("WARN", "Warning");
        } else if (n == 2) {
            string = Resource.getString("CRTL", "Critical");
        } else if (n == 3) {
            string = Resource.getString("FATAL", "Fatal");
        } else if (n == 4) {
            string = Resource.getString("TITLE_DRIVES_SPIN_UP_PROGRESS", "Progress");
        }
        return string;
    }

    private byte[] getVivaldiConfig() {
        Object object;
        int n;
        int n2;
        int n3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        WWNExtractor wWNExtractor = new WWNExtractor(this.m_pluginDataInfo.getSenderWWN());
        String string = "";
        int[] nArray = wWNExtractor.getIP();
        for (int i = 0; i < nArray.length; ++i) {
            if (i != 0) {
                string = string + ".";
            }
            int n4 = nArray[i];
            string = string + n4;
        }
        System.out.println("CIMOM getVivaldiConfig() Sender IPAddress = " + string);
        String string2 = (String)this.m_cimomClientHash.get(string);
        ManageCIMOMServer manageCIMOMServer = (ManageCIMOMServer)this.m_cimomHash.get(string2);
        if (manageCIMOMServer == null) {
            System.out.println("getVivaldiConfig() mangecimmom is nnull can't proceed");
            int n5 = 0;
            int n6 = 12;
            byte[] byArray = new byte[n6];
            NetworkToJavaConverter.intToByteArray(0, byArray, n5);
            NetworkToJavaConverter.intToByteArray(n6, byArray, n5 += 4);
            NetworkToJavaConverter.intToByteArray(0, byArray, n5 += 4);
            return byArray;
        }
        XMLParser xMLParser = new XMLParser();
        try {
            xMLParser.parse(new FileInputStream(manageCIMOMServer.getConfigFileName()));
        }
        catch (IOException iOException) {
            System.out.println("getVivaldiConfig() I/O Exception while loading config file");
            iOException.printStackTrace();
            int n7 = 0;
            int n8 = 12;
            byte[] byArray = new byte[n8];
            NetworkToJavaConverter.intToByteArray(0, byArray, n7);
            NetworkToJavaConverter.intToByteArray(n8, byArray, n7 += 4);
            NetworkToJavaConverter.intToByteArray(0, byArray, n7 += 4);
            return byArray;
        }
        AlertsConfigData alertsConfigData = xMLParser.getConfig();
        Enumeration enumeration = alertsConfigData.getAlertEvents();
        while (enumeration.hasMoreElements()) {
            int n9 = (Integer)enumeration.nextElement();
            arrayList2.add(n9);
        }
        System.out.println("CIMOMMonitorService.processCommand()events count = " + arrayList2.size());
        String string3 = "";
        int n10 = 0;
        for (int i = 0; i < arrayList2.size(); ++i) {
            try {
                n3 = Integer.parseInt(arrayList2.get(i).toString());
                AlertEventDetails alertEventDetails = alertsConfigData.getAlertEvent(Integer.parseInt(arrayList2.get(i).toString()));
                n2 = alertEventDetails.getSeverity();
                n = 0;
                if (alertEventDetails.usesGlobal()) {
                    System.out.println("using global");
                    object = alertsConfigData.getGlobal(n2);
                    if (object != null && ((AlertsGlobalConfig)object).hasAction("vivaldilog")) {
                        n = 1;
                    }
                } else {
                    System.out.println("not using global");
                    if (alertEventDetails.hasAction("vivaldilog")) {
                        n = 1;
                    }
                }
                string3 = n3 + "=" + n + ";" + n2;
                arrayList.add(string3);
                ++n10;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (arrayList.size() == arrayList2.size()) {
            System.out.println("CIMOMMonitorService.processCommand()- VivaldiCfg ArrayList filled properly");
        } else {
            System.out.println("CIMOMMonitorService.processCommand()- VivaldiCfg ArrayList not filled properly");
        }
        System.out.println("CIMOMMonitorService.processCommand() vivaldiConfig.size() " + arrayList.size());
        byte[] byArray = null;
        if (n10 != 0) {
            n3 = 12;
            n3 += arrayList.size() * 4;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                n3 += ((String)arrayList.get(n2)).length();
            }
            byArray = new byte[n3];
            n2 = 0;
            NetworkToJavaConverter.intToByteArray(0, byArray, n2);
            NetworkToJavaConverter.intToByteArray(n3, byArray, n2 += 4);
            NetworkToJavaConverter.intToByteArray(arrayList.size(), byArray, n2 += 4);
            n2 += 4;
            for (n = 0; n < arrayList.size(); ++n) {
                object = (String)arrayList.get(n);
                NetworkToJavaConverter.intToByteArray(((String)object).length(), byArray, n2);
                System.arraycopy(((String)object).getBytes(), 0, byArray, n2 += 4, ((String)object).length());
                n2 += ((String)object).length();
            }
        } else {
            n3 = 0;
            n2 = 12;
            byArray = new byte[n2];
            NetworkToJavaConverter.intToByteArray(0, byArray, n3);
            NetworkToJavaConverter.intToByteArray(n2, byArray, n3 += 4);
            NetworkToJavaConverter.intToByteArray(0, byArray, n3 += 4);
        }
        return byArray;
    }

    private byte[] getVivaldiConfig(AlertsConfigData alertsConfigData) {
        Object object;
        int n;
        int n2;
        int n3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        AlertsConfigData alertsConfigData2 = alertsConfigData;
        Enumeration enumeration = alertsConfigData2.getAlertEvents();
        while (enumeration.hasMoreElements()) {
            int n4 = (Integer)enumeration.nextElement();
            arrayList2.add(n4);
        }
        System.out.println("CIMOMMonitorService.processCommand()events count = " + arrayList2.size());
        String string = "";
        int n5 = 0;
        for (int i = 0; i < arrayList2.size(); ++i) {
            try {
                n3 = Integer.parseInt(arrayList2.get(i).toString());
                AlertEventDetails alertEventDetails = alertsConfigData2.getAlertEvent(Integer.parseInt(arrayList2.get(i).toString()));
                n2 = alertEventDetails.getSeverity();
                n = 0;
                if (alertEventDetails.usesGlobal()) {
                    System.out.println("using global");
                    object = alertsConfigData2.getGlobal(n2);
                    if (object != null && ((AlertsGlobalConfig)object).hasAction("vivaldilog")) {
                        n = 1;
                    }
                } else {
                    System.out.println("not using global");
                    if (alertEventDetails != null && alertEventDetails.hasAction("vivaldilog")) {
                        n = 1;
                    }
                }
                string = n3 + "=" + n + ";" + n2;
                arrayList.add(string);
                ++n5;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (arrayList.size() == arrayList2.size()) {
            System.out.println("CIMOMMonitorService.processCommand()- VivaldiCfg ArrayList filled properly");
        } else {
            System.out.println("CIMOMMonitorService.processCommand()- VivaldiCfg ArrayList not filled properly");
        }
        System.out.println("CIMOMMonitorService.processCommand() vivaldiConfig.size() " + arrayList.size());
        byte[] byArray = null;
        if (n5 != 0) {
            n3 = 12;
            n3 += arrayList.size() * 4;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                n3 += ((String)arrayList.get(n2)).length();
            }
            byArray = new byte[n3];
            n2 = 0;
            NetworkToJavaConverter.intToByteArray(0, byArray, n2);
            NetworkToJavaConverter.intToByteArray(n3, byArray, n2 += 4);
            NetworkToJavaConverter.intToByteArray(arrayList.size(), byArray, n2 += 4);
            n2 += 4;
            for (n = 0; n < arrayList.size(); ++n) {
                object = (String)arrayList.get(n);
                NetworkToJavaConverter.intToByteArray(((String)object).length(), byArray, n2);
                System.arraycopy(((String)object).getBytes(), 0, byArray, n2 += 4, ((String)object).length());
                n2 += ((String)object).length();
            }
        } else {
            n3 = 0;
            n2 = 12;
            byArray = new byte[n2];
            NetworkToJavaConverter.intToByteArray(0, byArray, n3);
            NetworkToJavaConverter.intToByteArray(n2, byArray, n3 += 4);
            NetworkToJavaConverter.intToByteArray(0, byArray, n3 += 4);
        }
        return byArray;
    }

    private void sendVivaldiCfgtoCIMClients(AlertsConfigData alertsConfigData) {
        PluginDataInfo pluginDataInfo = new PluginDataInfo();
        byte[] byArray = this.getVivaldiConfig(alertsConfigData);
        pluginDataInfo.setBuffer(byArray);
        pluginDataInfo.setSenderWWN(this.pluginInfo.getWWN());
        WWNExtractor wWNExtractor = new WWNExtractor(this.m_pluginDataInfo.getSenderWWN());
        String string = "";
        int[] nArray = wWNExtractor.getIP();
        for (int i = 0; i < nArray.length; ++i) {
            if (i != 0) {
                string = string + ".";
            }
            int n = nArray[i];
            string = string + n;
        }
        System.out.println("CIMOM sendVivaldiCfgtoCIMClients() Sender IPAddress = " + string);
        String string2 = (String)this.m_cimomClientHash.get(string);
        ManageCIMOMServer manageCIMOMServer = (ManageCIMOMServer)this.m_cimomHash.get(string2);
        if (manageCIMOMServer == null) {
            System.out.println("sendVivaldiCfgtoCIMClients() mangecimmom is nnull can't proceed");
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = this.m_cimomClientWWNHash.keySet();
        for (String string3 : set) {
            if (!string2.equalsIgnoreCase((String)this.m_cimomClientWWNHash.get(string3))) continue;
            arrayList.add(string3);
        }
        System.out.println("CIMOMMonitorService.sendVivaldiCfgtoSLClients()SL Clients Length = " + arrayList.size());
        String string4 = "";
        try {
            string4 = PluginsWWN.getMonitorWWN();
        }
        catch (Exception exception) {
            System.out.println("CIMOMMonitorService.sendVivaldiCfgtoCIMClients() exception @ getting monitor WWN");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (string4.equalsIgnoreCase((String)arrayList.get(i))) continue;
            System.out.println("CIMOMMonitorService.processCommand()recever of cfg = " + (String)arrayList.get(i));
            pluginDataInfo.setReceiverWWN((String)arrayList.get(i));
            if (m_objFramework.ProcessCommand(4102, pluginDataInfo)) continue;
            this.m_cimomClientWWNHash.remove((String)arrayList.get(i));
        }
    }

    private synchronized boolean getCIMInitialLog(PluginDataInfo pluginDataInfo) {
        Object object;
        int n;
        Object object2;
        byte[] byArray = pluginDataInfo.getBuffer();
        int n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 4);
        int n3 = NetworkToJavaConverter.byteArrayToInt(byArray, 8);
        byte[] byArray2 = new byte[2];
        System.arraycopy(byArray, 12, byArray2, 0, 2);
        String string = new String(byArray2);
        String string2 = new String(byArray, 14, 2);
        Localization localization = new Localization(string, string2);
        String string3 = new String(byArray, 16, 32).trim();
        System.out.println("CIMOMMonitorService.getCIMInitialLog() IP = " + string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        int n4 = 0;
        System.out.println("CIMOMMonitorService.getCIMInitialLog() file name = " + CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + string3 + "_vuosd.dhdk");
        try {
            int n5;
            object2 = new FileReader(CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + string3 + "_vuosd.dhdk");
            FileReader fileReader = new FileReader(CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + string3 + "_vuosd.dhdk");
            bufferedReader = new BufferedReader((Reader)object2);
            bufferedReader2 = new BufferedReader(fileReader);
            n = 0;
            while (bufferedReader.readLine() != null) {
                ++n;
            }
            System.out.println("CIMOMMonitorService.getCIMInitialLog() lineCountInLogFile = " + n);
            Object var18_20 = null;
            for (n5 = 0; n5 <= n - n2 - n3; ++n5) {
                bufferedReader2.readLine();
            }
            while (n5 <= n - n2) {
                block17: {
                    try {
                        object = new LogXMLParser(bufferedReader2.readLine());
                        ((LogXMLParser)object).setTagValue("languageCode", localization.getLanguage());
                        try {
                            ((LogXMLParser)object).setTagValue("localizedMessage", localization.getLocalizedString(((LogXMLParser)object).getTagValue("id").trim(), ((LogXMLParser)object).getParams()));
                        }
                        catch (NullPointerException nullPointerException) {
                            break block17;
                        }
                        String string4 = ((LogXMLParser)object).getXML();
                        String string5 = "";
                        for (int i = 0; i < string4.length(); ++i) {
                            if (string4.substring(i).startsWith("amp;")) {
                                i += 3;
                                continue;
                            }
                            string5 = string5 + string4.charAt(i);
                        }
                        arrayList.add(0, string5);
                        ++n4;
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                bufferedReader.close();
                bufferedReader2.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        object2 = null;
        int n6 = 12;
        if (n4 != 0) {
            System.out.println("CIMOMMonitorService.getCIMInitialLog() no. of line added != 0");
            n6 += arrayList.size() * 4;
            for (n = 0; n < arrayList.size(); ++n) {
                n6 += ((String)arrayList.get(n)).length();
            }
            object2 = new byte[n6];
            n = 0;
            NetworkToJavaConverter.intToByteArray(0, (byte[])object2, n);
            NetworkToJavaConverter.intToByteArray(n6, (byte[])object2, n += 4);
            NetworkToJavaConverter.intToByteArray(arrayList.size() >= n3 ? n3 : arrayList.size(), (byte[])object2, n += 4);
            n += 4;
            for (int i = 0; i < arrayList.size() && i < n3; ++i) {
                object = (String)arrayList.get(i);
                NetworkToJavaConverter.intToByteArray(((String)object).length(), (byte[])object2, n);
                System.arraycopy(((String)object).getBytes(), 0, object2, n += 4, ((String)object).length());
                n += ((String)object).length();
            }
        } else {
            System.out.println("CIMOMMonitorService.getCIMInitialLog() no. of line added == 0");
            object2 = new byte[n6];
            n = 0;
            NetworkToJavaConverter.intToByteArray(0, (byte[])object2, n);
            NetworkToJavaConverter.intToByteArray(n6, (byte[])object2, n += 4);
            NetworkToJavaConverter.intToByteArray(0, (byte[])object2, n += 4);
        }
        pluginDataInfo.setBuffer((byte[])object2);
        return true;
    }

    private synchronized boolean clearCIMInitialLog(PluginDataInfo pluginDataInfo) {
        byte[] byArray = pluginDataInfo.getBuffer();
        String string = new String(byArray, 0, 32).trim();
        System.out.println("CIMOMMonitorService.getCIMInitialLog() file name = " + CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + string + "_vuosd.dhdk");
        try {
            File file = new File(CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + string + "_vuosd.dhdk");
            try {
                if (file.exists()) {
                    FileWriter fileWriter = new FileWriter(file);
                    fileWriter.write("");
                    fileWriter.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return true;
        }
    }
}

