/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.FrameworkInterface;
import Framework.PluginManagers.PluginInfo;
import Framework.PluginManagers.PluginManager;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import Services.CommonConstants;
import Services.NetworkDataPacket;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import plugins.ManageCIMOMServer;
import plugins.ProcessCommand;
import plugins.Utils.PluginsWWN;

public class CIMOMStartups {
    private ManageCIMOMServer cimmomDetails;
    private String stdConfigFileName = "config-current.xml";
    public static String m_stdDefaultConfigFilePath = ".." + File.separator + "MegaMonitor" + File.separator + "config-default.xml";
    private FrameworkInterface framework;
    private static final int LIB_TYPE_STORELIBMR = 0;
    private static final int LIB_TYPE_STORELIBIR = 1;
    private static final int LIB_TYPE_STORELIBIR_2 = 2;
    private static final int LIB_TYPE_STORELIBIR_3 = 4;

    CIMOMStartups(ManageCIMOMServer manageCIMOMServer, FrameworkInterface frameworkInterface) {
        this.cimmomDetails = manageCIMOMServer;
        this.framework = frameworkInterface;
        this.startups();
    }

    public void startups() {
        String string = CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + new String(this.cimmomDetails.getCIMMOMIP()).trim() + "_vuosd.dhdk";
        File file = new File(string);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                System.out.println("Error @ creation of file " + string);
            }
        }
        this.cimmomDetails.setLogFileName(string);
        string = CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + new String(this.cimmomDetails.getCIMMOMIP()).trim() + "_" + this.stdConfigFileName;
        File file2 = new File(string);
        if (!file2.exists()) {
            try {
                int n;
                file2.createNewFile();
                String string2 = m_stdDefaultConfigFilePath;
                File file3 = new File(string2);
                File file4 = new File(string);
                FileInputStream fileInputStream = new FileInputStream(file3);
                FileOutputStream fileOutputStream = new FileOutputStream(file4);
                byte[] byArray = new byte[1024];
                while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                ((InputStream)fileInputStream).close();
                ((OutputStream)fileOutputStream).close();
                System.out.println("File copied.");
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(fileNotFoundException.getMessage() + " in the specified directory.");
            }
            catch (IOException iOException) {
                System.out.println("Error @ creation of file " + string);
            }
        }
        this.cimmomDetails.setConfigFileName(string);
        this.createAdaptersForCIMOM();
        this.cimmomDetails.updateControllerInfo();
        this.cimmomDetails.registerForAEN();
        this.cimmomDetails.startTimeSyncThread();
    }

    private int loginCIMOMServer() {
        int n = 0;
        try {
            byte[] byArray = new byte[552];
            int n2 = 0;
            String string = new String(this.cimmomDetails.getCIMMOMIP()).trim();
            String string2 = new String(this.cimmomDetails.getCIMMOMPort()).trim();
            String string3 = new String(this.cimmomDetails.getCIMMOMUserName()).trim();
            String string4 = new String(this.cimmomDetails.getCIMMOMPassword()).trim();
            NetworkToJavaConverter.intToByteArray(270, byArray, 0);
            System.arraycopy(string.getBytes(), 0, byArray, n2 += 4, string.getBytes().length);
            System.arraycopy(string2.getBytes(), 0, byArray, n2 += 32, string2.getBytes().length);
            System.arraycopy(string3.getBytes(), 0, byArray, n2 += 4, string3.getBytes().length);
            System.arraycopy(string4.getBytes(), 0, byArray, n2 += 256, string4.getBytes().length);
            n2 += 256;
            NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
            byte[] byArray2 = new byte[60];
            int n3 = 270;
            NetworkToJavaConverter.intToByteArray(n3, byArray2, 0);
            System.arraycopy(NetworkPacket.convertWWNStringToByteArray(PluginsWWN.getCIMOMMonitorWWN()), 0, byArray2, 4, 24);
            System.arraycopy(NetworkPacket.convertWWNStringToByteArray(PluginsWWN.getCIMOMMonitorWWN()), 0, byArray2, 28, 24);
            NetworkToJavaConverter.intToByteArray(networkDataPacket.getDataBuffer().length, byArray2, 56);
            ProcessCommand processCommand = new ProcessCommand();
            processCommand.fireProcessCommand(byArray2, networkDataPacket);
            byte[] byArray3 = networkDataPacket.getDataBuffer();
            n = NetworkToJavaConverter.byteArrayToInt(byArray3, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception @ login in to CIM server");
        }
        return n;
    }

    private void createAdaptersForCIMOM() {
        int n;
        int n2;
        int n3;
        ArrayList<Integer> arrayList;
        byte[] byArray;
        System.out.println("Inside createAdaptersForCIMOM");
        NetworkDataPacket networkDataPacket = null;
        ArrayList arrayList2 = new ArrayList();
        ProcessCommand processCommand = null;
        try {
            processCommand = new ProcessCommand(PluginsWWN.getCIMOMMonitorWWN(), PluginsWWN.getCIMPluginWWN(), this.framework, this.cimmomDetails, true);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("Exception @ CIMMOMStartups getting CIMMOMWWN ");
        }
        networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0, 68).getByteArray());
        try {
            processCommand.fireDCMDCommand(networkDataPacket);
            byArray = networkDataPacket.getDataBuffer();
            arrayList = new ArrayList<Integer>();
            n3 = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, 44);
            System.out.println("Number of Controller Found MR = " + n3);
            for (n2 = 0; n2 < n3; ++n2) {
                n = NetworkToJavaConverter.byteArrayToInt(byArray, 48 + n2 * 4);
                System.out.println("Controller ID int value = " + n);
                arrayList.add(new Integer(n));
            }
            if (arrayList != null) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    arrayList2.add(arrayList.get(n2));
                }
            } else {
                System.out.println("MR ctrlr count 0");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception @ CIMMOMStartups getting MR ");
        }
        networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0x1000000, 68).getByteArray());
        try {
            processCommand.fireDCMDCommand(networkDataPacket);
            byArray = networkDataPacket.getDataBuffer();
            arrayList = new ArrayList();
            n3 = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, 44);
            System.out.println("Number of Controller Found IR= " + n3);
            for (n2 = 0; n2 < n3; ++n2) {
                n = NetworkToJavaConverter.byteArrayToInt(byArray, 48 + n2 * 4);
                System.out.println("Controller ID int value = " + n);
                arrayList.add(new Integer(n));
            }
            if (arrayList != null) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    arrayList2.add(arrayList.get(n2));
                }
            } else {
                System.out.println("IR ctrlr count 0");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception @ CIMMOMStartups getting IR ");
        }
        networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0x2000000, 68).getByteArray());
        try {
            processCommand.fireDCMDCommand(networkDataPacket);
            byArray = networkDataPacket.getDataBuffer();
            arrayList = new ArrayList();
            n3 = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, 44);
            System.out.println("Number of Controller Found IR2= " + n3);
            for (n2 = 0; n2 < n3; ++n2) {
                n = NetworkToJavaConverter.byteArrayToInt(byArray, 48 + n2 * 4);
                System.out.println("Controller ID int value = " + n);
                arrayList.add(new Integer(n));
            }
            if (arrayList != null) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    arrayList2.add(arrayList.get(n2));
                }
            } else {
                System.out.println("IR2 ctrlr count 0");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception @ CIMMOMStartups getting IR2 ");
        }
        networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0x4000000, 68).getByteArray());
        try {
            processCommand.fireDCMDCommand(networkDataPacket);
            byArray = networkDataPacket.getDataBuffer();
            arrayList = new ArrayList();
            n3 = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray, 44);
            System.out.println("Number of Controller Found IR3= " + n3);
            for (n2 = 0; n2 < n3; ++n2) {
                n = NetworkToJavaConverter.byteArrayToInt(byArray, 48 + n2 * 4);
                System.out.println("Controller ID int value = " + n);
                arrayList.add(new Integer(n));
            }
            if (arrayList != null) {
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    arrayList2.add(arrayList.get(n2));
                }
            } else {
                System.out.println("IR3 ctrlr count 0");
            }
        }
        catch (Exception exception) {
            System.out.println("Exception @ CIMMOMStartups getting IR3 ");
        }
        this.cimmomDetails.setControllerList(arrayList2);
    }

    public static PluginInfo[] getPlugIns() {
        PluginInfo[] pluginInfoArray = PluginManager.getPlugInList();
        return pluginInfoArray;
    }

    public static String getMonitorWWN() throws VKOperationFailedException {
        PluginInfo[] pluginInfoArray = CIMOMStartups.getPlugIns();
        for (int i = 0; i < pluginInfoArray.length; ++i) {
            if (0 != pluginInfoArray[i].getMajorGroup() || 8 != pluginInfoArray[i].getMinorGroup()) continue;
            return pluginInfoArray[i].getWWN();
        }
        throw new VKOperationFailedException(4096);
    }

    private String getCIMPluginWWN() throws VKOperationFailedException {
        PluginInfo[] pluginInfoArray = CIMOMStartups.getPlugIns();
        for (int i = 0; i < pluginInfoArray.length; ++i) {
            if (1 != pluginInfoArray[i].getMajorGroup() || 6 != pluginInfoArray[i].getMinorGroup()) continue;
            return pluginInfoArray[i].getWWN();
        }
        throw new VKOperationFailedException(4096);
    }
}

