/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.FrameworkInterface;
import Framework.PluginManagers.PluginDataInfo;
import Framework.PluginManagers.PluginInfo;
import Framework.PluginManagers.PluginInterface;
import Services.CommonConstants;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import Services.WWNExtractor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class CIMPlugin
implements PluginInterface,
CommonConstants {
    private static final String strLibraryName = "CIMPlugin";
    private static PluginInfo objPluginInfo = new PluginInfo();
    private static final String strVersion = "1.05";
    private static String strDescription = "CIM Plugin version :1.05";
    private static final int iMajorGroup = 1;
    private static final int iMinorGroup = 6;
    private static FrameworkInterface objFramework = null;
    private static boolean startedCallbackThread = false;
    private ArrayList<String> m_objReceiverWWNList = new ArrayList();
    private ArrayList<String> m_objVMwareHostList = new ArrayList();
    private HashMap<String, String> m_objReceiverWwnToVMWareHostMap = new HashMap();
    private HashMap<String, String> m_ControllerWWNToVMWareHostMap = new HashMap();
    private ArrayList m_objCIMOMHosts;

    public native boolean initCIMPlugin();

    public native Object[] discoverCIMOMs();

    public native int authenticateUser(byte[] var1);

    public native void processSLPassthroughCommand(byte[] var1);

    public native void startIndicationListener();

    public native void stopIndicationListener();

    public native void startCallbackThread(byte[] var1);

    public static native void stopCallbackThread();

    public native int checkHeartBeat(byte[] var1);

    public native Object[] getControllerNames();

    @Override
    public PluginInfo getPluginInfo() {
        return objPluginInfo;
    }

    @Override
    public boolean init(String string, FrameworkInterface frameworkInterface) {
        this.loadLibrary();
        objPluginInfo.setDescription(strDescription);
        objPluginInfo.setMajorGroup(1);
        objPluginInfo.setMinorGroup(6);
        objPluginInfo.setVersion(strVersion);
        objPluginInfo.setWWN(string);
        objFramework = frameworkInterface;
        if (!this.initCIMPlugin()) {
            return false;
        }
        this.m_objCIMOMHosts = this.getCIMOMHosts();
        if (this.m_objCIMOMHosts.size() > 0) {
            this.startIndicationListener();
        }
        new CIMPluginCallbackThread();
        startedCallbackThread = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean processCommand(PluginDataInfo pluginDataInfo) {
        Object[] objectArray;
        String string;
        int n;
        block28: {
            byte[] byArray;
            InetAddress[] inetAddressArray;
            byte[] byArray2;
            String string2;
            byte[] byArray3 = pluginDataInfo.getBuffer();
            byte[] byArray4 = null;
            int n2 = 0;
            int n3 = NetworkToJavaConverter.byteArrayToInt(byArray3);
            switch (n3) {
                case 269: {
                    this.m_objCIMOMHosts = this.getCIMOMHosts();
                    if (this.m_objCIMOMHosts.size() > 0) {
                        byArray4 = new byte[4 + 24 * this.m_objCIMOMHosts.size()];
                        NetworkToJavaConverter.intToByteArray(this.m_objCIMOMHosts.size(), byArray4);
                        n2 += 4;
                    } else {
                        byArray4 = new byte[4];
                        NetworkToJavaConverter.intToByteArray(0, byArray4);
                    }
                    int n4 = 0;
                    while (true) {
                        if (n4 >= this.m_objCIMOMHosts.size()) {
                            pluginDataInfo.setBuffer(byArray4);
                            return true;
                        }
                        String string3 = (String)this.m_objCIMOMHosts.get(n4);
                        StringTokenizer stringTokenizer = new StringTokenizer(string3.toString(), ":");
                        String string4 = (String)stringTokenizer.nextElement();
                        String string5 = (String)stringTokenizer.nextElement();
                        String string6 = (String)stringTokenizer.nextElement();
                        InetAddress inetAddress = null;
                        String string7 = null;
                        try {
                            inetAddress = InetAddress.getByName(string5.substring(2, string5.length()));
                            string7 = inetAddress.getHostAddress().toString();
                        }
                        catch (UnknownHostException unknownHostException) {
                            // empty catch block
                        }
                        if (string7 != null) {
                            String string8 = string7 + ":" + string6 + ":" + 2;
                            byte[] byArray5 = NetworkPacket.convertWWNStringToByteArray(string8);
                            System.arraycopy(byArray5, 0, byArray4, n2, byArray5.length);
                            n2 += byArray5.length;
                        }
                        ++n4;
                    }
                }
                case 270: {
                    byte[] byArray6 = new byte[32];
                    n = -1;
                    System.arraycopy(byArray3, 4, byArray6, 0, 32);
                    string2 = new String(byArray6);
                    string = null;
                    byArray2 = new byte[808];
                    inetAddressArray = null;
                    try {
                        objectArray = InetAddress.getByName(string2);
                        string = objectArray.getCanonicalHostName();
                        byArray = string.getBytes();
                        inetAddressArray = InetAddress.getAllByName(string);
                        if (inetAddressArray.length > 1) {
                            break;
                        }
                        byArray4 = new byte[4];
                        System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                        System.arraycopy(byArray, 0, byArray2, 552, byArray.length);
                        n = this.authenticateUser(byArray2);
                        NetworkToJavaConverter.intToByteArray(n, byArray4);
                        pluginDataInfo.setBuffer(byArray4);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break block28;
                }
                case 271: {
                    byte[] byArray7 = new byte[byArray3.length - 552];
                    System.arraycopy(byArray3, 552, byArray7, 0, byArray7.length);
                    byte by = byArray7[4];
                    byte by2 = byArray7[5];
                    if (by == 0 && by2 == 2) {
                        System.out.println("CIMPlugin.processCommand() : SL_UNREGISTER_AEN");
                        String string9 = null;
                        if (this.m_objReceiverWwnToVMWareHostMap.containsKey(new String(pluginDataInfo.getSenderWWN()))) {
                            string9 = this.m_objReceiverWwnToVMWareHostMap.get(pluginDataInfo.getSenderWWN());
                            System.out.println("CIMPlugin.processCommand() : vmWareIP = " + string9);
                            this.m_objReceiverWwnToVMWareHostMap.remove(pluginDataInfo.getSenderWWN());
                        }
                        if (string9 != null && this.m_objReceiverWwnToVMWareHostMap.containsValue(string9)) {
                            System.out.println("CIMPlugin.processCommand(), another listener present for vmhost. return");
                            return true;
                        }
                        System.out.println("CIMPlugin.processCommand() : no other listeners...");
                    }
                    this.processSLPassthroughCommand(byArray3);
                    byArray4 = new byte[byArray3.length - 552];
                    System.arraycopy(byArray3, 552, byArray4, 0, byArray4.length);
                    pluginDataInfo.setBuffer(byArray4);
                    int n5 = NetworkToJavaConverter.byteArrayToInt(byArray4);
                    if (n5 != 0) return true;
                    if (by != 0) return true;
                    if (by2 != 1) return true;
                    byte[] byArray8 = new byte[32];
                    System.arraycopy(byArray3, 4, byArray8, 0, 32);
                    String string10 = new String(byArray8);
                    try {
                        InetAddress inetAddress = InetAddress.getByName(string10);
                        if (this.m_objReceiverWwnToVMWareHostMap.containsKey(new String(pluginDataInfo.getSenderWWN()))) return true;
                        this.m_objReceiverWwnToVMWareHostMap.put(pluginDataInfo.getSenderWWN(), inetAddress.getHostAddress());
                        return true;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return true;
                }
                case 272: {
                    byArray4 = new byte[4];
                    try {
                        int n6 = this.checkHeartBeat(byArray3);
                        NetworkToJavaConverter.intToByteArray(n6, byArray4);
                        pluginDataInfo.setBuffer(byArray4);
                        if (n6 != 0) return false;
                        return true;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return true;
                    }
                }
                default: {
                    return false;
                }
            }
            for (int i = 0; i < inetAddressArray.length; ++i) {
                String string11 = inetAddressArray[i].getHostAddress().toString();
                byte[] byArray9 = string11.getBytes();
                string = inetAddressArray[i].getHostName().toString();
                byArray = string.getBytes();
                if (!string11.equals(string2)) {
                    System.arraycopy(byArray3, 0, byArray2, 0, 4);
                    System.arraycopy(byArray9, 0, byArray2, 4, byArray9.length);
                    System.arraycopy(byArray3, 36, byArray2, 36, 516);
                    System.arraycopy(byArray, 0, byArray2, 552, byArray.length);
                } else {
                    System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                    System.arraycopy(byArray, 0, byArray2, byArray3.length, byArray.length);
                }
                n = this.authenticateUser(byArray2);
                if (n == -2) continue;
                byArray4 = new byte[36];
                NetworkToJavaConverter.intToByteArray(n, byArray4);
                System.arraycopy(byArray9, 0, byArray4, 4, byArray9.length);
                pluginDataInfo.setBuffer(byArray4);
                break;
            }
        }
        if (n != 0) return true;
        System.out.println("CIMPlugin.processCommand(). Get list of controllers in the host & create hash map");
        objectArray = null;
        objectArray = this.getControllerNames();
        int n7 = 0;
        while (n7 < objectArray.length) {
            String string12 = (String)objectArray[n7];
            if (string12 != null && !this.m_ControllerWWNToVMWareHostMap.containsKey(string12)) {
                System.out.println("Added WWN " + string12 + " for host " + string);
                this.m_ControllerWWNToVMWareHostMap.put(string12, string);
            }
            ++n7;
        }
        return true;
    }

    @Override
    public void shutdown() {
        if (startedCallbackThread) {
            CIMPlugin.stopCallbackThread();
            startedCallbackThread = false;
        }
        this.stopIndicationListener();
    }

    public void run() {
    }

    public int pluginCallback(byte[] byArray) {
        Object object;
        Object object3;
        int n = 0;
        String string = new String();
        byte[] byArray2 = new byte[40];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        String string2 = new String(byArray2);
        System.out.println("FilterName : " + string2);
        byte[] byArray3 = new byte[16];
        System.arraycopy(byArray, 40, byArray3, 0, byArray3.length);
        String string3 = new String(byArray3);
        System.out.println("SystemName : " + string3);
        if (string2 != null && string2.contains("_")) {
            System.out.println("CIMPlugin.pluginCallback()::Reading IndicationFilterName from alert indication :");
            object3 = new StringTokenizer(string2, "_");
            string = (String)((StringTokenizer)object3).nextElement();
            System.out.println("HostName taken from IndicationFilterName: " + string);
        }
        System.out.println("Searching controller to host map");
        if (this.m_ControllerWWNToVMWareHostMap.containsKey(string3)) {
            string = this.m_ControllerWWNToVMWareHostMap.get(string3);
            System.out.println("Matching host is " + string);
        }
        object3 = new String();
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            object3 = inetAddress.getHostAddress();
            System.out.println("VMWare source IP = " + (String)object3);
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("CIMPlugin.pluginCallback() -> UnknownHostException");
        }
        System.out.println("CIMPlugin.pluginCallback() : Source vmware IP is " + (String)object3);
        for (String object22 : this.m_objReceiverWwnToVMWareHostMap.keySet()) {
            object = this.m_objReceiverWwnToVMWareHostMap.get(object22);
            if (!((String)object).equals(object3)) continue;
            System.out.println("CIMPlugin.pluginCallback()... Adding WWN to recevier list " + object22);
            this.m_objReceiverWWNList.add(object22);
            this.m_objVMwareHostList.add((String)object);
        }
        if (this.m_objReceiverWWNList.isEmpty()) {
            return n;
        }
        byte[] byArray4 = new byte[byArray.length - 56];
        System.arraycopy(byArray, 56, byArray4, 0, byArray4.length);
        object = new PluginDataInfo();
        ((PluginDataInfo)object).setBuffer(byArray4);
        for (int i = 0; i < this.m_objReceiverWWNList.size(); ++i) {
            ((PluginDataInfo)object).setReceiverWWN(this.m_objReceiverWWNList.get(i));
            WWNExtractor wWNExtractor = new WWNExtractor(this.m_objReceiverWWNList.get(i));
            String string4 = this.m_objVMwareHostList.get(i) + ":" + wWNExtractor.getPort() + ":" + wWNExtractor.getID();
            System.out.println("Sender WWN = " + string4);
            System.out.println("Receiver WWN = " + this.m_objReceiverWWNList.get(i));
            ((PluginDataInfo)object).setSenderWWN(string4);
            n = objFramework.ProcessCommand(4100, (PluginDataInfo)object) ? 0 : 1;
        }
        this.m_objReceiverWWNList.clear();
        return n;
    }

    private static void loadLibrary() {
        System.loadLibrary(strLibraryName);
    }

    private ArrayList getCIMOMHosts() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = null;
        try {
            objectArray = this.discoverCIMOMs();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            if (string == null) continue;
            arrayList.add(string.substring(13, string.length()));
        }
        return arrayList;
    }

    @Override
    public void preShutdown() {
    }

    @Override
    public void startupOperations() {
    }

    private class CIMPluginCallbackThread
    extends Thread {
        CIMPluginCallbackThread() {
            this.start();
        }

        @Override
        public void run() {
            byte[] byArray = new byte[324];
            CIMPlugin.this.startCallbackThread(byArray);
        }
    }
}

