/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.FrameworkInterface;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_DRV_DRIVER_VERSION;
import SASKernel.LibraryAPI.StoreLib.MR_FLASH_COMP_INFO;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import Services.FrameworkUtilities;
import Services.NetworkDataPacket;
import java.util.ArrayList;
import plugins.ManageCIMOMServer;
import plugins.ProcessCommand;
import plugins.Utils.Resource;

public class EmailContent {
    private ManageCIMOMServer m_cimmomDetails = null;
    private boolean m_isCimomCmd = false;
    private MR_CTRL_INFO m_ctrlInfo = null;
    private MR_DRV_DRIVER_VERSION m_driverVersion = null;
    private int m_ctrlID;
    private String m_receiverWWN;
    private String m_senderWWN;
    private FrameworkInterface m_frameworkInter;
    private ArrayList m_imageInfo;
    private ArrayList m_driverInfo;

    EmailContent() {
    }

    EmailContent(int n, String string, String string2, FrameworkInterface frameworkInterface, ManageCIMOMServer manageCIMOMServer, boolean bl, MR_CTRL_INFO mR_CTRL_INFO) {
        this.m_cimmomDetails = manageCIMOMServer;
        this.m_isCimomCmd = bl;
        this.m_ctrlInfo = mR_CTRL_INFO;
        this.m_ctrlID = n;
        this.m_senderWWN = string;
        this.m_receiverWWN = string2;
        this.m_frameworkInter = frameworkInterface;
        this.fireDriverDetails();
        this.imageDetails();
    }

    public void imageDetails() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_ctrlInfo != null) {
            String string = new String(Resource.getString("IMAGE_DETAILS", "Image Details"));
            string = string + "---";
            arrayList.add(string);
            if (!this.getBIOSVerszion().equalsIgnoreCase("")) {
                arrayList.add(this.getBIOSVerszion());
            }
            if (!this.getFWPackageVersion().equalsIgnoreCase("")) {
                arrayList.add(this.getFWPackageVersion());
            }
            if (!this.getFWVerszion().equalsIgnoreCase("")) {
                arrayList.add(this.getFWVerszion());
            }
        } else {
            System.out.println("EmailContent.imageDetails() ctrlInfo is null");
        }
        this.m_imageInfo = arrayList;
    }

    public void fireDriverDetails() {
        Object object;
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(1, 19, this.m_ctrlID, 112).getByteArray());
        if (!this.m_isCimomCmd) {
            try {
                try {
                    object = new ProcessCommand(this.m_senderWWN, this.m_receiverWWN, this.m_frameworkInter, this.m_cimmomDetails, this.m_isCimomCmd);
                    int n = ((ProcessCommand)object).fireDCMDCommand(networkDataPacket);
                    if (n == 0) {
                        System.out.println("Driver version fire Successful");
                    } else {
                        System.out.println("Driver version  fire failure");
                    }
                }
                catch (Exception exception) {
                    System.out.println("Exception in AENSequenceInfo fire");
                }
                object = networkDataPacket.getDataBuffer();
                try {
                    this.m_driverVersion = new MR_DRV_DRIVER_VERSION((byte[])object, 44);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                System.out.println("Driver fire failed");
                exception.printStackTrace();
            }
        }
        object = new ArrayList();
        String string = new String(Resource.getString("SYSTEM_DETAILS_TEXT", "System Details"));
        string = string + "---";
        ((ArrayList)object).add(string);
        if (this.m_isCimomCmd) {
            ((ArrayList)object).add(new String(Resource.getString("SERVER_IP", "IP Address: ")) + new String(this.m_cimmomDetails.getCIMMOMIP()));
        } else {
            ((ArrayList)object).add(new String(Resource.getString("SERVER_IP", "IP Address: ")) + FrameworkUtilities.getLocalHostAddress());
        }
        if (this.m_driverVersion != null) {
            ((ArrayList)object).add(new String(Resource.getString("OS_NAME", "OS Name: ")) + new String(this.m_driverVersion.getosName()).trim());
            ((ArrayList)object).add(new String(Resource.getString("OS_VERSION", "OS Version: ")) + new String(this.m_driverVersion.getosVersion()).trim());
            ((ArrayList)object).add(new String(Resource.getString("DRIVER_NAME", "Driver Name: ")) + new String(this.m_driverVersion.getdriverName()).trim());
            ((ArrayList)object).add(new String(Resource.getString("DRIVER_VERSION", "Driver Version: ")) + new String(this.m_driverVersion.getdriverVersion()).trim());
        } else {
            System.out.println("EmailContent.fireDriverDetails() driverdetails is null");
        }
        this.m_driverInfo = object;
    }

    public ArrayList getImageDetails() {
        return this.m_imageInfo;
    }

    public ArrayList getDriverDetails() {
        return this.m_driverInfo;
    }

    public String getBIOSVerszion() {
        String string = "";
        String string2 = "";
        MR_FLASH_COMP_INFO[] mR_FLASH_COMP_INFOArray = this.m_ctrlInfo.getimageComponent_MR_CTRL_INFO();
        for (int i = 0; i < mR_FLASH_COMP_INFOArray.length; ++i) {
            if (!Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getname()).equals("BIOS")) continue;
            string2 = Resource.getString("BIOS_VERSION_TEXT", "BIOS Version");
            string = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getversion());
            break;
        }
        String string3 = "";
        if (!string.equalsIgnoreCase("")) {
            string3 = string2 + " : " + string;
        }
        return string3;
    }

    public String getFWVerszion() {
        String string = "";
        String string2 = "";
        MR_FLASH_COMP_INFO[] mR_FLASH_COMP_INFOArray = this.m_ctrlInfo.getimageComponent_MR_CTRL_INFO();
        for (int i = 0; i < mR_FLASH_COMP_INFOArray.length; ++i) {
            if (!new String(mR_FLASH_COMP_INFOArray[i].getname()).trim().equals("APP")) continue;
            string = Resource.getString("FIRMWARE_VERSION_TEXT", "Firmware Version");
            string2 = Resource.zeroTrim(mR_FLASH_COMP_INFOArray[i].getversion());
            break;
        }
        String string3 = "";
        if (!string2.equalsIgnoreCase("")) {
            string3 = string + " : " + string2;
        }
        return string3;
    }

    public String getFWPackageVersion() {
        String string = "";
        string = Resource.zeroTrim(this.m_ctrlInfo.getfwPackageVersion());
        String string2 = "";
        if (!string.equalsIgnoreCase("")) {
            string2 = Resource.getString("FIRMWARE_PKG_VERSION_TEXT", "Firmware Package Version") + ": " + string;
        }
        return string2;
    }
}

