/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.FrameworkInterface;
import Framework.PluginManagers.PluginDataInfo;
import Framework.PluginManagers.PluginInfo;
import Framework.PluginManagers.PluginInterface;
import Framework.PluginManagers.PluginManager;
import KernelExceptions.VKOperationFailedException;
import Services.CommonConstants;
import Services.LogXMLParser;
import Services.NetworkToJavaConverter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.MissingResourceException;
import plugins.Localization;

public class LogService
implements PluginInterface,
CommonConstants {
    private static final int majorGroup = 0;
    private static final int minorGroup = 3;
    private static final String version = "1.03";
    private static final String description = "Log Service Plugin version: 1.03";
    private PluginInfo pluginInfo = new PluginInfo();
    private FrameworkInterface framework = null;
    private static String qualified_log_file_name;
    private int lineCountInLogFile = 0;
    private ArrayList logListeners = new ArrayList();
    private ArrayList kernelLogListeners = new ArrayList();

    @Override
    public boolean init(String string, FrameworkInterface frameworkInterface) {
        this.pluginInfo.setMajorGroup(0);
        this.pluginInfo.setMinorGroup(3);
        this.pluginInfo.setVersion(version);
        this.pluginInfo.setWWN(string);
        this.pluginInfo.setDescription(description);
        this.framework = frameworkInterface;
        qualified_log_file_name = System.getProperty("user.dir") + File.separator + "aaskfdjvuosd.dhdkhsc";
        return this.logLineCount();
    }

    @Override
    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    private synchronized boolean addNewListner(PluginDataInfo pluginDataInfo) {
        Object object;
        int n = NetworkToJavaConverter.byteArrayToInt(pluginDataInfo.getBuffer(), 4);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new Integer(n));
        arrayList.add(pluginDataInfo.getSenderWWN());
        for (int i = this.logListeners.size() - 1; i >= 0; --i) {
            object = (ArrayList)this.logListeners.get(i);
            if (!((String)((ArrayList)object).get(1)).equals(pluginDataInfo.getSenderWWN())) continue;
            this.logListeners.remove(i);
        }
        byte[] byArray = pluginDataInfo.getBuffer();
        object = new byte[2];
        System.arraycopy(byArray, 8, object, 0, 2);
        String string = new String((byte[])object);
        arrayList.add(string);
        String string2 = new String(byArray, 10, 2);
        arrayList.add(string2);
        this.logListeners.add(arrayList);
        byte[] byArray2 = new byte[4];
        NetworkToJavaConverter.intToByteArray(0, byArray2);
        pluginDataInfo.setBuffer(byArray2);
        return true;
    }

    private synchronized boolean addKernelListner(PluginDataInfo pluginDataInfo) {
        Object object;
        int n = NetworkToJavaConverter.byteArrayToInt(pluginDataInfo.getBuffer(), 4);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new Integer(n));
        arrayList.add(pluginDataInfo.getSenderWWN());
        for (int i = this.kernelLogListeners.size() - 1; i >= 0; --i) {
            object = (ArrayList)this.kernelLogListeners.get(i);
            if (!((String)((ArrayList)object).get(1)).equals(pluginDataInfo.getSenderWWN())) continue;
            this.kernelLogListeners.remove(i);
        }
        byte[] byArray = pluginDataInfo.getBuffer();
        object = new byte[2];
        System.arraycopy(byArray, 8, object, 0, 2);
        String string = new String((byte[])object);
        arrayList.add(string);
        String string2 = new String(byArray, 10, 2);
        arrayList.add(string2);
        this.kernelLogListeners.add(arrayList);
        byte[] byArray2 = new byte[4];
        NetworkToJavaConverter.intToByteArray(0, byArray2);
        pluginDataInfo.setBuffer(byArray2);
        return true;
    }

    private synchronized boolean addNewLog(PluginDataInfo pluginDataInfo) {
        byte[] byArray = pluginDataInfo.getBuffer();
        String string = "";
        try {
            string = pluginDataInfo.getSenderWWN().equalsIgnoreCase(this.getMonitorWWN()) ? new String(byArray) : new String(byArray, 4, byArray.length - 4);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("Logger : Error in getting monitor WWN");
        }
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = string.getBytes();
        int n = 0;
        int n2 = 0;
        while (n < byArray3.length && n2 < byArray3.length) {
            if (byArray3[n] == 10 || byArray3[n] == 13) {
                ++n;
                continue;
            }
            byArray3[n2++] = byArray3[n++];
        }
        string = new String(byArray3, 0, n2);
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(qualified_log_file_name, true)));
            printWriter.println(string);
            ++this.lineCountInLogFile;
            printWriter.close();
            NetworkToJavaConverter.intToByteArray(0, byArray2);
            pluginDataInfo.setBuffer(byArray2);
            for (ArrayList arrayList : this.logListeners) {
                LogXMLParser logXMLParser = new LogXMLParser(string);
                Localization localization = new Localization((String)arrayList.get(2), (String)arrayList.get(3));
                logXMLParser.setTagValue("languageCode", localization.getLanguage());
                logXMLParser.setTagValue("localizedMessage", localization.getLocalizedString(logXMLParser.getTagValue("id").trim(), logXMLParser.getParams()));
                String string2 = logXMLParser.getXML();
                String string3 = "";
                for (int i = 0; i < string2.length(); ++i) {
                    if (string2.substring(i).startsWith("amp;")) {
                        i += 3;
                        continue;
                    }
                    string3 = string3 + string2.charAt(i);
                }
                byte[] byArray4 = string3.getBytes();
                byte[] byArray5 = new byte[byArray4.length + 8];
                int n3 = 0;
                NetworkToJavaConverter.intToByteArray((Integer)arrayList.get(0), byArray5);
                NetworkToJavaConverter.intToByteArray(byArray4.length, byArray5, n3 += 4);
                System.arraycopy(byArray4, 0, byArray5, n3 += 4, byArray4.length);
                PluginDataInfo pluginDataInfo2 = new PluginDataInfo();
                pluginDataInfo2.setBuffer(byArray5);
                pluginDataInfo2.setReceiverWWN((String)arrayList.get(1));
                pluginDataInfo2.setSenderWWN(this.pluginInfo.getWWN());
                if (this.framework.ProcessCommand(4099, pluginDataInfo2)) continue;
                this.logListeners.remove(arrayList);
            }
        }
        catch (IOException iOException) {
            NetworkToJavaConverter.intToByteArray(1, byArray2);
            pluginDataInfo.setBuffer(byArray2);
        }
        return true;
    }

    private synchronized boolean addKernelLog(PluginDataInfo pluginDataInfo) {
        byte[] byArray = pluginDataInfo.getBuffer();
        String string = "";
        try {
            string = pluginDataInfo.getSenderWWN().equalsIgnoreCase(this.getMonitorWWN()) ? new String(byArray) : new String(byArray, 4, byArray.length - 4);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("Logger : Error in getting monitor WWN");
        }
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = string.getBytes();
        int n = 0;
        int n2 = 0;
        while (n < byArray3.length && n2 < byArray3.length) {
            if (byArray3[n] == 10 || byArray3[n] == 13) {
                ++n;
                continue;
            }
            byArray3[n2++] = byArray3[n++];
        }
        string = new String(byArray3, 0, n2);
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(qualified_log_file_name, true)));
            ++this.lineCountInLogFile;
            printWriter.println(string);
            printWriter.close();
            NetworkToJavaConverter.intToByteArray(0, byArray2);
            pluginDataInfo.setBuffer(byArray2);
            for (ArrayList arrayList : this.kernelLogListeners) {
                LogXMLParser logXMLParser = new LogXMLParser(string);
                Localization localization = new Localization((String)arrayList.get(2), (String)arrayList.get(3));
                logXMLParser.setTagValue("languageCode", localization.getLanguage());
                logXMLParser.setTagValue("localizedMessage", localization.getLocalizedString(logXMLParser.getTagValue("id").trim(), logXMLParser.getParams()));
                String string2 = logXMLParser.getXML();
                String string3 = "";
                for (int i = 0; i < string2.length(); ++i) {
                    if (string2.substring(i).startsWith("amp;")) {
                        i += 3;
                        continue;
                    }
                    string3 = string3 + string2.charAt(i);
                }
                byte[] byArray4 = string3.getBytes();
                byte[] byArray5 = new byte[byArray4.length + 8];
                int n3 = 0;
                NetworkToJavaConverter.intToByteArray((Integer)arrayList.get(0), byArray5);
                NetworkToJavaConverter.intToByteArray(byArray4.length, byArray5, n3 += 4);
                System.arraycopy(byArray4, 0, byArray5, n3 += 4, byArray4.length);
                PluginDataInfo pluginDataInfo2 = new PluginDataInfo();
                pluginDataInfo2.setBuffer(byArray5);
                pluginDataInfo2.setReceiverWWN((String)arrayList.get(1));
                pluginDataInfo2.setSenderWWN(this.pluginInfo.getWWN());
                if (this.framework.ProcessCommand(4099, pluginDataInfo2)) continue;
                this.kernelLogListeners.remove(arrayList);
            }
        }
        catch (IOException iOException) {
            NetworkToJavaConverter.intToByteArray(1, byArray2);
            pluginDataInfo.setBuffer(byArray2);
        }
        return true;
    }

    private synchronized boolean getLogFileAsString(PluginDataInfo pluginDataInfo) {
        byte[] byArray;
        byte[] byArray2 = pluginDataInfo.getBuffer();
        int n = NetworkToJavaConverter.byteArrayToInt(byArray2, 4);
        int n2 = NetworkToJavaConverter.byteArrayToInt(byArray2, 8);
        byte[] byArray3 = new byte[2];
        System.arraycopy(byArray2, 12, byArray3, 0, 2);
        String string = new String(byArray3);
        String string2 = new String(byArray2, 14, 2);
        Localization localization = new Localization(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        int n3 = 0;
        try {
            int n4;
            bufferedReader = new BufferedReader(new FileReader(qualified_log_file_name));
            byArray = null;
            for (n4 = 0; n4 <= this.lineCountInLogFile - n - n2; ++n4) {
                bufferedReader.readLine();
            }
            while (n4 <= this.lineCountInLogFile - n) {
                block16: {
                    try {
                        LogXMLParser logXMLParser = new LogXMLParser(bufferedReader.readLine());
                        logXMLParser.setTagValue("languageCode", localization.getLanguage());
                        try {
                            logXMLParser.setTagValue("localizedMessage", localization.getLocalizedString(logXMLParser.getTagValue("id").trim(), logXMLParser.getParams()));
                        }
                        catch (NullPointerException nullPointerException) {
                            break block16;
                        }
                        String string3 = logXMLParser.getXML();
                        String string4 = "";
                        for (int i = 0; i < string3.length(); ++i) {
                            if (string3.substring(i).startsWith("amp;")) {
                                i += 3;
                                continue;
                            }
                            string4 = string4 + string3.charAt(i);
                        }
                        arrayList.add(0, string4);
                        ++n3;
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byArray = null;
        int n5 = 12;
        if (n3 != 0) {
            int n6;
            n5 += arrayList.size() * 4;
            for (n6 = 0; n6 < arrayList.size(); ++n6) {
                n5 += ((String)arrayList.get(n6)).length();
            }
            byArray = new byte[n5];
            n6 = 0;
            NetworkToJavaConverter.intToByteArray(0, byArray, n6);
            NetworkToJavaConverter.intToByteArray(n5, byArray, n6 += 4);
            NetworkToJavaConverter.intToByteArray(arrayList.size() >= n2 ? n2 : arrayList.size(), byArray, n6 += 4);
            n6 += 4;
            for (int i = 0; i < arrayList.size() && i < n2; ++i) {
                String string5 = (String)arrayList.get(i);
                NetworkToJavaConverter.intToByteArray(string5.length(), byArray, n6);
                System.arraycopy(string5.getBytes(), 0, byArray, n6 += 4, string5.length());
                n6 += string5.length();
            }
        } else {
            byArray = new byte[n5];
            int n7 = 0;
            NetworkToJavaConverter.intToByteArray(0, byArray, n7);
            NetworkToJavaConverter.intToByteArray(n5, byArray, n7 += 4);
            NetworkToJavaConverter.intToByteArray(0, byArray, n7 += 4);
        }
        pluginDataInfo.setBuffer(byArray);
        return true;
    }

    @Override
    public boolean processCommand(PluginDataInfo pluginDataInfo) {
        int n = NetworkToJavaConverter.byteArrayToInt(pluginDataInfo.getBuffer());
        switch (n) {
            case 1: {
                return this.addNewLog(pluginDataInfo);
            }
            case 2: {
                return this.getLogFileAsString(pluginDataInfo);
            }
            case 3: {
                return this.addNewListner(pluginDataInfo);
            }
            case 8: {
                return this.addKernelListner(pluginDataInfo);
            }
            case 4: {
                return this.clearLog();
            }
            case 5: {
                return this.addNewRemoteLog(pluginDataInfo);
            }
            case 7: {
                return this.addRemoteKernelLog(pluginDataInfo);
            }
            case 6: {
                return this.removeListener(pluginDataInfo);
            }
        }
        String string = "";
        try {
            string = this.getMonitorWWN();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        if (pluginDataInfo.getSenderWWN().equalsIgnoreCase(string)) {
            System.out.println("Logger : cmdType -> " + pluginDataInfo.getCmd());
            int n2 = pluginDataInfo.getCmd();
            if (n2 == 1) {
                return this.addNewLog(pluginDataInfo);
            }
            System.out.println("Inavalid Command received in logservice plugin");
        }
        return false;
    }

    private synchronized boolean addNewRemoteLog(PluginDataInfo pluginDataInfo) {
        byte[] byArray = pluginDataInfo.getBuffer();
        String string = new String(byArray, 4, byArray.length - 4);
        try {
            LogXMLParser logXMLParser = new LogXMLParser(string);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            DecimalFormat decimalFormat = new DecimalFormat("00");
            logXMLParser.setTagValue("dd", decimalFormat.format(gregorianCalendar.get(5)));
            logXMLParser.setTagValue("month", decimalFormat.format(gregorianCalendar.get(2) + 1));
            logXMLParser.setTagValue("yyyy", Integer.toString(gregorianCalendar.get(1)));
            logXMLParser.setTagValue("hh", decimalFormat.format(gregorianCalendar.get(11)));
            logXMLParser.setTagValue("mm", decimalFormat.format(gregorianCalendar.get(12)));
            logXMLParser.setTagValue("ss", decimalFormat.format(gregorianCalendar.get(13)));
            String string2 = logXMLParser.getXML();
            byte[] byArray2 = new byte[4 + string2.length()];
            System.arraycopy(byArray, 0, byArray2, 0, 4);
            System.arraycopy(string2.getBytes(), 0, byArray2, 4, string2.length());
            pluginDataInfo.setBuffer(byArray2);
            return this.addNewLog(pluginDataInfo);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private synchronized boolean addRemoteKernelLog(PluginDataInfo pluginDataInfo) {
        byte[] byArray = pluginDataInfo.getBuffer();
        String string = new String(byArray, 4, byArray.length - 4);
        try {
            LogXMLParser logXMLParser = new LogXMLParser(string);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            DecimalFormat decimalFormat = new DecimalFormat("00");
            logXMLParser.setTagValue("dd", decimalFormat.format(gregorianCalendar.get(5)));
            logXMLParser.setTagValue("month", decimalFormat.format(gregorianCalendar.get(2) + 1));
            logXMLParser.setTagValue("yyyy", Integer.toString(gregorianCalendar.get(1)));
            logXMLParser.setTagValue("hh", decimalFormat.format(gregorianCalendar.get(11)));
            logXMLParser.setTagValue("mm", decimalFormat.format(gregorianCalendar.get(12)));
            logXMLParser.setTagValue("ss", decimalFormat.format(gregorianCalendar.get(13)));
            String string2 = logXMLParser.getXML();
            byte[] byArray2 = new byte[4 + string2.length()];
            System.arraycopy(byArray, 0, byArray2, 0, 4);
            System.arraycopy(string2.getBytes(), 0, byArray2, 4, string2.length());
            pluginDataInfo.setBuffer(byArray2);
            return this.addKernelLog(pluginDataInfo);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private synchronized boolean clearLog() {
        File file = new File(qualified_log_file_name);
        try {
            if (file.exists()) {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write("");
                fileWriter.close();
                this.lineCountInLogFile = 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void shutdown() {
    }

    private synchronized boolean logLineCount() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(qualified_log_file_name));
            this.lineCountInLogFile = 0;
            while (bufferedReader.readLine() != null) {
                ++this.lineCountInLogFile;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private synchronized boolean removeListener(PluginDataInfo pluginDataInfo) {
        for (int i = this.logListeners.size() - 1; i >= 0; --i) {
            ArrayList arrayList = (ArrayList)this.logListeners.get(i);
            if (!((String)arrayList.get(1)).equals(pluginDataInfo.getSenderWWN())) continue;
            this.logListeners.remove(i);
            break;
        }
        byte[] byArray = new byte[4];
        NetworkToJavaConverter.intToByteArray(0, byArray);
        pluginDataInfo.setBuffer(byArray);
        return true;
    }

    private String getMonitorWWN() throws VKOperationFailedException {
        PluginInfo[] pluginInfoArray = this.getPlugIns();
        for (int i = 0; i < pluginInfoArray.length; ++i) {
            if (0 != pluginInfoArray[i].getMajorGroup() || 8 != pluginInfoArray[i].getMinorGroup()) continue;
            return pluginInfoArray[i].getWWN();
        }
        throw new VKOperationFailedException(4096);
    }

    private String getCIMOMMonitorWWN() throws VKOperationFailedException {
        PluginInfo[] pluginInfoArray = this.getPlugIns();
        for (int i = 0; i < pluginInfoArray.length; ++i) {
            if (0 != pluginInfoArray[i].getMajorGroup() || 11 != pluginInfoArray[i].getMinorGroup()) continue;
            return pluginInfoArray[i].getWWN();
        }
        throw new VKOperationFailedException(4096);
    }

    public PluginInfo[] getPlugIns() {
        PluginInfo[] pluginInfoArray = PluginManager.getListOfPlugins();
        return pluginInfoArray;
    }

    @Override
    public void startupOperations() {
    }

    @Override
    public void preShutdown() {
    }
}

