/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_ENCL_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_PD_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_CONNECTORS;
import java.util.ArrayList;
import plugins.AdapterDetails;
import plugins.AdapterInfo;
import plugins.AdapterRegistration;
import plugins.AlertAction;
import plugins.AlertsConfigData;
import plugins.CIMOMMonitorService;
import plugins.ConnectorList;
import plugins.EmailContent;
import plugins.EnclosureList;
import plugins.PhysicalDeviceList;
import plugins.TimeSyncThread;
import plugins.Utils.PluginsWWN;

public class ManageCIMOMServer {
    public AdapterInfo[] m_ctrlInfo = null;
    public EnclosureList[] m_enclList = null;
    public PhysicalDeviceList[] m_pdList = null;
    public ConnectorList[] m_sasConnectors = null;
    private String m_configFileName = "";
    private String m_logFileName = "";
    public static ArrayList m_smtpPortNum = null;
    private ArrayList m_serverName = null;
    private ArrayList m_target = null;
    private ArrayList m_sender = null;
    private ArrayList m_userName = null;
    private ArrayList m_password = null;
    private ArrayList m_authentication = null;
    private ArrayList m_senderNICAddress = null;
    private AdapterRegistration m_adpreg = null;
    private TimeSyncThread m_timesync = null;
    public static final int CIMOM_CONTROLLER_TYPE = 127;
    private byte[] ip;
    private byte[] port;
    private byte[] userName;
    private byte[] password;
    private ArrayList m_controllerList;

    ManageCIMOMServer() {
    }

    ManageCIMOMServer(byte[] byArray) {
        int n = 0;
        this.ip = new byte[32];
        System.arraycopy(byArray, n += 4, this.ip, 0, this.ip.length);
        this.port = new byte[4];
        System.arraycopy(byArray, n += 32, this.port, 0, this.port.length);
        this.userName = new byte[256];
        System.arraycopy(byArray, n += 4, this.userName, 0, this.userName.length);
        this.password = new byte[256];
        System.arraycopy(byArray, n += 256, this.password, 0, this.password.length);
    }

    public byte[] getCIMMOMIP() {
        return this.ip;
    }

    public byte[] getCIMMOMPort() {
        return this.port;
    }

    public byte[] getCIMMOMUserName() {
        return this.userName;
    }

    public byte[] getCIMMOMPassword() {
        return this.password;
    }

    public ManageCIMOMServer getInstance(String string) {
        String string2 = new String(this.getCIMMOMIP());
        if (string.equalsIgnoreCase(string2)) {
            return this;
        }
        return null;
    }

    public void setControllerList(ArrayList arrayList) {
        ArrayList<AdapterDetails> arrayList2 = new ArrayList<AdapterDetails>();
        System.out.println("ManageCIMOMServer.setControllerList() controller count = " + arrayList.size());
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Integer n = (Integer)arrayList.get(i);
                Integer n2 = 127;
                AdapterDetails adapterDetails = new AdapterDetails();
                adapterDetails.setControllerIndex(i);
                adapterDetails.setControllerID(n);
                adapterDetails.setControllerType(n2);
                arrayList2.add(adapterDetails);
            }
        }
        this.m_controllerList = arrayList2;
        System.out.println("ManageCIMOMServer.setControllerList() adpList size = " + this.m_controllerList.size());
    }

    public AdapterInfo[] getArrayOfAdapterInfo() {
        return this.m_ctrlInfo;
    }

    public void updtaeArrayOfAdapterInfo(AdapterInfo[] adapterInfoArray) {
        this.m_ctrlInfo = adapterInfoArray;
    }

    public ArrayList getControllerList() {
        return this.m_controllerList;
    }

    public void updateControllerInfo() {
        MR_CTRL_INFO mR_CTRL_INFO = null;
        MR_ENCL_LIST mR_ENCL_LIST = null;
        MR_SAS_CONNECTORS mR_SAS_CONNECTORS = null;
        MR_PD_LIST mR_PD_LIST = null;
        EmailContent emailContent = null;
        String string = "";
        try {
            string = PluginsWWN.getCIMPluginWWN();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("Exception @ ManageCIMMOMServer assign CIMWWN");
        }
        ArrayList arrayList = this.getControllerList();
        Object var8_9 = null;
        this.m_ctrlInfo = new AdapterInfo[arrayList.size() + 1];
        this.m_enclList = new EnclosureList[arrayList.size() + 1];
        this.m_pdList = new PhysicalDeviceList[arrayList.size() + 1];
        this.m_sasConnectors = new ConnectorList[arrayList.size() + 1];
        for (int i = 0; i < arrayList.size(); ++i) {
            AdapterDetails adapterDetails = (AdapterDetails)arrayList.get(i);
            try {
                this.m_ctrlInfo[i] = new AdapterInfo(adapterDetails.getControllerID(), PluginsWWN.getCIMOMMonitorWWN(), string, CIMOMMonitorService.m_objFramework, this, true);
                mR_CTRL_INFO = this.m_ctrlInfo[i].getMR_CTRL_INFO();
                System.out.println("i===" + i);
                System.out.println("PDList size " + this.m_pdList.length);
                this.m_pdList[i] = new PhysicalDeviceList(adapterDetails.getControllerID(), PluginsWWN.getCIMOMMonitorWWN(), string, CIMOMMonitorService.m_objFramework, this, true);
                mR_PD_LIST = this.m_pdList[i].getMR_PD_LIST();
                this.m_ctrlInfo[i].setPDList(mR_PD_LIST);
                this.m_pdList[i].setControllerID(adapterDetails.getControllerID());
                emailContent = new EmailContent(adapterDetails.getControllerID(), PluginsWWN.getCIMOMMonitorWWN(), string, CIMOMMonitorService.m_objFramework, this, true, mR_CTRL_INFO);
                this.m_ctrlInfo[i].setEmailContent(emailContent);
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                System.out.println("Exception in MonitorService while assi ctrlInfo and PDList");
                vKOperationFailedException.printStackTrace();
            }
            if (mR_CTRL_INFO.getadapterOperations_MR_CTRL_INFO().getsupportEnclEnumeration() == 1) {
                try {
                    this.m_enclList[i] = new EnclosureList(adapterDetails.getControllerID(), PluginsWWN.getCIMOMMonitorWWN(), string, CIMOMMonitorService.m_objFramework, this, true);
                    mR_ENCL_LIST = this.m_enclList[i].getMR_ENCL_LIST();
                    this.m_ctrlInfo[i].setEnclList(mR_ENCL_LIST);
                    System.out.println(" ==> ManageCIMOMServer.updateControllerInfo() enclosure count = " + mR_ENCL_LIST.getcount());
                    this.m_enclList[i].setControllerID(adapterDetails.getControllerID());
                    this.m_sasConnectors[i] = new ConnectorList(adapterDetails.getControllerID(), PluginsWWN.getCIMOMMonitorWWN(), string, CIMOMMonitorService.m_objFramework, this, true);
                    mR_SAS_CONNECTORS = this.m_sasConnectors[i].getMR_SAS_CONNECTORS();
                    if (mR_SAS_CONNECTORS == null) continue;
                    this.m_ctrlInfo[i].setConnectors(mR_SAS_CONNECTORS);
                    int n = mR_SAS_CONNECTORS.getCount();
                    System.out.println(" ==> ManageCIMOMServer.updateControllerInfo() connector count = " + n);
                    this.m_sasConnectors[i].setControllerID(adapterDetails.getControllerID());
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    System.out.println("Exception in MonitorService while assi connectors and EnclList");
                    vKOperationFailedException.printStackTrace();
                }
                continue;
            }
            this.m_enclList[i] = null;
            this.m_sasConnectors[i] = null;
        }
    }

    public void updateEmailCfg(AlertsConfigData alertsConfigData) {
        AlertAction alertAction = alertsConfigData.getAction("email");
        if (alertAction == null) {
            System.out.println("email Action is null");
        } else {
            this.m_serverName = alertAction.getParam("servername");
            this.m_target = alertAction.getParam("email-target");
            this.m_sender = alertAction.getParam("sender");
            this.m_userName = alertAction.getParam("username");
            this.m_password = alertAction.getParam("password");
            this.m_authentication = alertAction.getParam("authentication-type");
            this.m_senderNICAddress = alertAction.getParam("nic");
            m_smtpPortNum = alertAction.getParam("port");
        }
        for (int i = 0; i < this.m_target.size(); ++i) {
            System.out.println("target [" + i + "] = " + (String)this.m_target.get(i));
        }
    }

    public void setConfigFileName(String string) {
        this.m_configFileName = string;
    }

    public String getConfigFileName() {
        return this.m_configFileName;
    }

    public void setLogFileName(String string) {
        this.m_logFileName = string;
    }

    public String getLogFileName() {
        return this.m_logFileName;
    }

    public String getEmailServerName() {
        String string = null;
        string = (String)this.m_serverName.get(0);
        return string;
    }

    public String getAuthenticationType() {
        String string = null;
        string = (String)this.m_authentication.get(0);
        return string;
    }

    public String getLocalServerNICAddr() {
        String string = null;
        string = (String)this.m_senderNICAddress.get(0);
        return string;
    }

    public String getSMTPPortNum() {
        String string = null;
        string = (String)m_smtpPortNum.get(0);
        return string;
    }

    public String getSenderMail() {
        String string = null;
        string = (String)this.m_sender.get(0);
        return string;
    }

    public ArrayList getTarget() {
        ArrayList arrayList = null;
        arrayList = this.m_target;
        return arrayList;
    }

    public byte[] getUserName() {
        byte[] byArray = null;
        byArray = this.m_userName.get(0).toString().trim().getBytes();
        return byArray;
    }

    public byte[] getPassword() {
        byte[] byArray = null;
        byArray = this.m_password.get(0).toString().trim().getBytes();
        return byArray;
    }

    public void startTimeSyncThread() {
        ArrayList arrayList = this.getControllerList();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i = 0; i < arrayList.size(); ++i) {
            AdapterDetails adapterDetails = (AdapterDetails)arrayList.get(i);
            arrayList2.add(adapterDetails.getControllerID());
            arrayList3.add(127);
        }
        this.m_timesync = new TimeSyncThread(CIMOMMonitorService.m_objFramework, arrayList2, arrayList3, this, true);
        this.m_timesync.start();
    }

    public void stopTimeSyncThread() {
        if (this.m_timesync != null) {
            if (this.m_timesync.isAlive()) {
                this.m_timesync.stop();
            }
            this.m_timesync = null;
        }
    }

    public void registerForAEN() {
        ArrayList arrayList = this.getControllerList();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i = 0; i < arrayList.size(); ++i) {
            AdapterDetails adapterDetails = (AdapterDetails)arrayList.get(i);
            arrayList2.add(adapterDetails.getControllerID());
            arrayList3.add(127);
        }
        this.m_adpreg = new AdapterRegistration(CIMOMMonitorService.m_objFramework, arrayList2, arrayList3, this, true);
        this.m_adpreg.start();
    }

    public void UnRegisterForAEN() {
        try {
            this.m_adpreg.unRegisterAEN();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("ManageCIMOMServer.UnRegisterForAEN() Exception @ ");
        }
    }
}

