/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.ClientManagers.ClientInfo;
import Framework.ClientManagers.ClientManager;
import Framework.FrameworkInterface;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Framework.PluginManagers.PluginDataInfo;
import Framework.PluginManagers.PluginInfo;
import Framework.PluginManagers.PluginInterface;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_ENCL_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_LOG_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_PD_LIST;
import SASKernel.LibraryAPI.StoreLib.MR_SAS_CONNECTORS;
import SASKernel.LibraryAPI.StoreLib.MR_TIME_STAMP;
import SASKernel.LibraryAPI.StoreLib.SL_EVENT_DETAIL_T;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import Services.CommonConstants;
import Services.KernelConstants;
import Services.LogXMLParser;
import Services.NetworkDataPacket;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import plugins.AdapterDetails;
import plugins.AdapterInfo;
import plugins.AdapterRegistration;
import plugins.AlertAction;
import plugins.AlertActionEmail;
import plugins.AlertConfigWriter;
import plugins.AlertEventDetails;
import plugins.AlertsConfigData;
import plugins.AlertsGlobalConfig;
import plugins.ConnectorList;
import plugins.EmailContent;
import plugins.EnclosureList;
import plugins.EventXMLFormation;
import plugins.Localization;
import plugins.MR_EVENT_ARGS;
import plugins.ParseXMLString;
import plugins.PhysicalDeviceList;
import plugins.SASAdapterList;
import plugins.StorelibPlugin;
import plugins.TimeSyncThread;
import plugins.Utils.PluginsWWN;
import plugins.Utils.Resource;
import plugins.XMLParser;

public class MonitorService
implements PluginInterface,
CommonConstants,
MR_EVENT_ARGS {
    private static final int majorGroup = 0;
    private static final int minorGroup = 8;
    private static final String version = "1.10";
    private static final String description = "Monitor Plugin version: 1.10";
    public static PluginInfo pluginInfo = new PluginInfo();
    public static FrameworkInterface objFramework = null;
    private String m_xmlString = "";
    private String m_localizedStr = "";
    private PluginDataInfo m_pluginDataInfo = null;
    public static SL_EVENT_DETAIL_T m_slObject = null;
    private SASAdapterList m_sasAdpList = null;
    public static AdapterInfo[] m_ctrlInfo = null;
    public EnclosureList[] m_enclList = null;
    public PhysicalDeviceList[] m_pdList = null;
    public ConnectorList[] m_sasConnectors = null;
    public EventXMLFormation m_evtDesc = null;
    private AdapterRegistration m_regAENObj = null;
    private TimeSyncThread m_timeSyncObj = null;
    public static String m_qualified_log_file_name;
    private int m_lineCountInLogFile = 0;
    private static final String m_config_file_name = "config-current.xml";
    private static String m_qualified_config_file_name;
    public static String m_qualified_popup_log_file_name;
    public static ArrayList m_smtpPortNum;
    public static ArrayList m_serverName;
    public static ArrayList m_target;
    public static ArrayList m_sender;
    public static ArrayList m_senderNICAddress;
    public static ArrayList m_userName;
    public static ArrayList m_password;
    public static ArrayList m_autentication;
    private AlertsConfigData m_alertConfig;
    private int m_OldSequenceNum = 0;
    public ClientInfo m_monitorClientInfo;
    private static boolean m_isPopupStarted;

    public MonitorService() {
        System.out.println("Monitor constructor");
    }

    @Override
    public boolean init(String string, FrameworkInterface frameworkInterface) {
        System.out.println("Inside Monitor init");
        objFramework = frameworkInterface;
        pluginInfo.setMajorGroup(0);
        pluginInfo.setMinorGroup(8);
        pluginInfo.setVersion(version);
        pluginInfo.setWWN(string);
        pluginInfo.setDescription(description);
        m_qualified_log_file_name = System.getProperty("user.dir") + File.separator + "aaskfdjvuosd.dhdkhsc";
        m_qualified_config_file_name = ".." + File.separator + "MegaMonitor" + File.separator + m_config_file_name;
        m_qualified_popup_log_file_name = System.getProperty("user.dir") + File.separator + "popinit.logfrmboot";
        System.out.println("Monitor init over");
        return true;
    }

    private synchronized void logLineCount() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(m_qualified_log_file_name));
            this.m_lineCountInLogFile = 0;
            while (bufferedReader.readLine() != null) {
                ++this.m_lineCountInLogFile;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("qualified_log_file_name not found");
        }
        catch (IOException iOException) {
            System.out.println("qualified_log_file_name have I/O Exception");
        }
    }

    @Override
    public void startupOperations() {
        try {
            Object object;
            this.m_monitorClientInfo = new ClientInfo();
            this.registerWithFramework();
            try {
                object = new File(".." + File.separator + "MonitorPlugin");
                if (!((File)object).exists()) {
                    boolean bl = ((File)object).mkdir();
                    if (bl) {
                        System.out.println("MonitorService.startupOperations() MonitorPlugin directory created");
                    } else {
                        System.out.println("MonitorService.startupOperations() MonitorPlugin directory not created");
                    }
                } else {
                    System.out.println("MonitorService.startupOperations() MonitorPlugin exists");
                }
            }
            catch (Exception exception) {
                System.out.println("MonitorService.startupOperations() exception @ creation MoniotorPlug-in directory");
                exception.printStackTrace();
            }
            object = new XMLParser();
            try {
                ((XMLParser)object).parse(new FileInputStream(m_qualified_config_file_name));
            }
            catch (IOException iOException) {
                System.out.println("I/O Exception");
                iOException.printStackTrace();
            }
            this.m_alertConfig = ((XMLParser)object).getConfig();
            if (this.m_alertConfig == null) {
                System.out.println("Config is Null");
            } else {
                this.updateEmailCfg();
            }
            this.m_evtDesc = new EventXMLFormation();
            this.m_sasAdpList = new SASAdapterList(objFramework);
            this.m_sasAdpList.createSASAdapters();
            this.updateControllerInfo();
            ArrayList arrayList = this.m_sasAdpList.getAdapterList();
            ArrayList arrayList2 = this.m_sasAdpList.getAdapterTypeList();
            this.m_regAENObj = new AdapterRegistration(objFramework, arrayList, arrayList2, null, false);
            this.m_regAENObj.start();
            this.m_timeSyncObj = new TimeSyncThread(objFramework, arrayList, arrayList2, null, false);
            this.m_timeSyncObj.start();
        }
        catch (Exception exception) {
            System.out.println("Exception while doing startup operations in Monitor Plugin");
            exception.printStackTrace();
        }
    }

    private void registerWithFramework() throws IOException, VivaldiFrameworkProtocolErrorException {
        int n = 3071;
        System.out.println("MonitorService.registerWithFramework() Free port = " + n);
        byte[] byArray = new byte[512];
        int n2 = 0;
        NetworkToJavaConverter.intToByteArray(0, byArray);
        NetworkToJavaConverter.intToByteArray(9, byArray, n2 += 4);
        byte[] byArray2 = version.getBytes();
        System.arraycopy(byArray2, 0, byArray, n2 += 4, byArray2.length >= 32 ? 32 : byArray2.length);
        NetworkToJavaConverter.intToByteArray(n, byArray, n2 += 32);
        byte[] byArray3 = description.getBytes();
        System.arraycopy(byArray3, 0, byArray, n2 += 4, byArray3.length >= 256 ? 256 : byArray3.length);
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
        PluginDataInfo pluginDataInfo = null;
        try {
            pluginDataInfo = new PluginDataInfo(PluginsWWN.getMonitorWWN(), objFramework.getFrameworkInfo().getFrameworkWWN(), networkDataPacket.getDataBuffer());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (pluginDataInfo != null) {
            objFramework.ProcessCommand(268, pluginDataInfo);
            this.m_monitorClientInfo.setWWN(NetworkPacket.convertByteArrayToWWNString(pluginDataInfo.getBuffer()));
            System.out.println("Monitor Client WWN = " + this.m_monitorClientInfo.getWWN());
        }
    }

    private void unRegisterWithFramework() {
        if (this.m_monitorClientInfo == null) {
            return;
        }
        byte[] byArray = NetworkPacket.convertWWNStringToByteArray(this.m_monitorClientInfo.getWWN());
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(byArray);
        PluginDataInfo pluginDataInfo = null;
        try {
            pluginDataInfo = new PluginDataInfo(PluginsWWN.getMonitorWWN(), objFramework.getFrameworkInfo().getFrameworkWWN(), networkDataPacket.getDataBuffer());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        boolean bl = false;
        if (pluginDataInfo != null) {
            bl = objFramework.ProcessCommand(258, pluginDataInfo);
        }
        System.out.println("MonitorService.unRegisterWithFramework() Unregister " + this.m_monitorClientInfo.getWWN() + "= " + bl);
    }

    @Override
    public PluginInfo getPluginInfo() {
        return pluginInfo;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean processCommand(PluginDataInfo var1_1) {
        try {
            this.m_pluginDataInfo = var1_1;
            var2_2 = this.m_pluginDataInfo.getCmd();
            block16 : switch (var2_2) {
                case 278: {
                    System.out.println("MonitorService.processCommand() inside POPUP_NOTIFICATION2MONITOR");
                    var3_4 = this.m_pluginDataInfo.getBuffer();
                    System.out.println("MonitorService.processCommand() size == " + var3_4.length);
                    var4_8 = NetworkToJavaConverter.byteArrayToInt(var3_4, 8);
                    MonitorService.m_isPopupStarted = var4_8 == 0;
                    var5_19 = this.doPopupIntialLog();
                    if (var5_19) {
                        var6_25 = null;
                        try {
                            var6_25 = new PrintWriter(new BufferedWriter(new FileWriter(MonitorService.m_qualified_popup_log_file_name, false)));
                            var6_25.println("");
                            var6_25.close();
                        }
                        catch (IOException var7_28) {
                            if (var6_25 != null) {
                                try {
                                    var6_25.close();
                                }
                                catch (Exception var8_36) {
                                    System.out.println("MonitorService.processCommand() Exception @ closing PrintWriter object");
                                    var8_36.printStackTrace();
                                }
                            }
                            System.out.println("IOException in Monitor Service -> DOPopUp clean the events in a file");
                        }
                    }
                    return true;
                }
                case 6: {
                    var3_5 = NetworkToJavaConverter.byteArrayToInt(var1_1.getBuffer());
                    switch (var3_5) {
                        case 9: {
                            System.out.println("MonitorService.processCommand()Inside GET_VIVALDI_LOG_CFG");
                            var4_9 = this.getVivaldiConfig();
                            var1_1.setBuffer(var4_9);
                            break block16;
                        }
                    }
                    System.out.println("MonitorService.processCommand()inside sakernel default call");
                    break;
                }
                case 4098: {
                    System.out.println("STORELIB_CALLBACK");
                    MonitorService.m_slObject = new SL_EVENT_DETAIL_T(this.m_pluginDataInfo.getBuffer(), 0);
                    System.out.println("Event id = " + MonitorService.m_slObject.getevtDetail().getcode() + "\n" + "Sequnce number = " + MonitorService.m_slObject.getevtDetail().getseqNum() + "\n" + "Event Description = " + new String(MonitorService.m_slObject.getevtDetail().getdescription()));
                    if (MonitorService.m_slObject.getevtDetail().getcl().geteventClass() == -1) break;
                    switch (MonitorService.m_slObject.getevtDetail().getcode()) {
                        case 91: 
                        case 112: 
                        case 166: 
                        case 167: 
                        case 462: 
                        case 463: {
                            if (this.storeLatestSequenceNumber()) {
                                if (this.getSeqNum() < this.m_OldSequenceNum) break;
                                var3_6 = null;
                                try {
                                    var3_6 = new EnclosureList(MonitorService.m_slObject.getctrlId(), PluginsWWN.getMonitorWWN(), this.getReceiverWWN(MonitorService.m_slObject.getctrlId()), MonitorService.objFramework, null, false);
                                    var4_10 = var3_6.getMR_ENCL_LIST();
                                    MonitorService.m_ctrlInfo[this.m_sasAdpList.getControllerIndex(MonitorService.m_slObject.getctrlId())].setEnclList((MR_ENCL_LIST)var4_10);
                                }
                                catch (VKOperationFailedException var4_11) {
                                    System.out.println("Exception at getting EnclList once got MR_EVT_ENCL_COMMUNICATION_LOST | MR_EVT_ENCL_COMMUNICATION_Restored Event");
                                }
                                var4_10 = null;
                                try {
                                    var4_10 = new PhysicalDeviceList(MonitorService.m_slObject.getctrlId(), PluginsWWN.getMonitorWWN(), this.getReceiverWWN(MonitorService.m_slObject.getctrlId()), MonitorService.objFramework, null, false);
                                    var5_20 = var4_10.getMR_PD_LIST();
                                    MonitorService.m_ctrlInfo[this.m_sasAdpList.getControllerIndex(MonitorService.m_slObject.getctrlId())].setPDList((MR_PD_LIST)var5_20);
                                }
                                catch (VKOperationFailedException var5_21) {
                                    System.out.println("Exception at getting PDList once got MR_EVT_ENCL_COMMUNICATION_LOST | MR_EVT_ENCL_COMMUNICATION_Restored Event");
                                }
                                break;
                            }
                            var3_6 = null;
                            try {
                                var3_6 = new EnclosureList(MonitorService.m_slObject.getctrlId(), PluginsWWN.getMonitorWWN(), this.getReceiverWWN(MonitorService.m_slObject.getctrlId()), MonitorService.objFramework, null, false);
                                var4_10 = var3_6.getMR_ENCL_LIST();
                                MonitorService.m_ctrlInfo[this.m_sasAdpList.getControllerIndex(MonitorService.m_slObject.getctrlId())].setEnclList((MR_ENCL_LIST)var4_10);
                            }
                            catch (VKOperationFailedException var4_12) {
                                System.out.println("Exception at getting EnclList once got MR_EVT_ENCL_COMMUNICATION_LOST | MR_EVT_ENCL_COMMUNICATION_Restored Event");
                            }
                            var4_10 = null;
                            try {
                                var4_10 = new PhysicalDeviceList(MonitorService.m_slObject.getctrlId(), PluginsWWN.getMonitorWWN(), this.getReceiverWWN(MonitorService.m_slObject.getctrlId()), MonitorService.objFramework, null, false);
                                var5_20 = var4_10.getMR_PD_LIST();
                                MonitorService.m_ctrlInfo[this.m_sasAdpList.getControllerIndex(MonitorService.m_slObject.getctrlId())].setPDList((MR_PD_LIST)var5_20);
                            }
                            catch (VKOperationFailedException var5_22) {
                                System.out.println("Exception at getting PDList once got MR_EVT_ENCL_COMMUNICATION_LOST | MR_EVT_ENCL_COMMUNICATION_Restored Event");
                            }
                            break;
                        }
                        case 141: 
                        case 161: {
                            if (this.storeLatestSequenceNumber()) {
                                if (this.getSeqNum() < this.m_OldSequenceNum) break;
                                var3_6 = null;
                                try {
                                    var3_6 = new PhysicalDeviceList(MonitorService.m_slObject.getctrlId(), PluginsWWN.getMonitorWWN(), this.getReceiverWWN(MonitorService.m_slObject.getctrlId()), MonitorService.objFramework, null, false);
                                    var4_10 = var3_6.getMR_PD_LIST();
                                    MonitorService.m_ctrlInfo[this.m_sasAdpList.getControllerIndex(MonitorService.m_slObject.getctrlId())].setPDList((MR_PD_LIST)var4_10);
                                }
                                catch (VKOperationFailedException var4_13) {
                                    System.out.println("Exception at getting PDList once got a Event");
                                }
                                break;
                            }
                            var3_6 = null;
                            try {
                                var3_6 = new PhysicalDeviceList(MonitorService.m_slObject.getctrlId(), PluginsWWN.getMonitorWWN(), this.getReceiverWWN(MonitorService.m_slObject.getctrlId()), MonitorService.objFramework, null, false);
                                var4_10 = var3_6.getMR_PD_LIST();
                                MonitorService.m_ctrlInfo[this.m_sasAdpList.getControllerIndex(MonitorService.m_slObject.getctrlId())].setPDList((MR_PD_LIST)var4_10);
                            }
                            catch (VKOperationFailedException var4_14) {
                                System.out.println("Exception at getting PDList once got a Event");
                            }
                            break;
                        }
                        case 1: {
                            var3_6 = new EmailContent(MonitorService.m_slObject.getctrlId(), PluginsWWN.getMonitorWWN(), this.getReceiverWWN(MonitorService.m_slObject.getctrlId()), MonitorService.objFramework, null, false, MonitorService.m_ctrlInfo[this.m_sasAdpList.getControllerIndex(MonitorService.m_slObject.getctrlId())].getMR_CTRL_INFO());
                            MonitorService.m_ctrlInfo[this.m_sasAdpList.getControllerIndex(MonitorService.m_slObject.getctrlId())].setEmailContent((EmailContent)var3_6);
                            break;
                        }
                    }
                    try {
                        var4_15 = MonitorService.m_slObject.getevtDetail().getcode();
                        var3_6 = this.m_alertConfig.getAlertEvent(var4_15);
                        if (var3_6.usesGlobal()) {
                            var5_20 = this.m_alertConfig.getGlobal(var3_6.getSeverity());
                            if (var5_20 != null && var5_20.getActionsCount() <= 0) {
                                break;
                            }
                        } else if (var3_6.getActionsCount() <= 0) {
                        }
                        ** GOTO lbl121
                    }
                    catch (Exception var4_16) {
                        System.out.println("Don't have a alert Event");
                    }
                    break;
lbl121:
                    // 2 sources

                    this.m_evtDesc.setAdapterInformation(MonitorService.m_ctrlInfo);
                    this.m_evtDesc.setControllerIndex(this.m_sasAdpList.getControllerIndex(MonitorService.m_slObject.getctrlId()));
                    this.m_xmlString = this.m_evtDesc.getEventXMLFormat(false, "", MonitorService.m_slObject);
                    var4_17 = new LogXMLParser(this.m_xmlString);
                    var5_23 = var3_6.getSeverity();
                    var4_17.setTagValue("class", Integer.toString(var5_23));
                    this.m_xmlString = var4_17.getXML();
                    this.m_localizedStr = this.getEventinLocFormat(this.m_xmlString);
                    var6_26 = var4_17.getMessageClass();
                    var7_29 = this.m_xmlString.getBytes();
                    System.out.println("do msm log");
                    var8_37 = new PluginDataInfo();
                    var8_37.setBuffer(var7_29);
                    var8_37.setCmd(1);
                    try {
                        var8_37.setReceiverWWN(PluginsWWN.getLoggerWWN());
                        var8_37.setSenderWWN(PluginsWWN.getMonitorWWN());
                        MonitorService.objFramework.ProcessCommand(1, var8_37);
                    }
                    catch (VKOperationFailedException var9_42) {
                        System.out.println("Error - assigning Logger WWN as receiver in Monitorplugin");
                    }
                    var9_43 = MonitorService.m_slObject.getctrlId();
                    var10_47 = new Properties();
                    try {
                        var11_51 = new File(CommonConstants.MONITOR_PLUGIN_TEMP_FOLDER_FW + AdapterRegistration.m_stdAdpPropertyFileName + this.m_sasAdpList.getControllerIndex(var9_43) + ".properties");
                        if (var11_51.exists()) {
                            var10_47.load(new FileInputStream((File)var11_51));
                            if (var10_47.getProperty("ADAPTER_ID") == null) {
                                var10_47.setProperty("ADAPTER_INDEX", new Integer(this.m_sasAdpList.getControllerIndex(var9_43)).toString());
                                var10_47.setProperty("ADAPTER_ID", new Integer(var9_43).toString());
                                var10_47.setProperty("ADAPTER_LAST_SEQNUM", new Integer(MonitorService.m_slObject.getevtDetail().getseqNum()).toString());
                                var10_47.setProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP", new Integer(MonitorService.m_slObject.getevtDetail().gettimeStamp()).toString());
                            } else if (Integer.parseInt(var10_47.getProperty("ADAPTER_ID")) == var9_43) {
                                var10_47.remove("ADAPTER_LAST_SEQNUM");
                                var10_47.setProperty("ADAPTER_LAST_SEQNUM", new Integer(MonitorService.m_slObject.getevtDetail().getseqNum()).toString());
                                if (var10_47.getProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP") == null) {
                                    var10_47.setProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP", new Integer(MonitorService.m_slObject.getevtDetail().gettimeStamp()).toString());
                                } else {
                                    var10_47.remove("ADAPTER_LAST_SEQNUM_TIMESTAMP");
                                    var10_47.setProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP", new Integer(MonitorService.m_slObject.getevtDetail().gettimeStamp()).toString());
                                }
                            } else {
                                var10_47.remove("ADAPTER_LAST_SEQNUM");
                                var10_47.remove("ADAPTER_ID");
                                var10_47.remove("ADAPTER_INDEX");
                                var10_47.setProperty("ADAPTER_INDEX", new Integer(this.m_sasAdpList.getControllerIndex(var9_43)).toString());
                                var10_47.setProperty("ADAPTER_ID", new Integer(var9_43).toString());
                                var10_47.setProperty("ADAPTER_LAST_SEQNUM", new Integer(MonitorService.m_slObject.getevtDetail().getseqNum()).toString());
                                if (var10_47.getProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP") == null) {
                                    var10_47.setProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP", new Integer(MonitorService.m_slObject.getevtDetail().gettimeStamp()).toString());
                                } else {
                                    var10_47.remove("ADAPTER_LAST_SEQNUM_TIMESTAMP");
                                    var10_47.setProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP", new Integer(MonitorService.m_slObject.getevtDetail().gettimeStamp()).toString());
                                }
                            }
                        } else {
                            System.out.println("MonitorService.processCommand() file not found " + var11_51.getName());
                            var11_51.createNewFile();
                            var10_47.load(new FileInputStream((File)var11_51));
                            var10_47.setProperty("ADAPTER_INDEX", new Integer(this.m_sasAdpList.getControllerIndex(var9_43)).toString());
                            var10_47.setProperty("ADAPTER_ID", new Integer(var9_43).toString());
                            var10_47.setProperty("ADAPTER_LAST_SEQNUM", new Integer(MonitorService.m_slObject.getevtDetail().getseqNum()).toString());
                            var10_47.setProperty("ADAPTER_LAST_SEQNUM_TIMESTAMP", new Integer(MonitorService.m_slObject.getevtDetail().gettimeStamp()).toString());
                        }
                        var10_47.store(new FileOutputStream((File)var11_51), null);
                    }
                    catch (Exception var11_52) {
                        var11_52.printStackTrace();
                    }
                    if (var6_26 < 0 || var6_26 > 4) {
                        System.out.println("Severity = " + var6_26 + " Seq Num = " + MonitorService.m_slObject.getevtDetail().getseqNum());
                        var6_26 = 0;
                    }
                    try {
                        if (var3_6.usesGlobal()) {
                            System.out.println("using global");
                            var11_51 = this.m_alertConfig.getGlobal(var6_26);
                            if (var11_51 != null) {
                                if (var11_51.hasAction("vivaldilog")) {
                                    // empty if block
                                }
                                if (var11_51.hasAction("email")) {
                                    var12_58 = Resource.getString("EVENT_ID", "Event ID:");
                                    this.m_localizedStr = this.m_localizedStr + '\n' + var12_58 + this.getEventCode();
                                    this.alertActionEmail(this.m_localizedStr, var6_26);
                                }
                                if (var11_51.hasAction("systemlog")) {
                                    this.alertActionSysLog(this.m_localizedStr, var6_26);
                                }
                                if (var11_51.hasAction("popup")) {
                                    this.alertActionPopup(this.m_xmlString);
                                }
                            }
                        } else {
                            System.out.println("not using global");
                            var11_53 = var3_6.getActionsCount();
                            System.out.println("action Count ->" + var11_53);
                            if (var3_6.hasAction("vivaldilog")) {
                                // empty if block
                            }
                            if (var3_6.hasAction("email")) {
                                var12_59 = Resource.getString("EVENT_ID", "Event ID:");
                                this.m_localizedStr = this.m_localizedStr + '\n' + var12_59 + this.getEventCode();
                                this.alertActionEmail(this.m_localizedStr, var6_26);
                            }
                            if (var3_6.hasAction("systemlog")) {
                                this.alertActionSysLog(this.m_localizedStr, var6_26);
                            }
                            if (var3_6.hasAction("popup")) {
                                this.alertActionPopup(this.m_xmlString);
                            }
                        }
                    }
                    catch (Exception var11_54) {
                        System.out.println("Don't have a alert Action");
                    }
                    break;
                }
                case 2: {
                    var3_7 = this.m_pluginDataInfo.getBuffer();
                    var4_18 = new String(var3_7);
                    var5_24 = new ParseXMLString();
                    var6_27 = var5_24.getAction(var4_18);
                    System.out.println(var6_27);
                    if (var6_27.equalsIgnoreCase("config-request")) {
                        try {
                            var7_30 = new FileInputStream(MonitorService.m_qualified_config_file_name);
                            var8_38 = new DataInputStream(var7_30);
                            var9_44 = new BufferedReader(new InputStreamReader(var8_38));
                            var10_48 = "";
                            while ((var11_55 = var9_44.readLine()) != null) {
                                var10_48 = var10_48 + var11_55;
                            }
                            var8_38.close();
                            this.m_pluginDataInfo.setBuffer(var10_48.getBytes());
                        }
                        catch (Exception var7_31) {
                            var8_39 = "<monitorcontrol><error/></monitorcontrol>";
                            this.m_pluginDataInfo.setBuffer(var8_39.getBytes());
                            System.err.println("File read Error: " + var7_31.getMessage());
                        }
                        break;
                    }
                    if (var6_27.equalsIgnoreCase("monitor-config")) {
                        var7_32 = var5_24.getNode(var4_18);
                        var8_40 = new XMLParser();
                        if (var7_32 == null) break;
                        var8_40.treatConfig(var7_32);
                        var9_45 = var8_40.getConfig();
                        var10_49 = var9_45.getAction("email");
                        var11_56 = new ArrayList<String>();
                        var12_60 = null;
                        if (var10_49 != null) {
                            try {
                                var13_62 = false;
                                var14_72 = null;
                                var14_72 = InetAddress.getByName((String)var10_49.getParam("nic").get(0));
                                var15_74 = InetAddress.getByName((String)var10_49.getParam("servername").get(0));
                                var16_76 = NetworkInterface.getByInetAddress((InetAddress)var14_72);
                                if (var16_76 != null && !var16_76.isLoopback()) {
                                    var13_62 = this.isSMTPReachable(var15_74, (InetAddress)var14_72);
                                }
                                System.out.println("CURRENT IP IS::" + var14_72.getHostAddress() + " SMTP IP IS::" + var15_74.getHostAddress() + " \n LOCAL IP IS::" + var10_49.getParam("nic").get(0));
                                if (!var13_62 && (var12_60 = this.isSmtpInSameSubnet((String)var10_49.getParam("servername").get(0))) != null) {
                                    var11_56.add(var12_60);
                                    var10_49.setParam("nic", var11_56);
                                }
                            }
                            catch (UnknownHostException var13_63) {
                                var13_63.printStackTrace();
                            }
                            catch (SocketException var13_64) {
                                var13_64.printStackTrace();
                            }
                            catch (IOException var13_65) {
                                var13_65.printStackTrace();
                            }
                        }
                        this.m_alertConfig = var9_45;
                        this.sendVivaldiCfgtoSLClients();
                        var13_66 = new AlertConfigWriter(MonitorService.m_qualified_config_file_name);
                        var13_66.write(this.m_alertConfig);
                        this.updateEmailCfg();
                        var14_72 = "<monitorcontrol><done/></monitorcontrol>";
                        this.m_pluginDataInfo.setBuffer(var14_72.getBytes());
                        break;
                    }
                    if (var6_27.equalsIgnoreCase("test-mail")) {
                        var7_33 = var5_24.getChildNode(var4_18);
                        var8_41 = new XMLParser();
                        if (var7_33 == null) break;
                        var8_41.treatConfig(var7_33);
                        var9_46 = var8_41.getConfig();
                        var10_50 = var9_46.getAction("email");
                        var11_57 = new ArrayList<String>();
                        var12_61 = null;
                        if (var10_50 != null) {
                            try {
                                var13_67 = false;
                                var14_73 = null;
                                var10_50.setParam("nic", this.m_alertConfig.getAction("email").getParam("nic"));
                                var14_73 = InetAddress.getByName((String)var10_50.getParam("nic").get(0));
                                var15_75 = Inet4Address.getByName((String)var10_50.getParam("servername").get(0));
                                var16_77 = NetworkInterface.getByInetAddress((InetAddress)var14_73);
                                if (var16_77 != null && !var16_77.isLoopback()) {
                                    var13_67 = this.isSMTPReachable((InetAddress)var15_75, (InetAddress)var14_73);
                                }
                                System.out.println("CURRENT IP IS::" + var14_73.getHostAddress() + " SMTP IP IS::" + var15_75.getHostAddress() + " \n LOCAL IP IS::" + var10_50.getParam("nic").get(0));
                                if (!var13_67) {
                                    var12_61 = this.isSmtpInSameSubnet((String)var10_50.getParam("servername").get(0));
                                    if (var12_61 == null) {
                                        return false;
                                    }
                                    var11_57.add(var12_61);
                                    var10_50.setParam("nic", var11_57);
                                    if (var12_61 != null) {
                                        var11_57.add(var12_61);
                                        var10_50.setParam("nic", var11_57);
                                    }
                                }
                            }
                            catch (UnknownHostException var13_68) {
                                var13_68.printStackTrace();
                            }
                            catch (SocketException var13_69) {
                                var13_69.printStackTrace();
                            }
                            catch (IOException var13_70) {
                                var13_70.printStackTrace();
                            }
                        }
                        this.m_alertConfig = var9_46;
                        this.sendVivaldiCfgtoSLClients();
                        var13_71 = new AlertConfigWriter(MonitorService.m_qualified_config_file_name);
                        var13_71.write(this.m_alertConfig);
                        this.updateEmailCfg();
                        var14_73 = new AlertActionEmail();
                        var14_73.setServerName((String)MonitorService.m_serverName.get(0));
                        var14_73.setSenderName((String)MonitorService.m_sender.get(0));
                        var14_73.setSenderNICAddress((String)MonitorService.m_senderNICAddress.get(0));
                        var14_73.setSMTPPortNum((String)MonitorService.m_smtpPortNum.get(0));
                        var14_73.setTargetName(MonitorService.m_target);
                        var14_73.setUserName(MonitorService.m_userName.get(0).toString().trim().getBytes());
                        var14_73.setPassword(MonitorService.m_password.get(0).toString().trim().getBytes());
                        var14_73.setAuthentication((String)MonitorService.m_autentication.get(0));
                        var14_73.setMailSubject(this.getMailSubject(0));
                        var15_75 = new StringBuffer();
                        var15_75.append(Resource.getString("test e-mail", "Testing the Email Configuration."));
                        var15_75.append("\n");
                        var15_75.append(Resource.getString("generate", "Generated On: "));
                        var16_77 = new Date();
                        var15_75.append(var16_77.toString());
                        var14_73.setMailBody(new String((StringBuffer)var15_75));
                        var17_78 = "";
                        var18_79 = var14_73.sendTestMail();
                        if (var18_79) {
                            System.out.println("Mail delivered successfully");
                            var17_78 = "<monitorcontrol><done/></monitorcontrol>";
                        } else {
                            System.out.println("Exception @ sending test email");
                            var17_78 = "<monitorcontrol><error/></monitorcontrol>";
                        }
                        this.m_pluginDataInfo.setBuffer(var17_78.getBytes());
                        break;
                    }
                    if (var6_27.equalsIgnoreCase("stop")) {
                        var7_34 = "<monitorcontrol><done/></monitorcontrol>";
                        this.m_pluginDataInfo.setBuffer(var7_34.getBytes());
                        break;
                    }
                    System.out.println("no cfg related operation");
                    var7_35 = "<monitorcontrol><error/></monitorcontrol>";
                    this.m_pluginDataInfo.setBuffer(var7_35.getBytes());
                    break;
                }
                default: {
                    System.out.println("Default Command frm Monitor");
                    System.out.println("Req Type-> " + var2_2);
                }
            }
        }
        catch (Exception var2_3) {
            System.out.println("Exception while handling eveny in Monitor Plugin");
            var2_3.printStackTrace();
        }
        return true;
    }

    public String isSmtpInSameSubnet(String string) {
        InetAddress inetAddress = null;
        boolean bl = false;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        ArrayList arrayList = new ArrayList();
        Enumeration<NetworkInterface> enumeration = null;
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        Object var6_8 = null;
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            InetAddress inetAddress2 = null;
            if (!enumeration2.hasMoreElements()) continue;
            inetAddress2 = enumeration2.nextElement();
            try {
                if (networkInterface.isLoopback()) continue;
                System.out.println("IP OF LOCAL HOST IS::" + inetAddress2.getHostAddress());
                bl = this.isSMTPReachable(inetAddress, inetAddress2);
                if (!bl) continue;
                System.out.println("IP::" + inetAddress2.getHostAddress() + " IS IN SAME SUBNET of SMTP");
                return inetAddress2.getHostAddress();
            }
            catch (SocketException socketException) {
                socketException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public boolean isSMTPReachable(InetAddress inetAddress, InetAddress inetAddress2) {
        boolean bl = false;
        System.out.println("MonitorService.isSMTPReachable()");
        try {
            Socket socket = new Socket(inetAddress, 25, inetAddress2, this.getAFreePort());
            socket.close();
            bl = true;
        }
        catch (IOException iOException) {
            System.out.println("MonitorService.isSMTPReachable() @ Exception");
            bl = false;
        }
        return bl;
    }

    public int getAFreePort() {
        int n;
        System.out.println("MonitorService.getAFreePort()");
        int n2 = 49257;
        int n3 = 800;
        int n4 = n2;
        for (n = 0; n <= n3; ++n) {
            try {
                ServerSocket serverSocket = null;
                serverSocket = new ServerSocket(++n4);
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                    if (!enumeration2.hasMoreElements()) continue;
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress instanceof Inet4Address) {
                        serverSocket.close();
                        serverSocket = null;
                        serverSocket = new ServerSocket(n4, 0, inetAddress);
                    }
                    serverSocket.close();
                    System.out.println("MonitorService.getAFreePort() port = " + n4);
                    return n4;
                }
                serverSocket.close();
                break;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        if (n > n3) {
            n4 = 0;
        }
        return n4;
    }

    public boolean storeLatestSequenceNumber() {
        MR_EVT_LOG_INFO mR_EVT_LOG_INFO = null;
        NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(7, 0, this.getCtrlID(), 20).getByteArray());
        try {
            int n = 6;
            byte[] byArray = new byte[60];
            NetworkToJavaConverter.intToByteArray(n, byArray, 0);
            System.arraycopy(NetworkPacket.convertWWNStringToByteArray(PluginsWWN.getMonitorWWN()), 0, byArray, 4, 24);
            System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.getReceiverWWN(this.getCtrlID())), 0, byArray, 28, 24);
            NetworkToJavaConverter.intToByteArray(networkDataPacket.getDataBuffer().length, byArray, 56);
            byte[] byArray2 = networkDataPacket.getDataBuffer();
            PluginDataInfo pluginDataInfo = null;
            pluginDataInfo = new PluginDataInfo(PluginsWWN.getMonitorWWN(), this.getReceiverWWN(this.getCtrlID()), byArray2);
            boolean bl = objFramework.ProcessCommand(4098, pluginDataInfo);
            if (bl) {
                byte[] byArray3 = networkDataPacket.getDataBuffer();
                int n2 = NetworkToJavaConverter.byteArrayToInt(byArray3);
                if (n2 != 0) {
                    System.out.println("Failed to get Sequence Info, Status=" + Integer.toHexString(n2));
                    return true;
                }
                mR_EVT_LOG_INFO = new MR_EVT_LOG_INFO(byArray3, 44);
                if (this.m_OldSequenceNum == 0) {
                    this.m_OldSequenceNum = mR_EVT_LOG_INFO.getnewestSeqNum();
                    return true;
                }
                if (this.m_OldSequenceNum != mR_EVT_LOG_INFO.getnewestSeqNum()) {
                    this.m_OldSequenceNum = mR_EVT_LOG_INFO.getnewestSeqNum();
                    return true;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("getting Sequence Info Exception)");
            exception.printStackTrace();
            mR_EVT_LOG_INFO = null;
            return false;
        }
        return false;
    }

    private void alertActionEmail(String string, int n) {
        Object object;
        Object object2;
        System.out.println("Do Email");
        AlertActionEmail alertActionEmail = new AlertActionEmail();
        alertActionEmail.setServerName((String)m_serverName.get(0));
        alertActionEmail.setSenderName((String)m_sender.get(0));
        alertActionEmail.setSenderNICAddress((String)m_senderNICAddress.get(0));
        alertActionEmail.setSMTPPortNum((String)m_smtpPortNum.get(0));
        alertActionEmail.setTargetName(m_target);
        alertActionEmail.setUserName(m_userName.get(0).toString().trim().getBytes());
        alertActionEmail.setPassword(m_password.get(0).toString().trim().getBytes());
        alertActionEmail.setAuthentication((String)m_autentication.get(0));
        alertActionEmail.setMailSubject(this.getMailSubject(n));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("\n");
        stringBuffer.append(Resource.getString("generate", "Generated On: "));
        if (m_slObject.getevtDetail().gettimeStamp() != 0) {
            object2 = KernelConstants.getTimeStamp(m_slObject.getevtDetail().gettimeStamp());
            String string2 = this.gettimeStamp((MR_TIME_STAMP)object2);
            try {
                object = new SimpleDateFormat(Resource.getString("EMAIL_DATE_FORMAT", "yyyy.MM.dd HH:mm:ss"));
                Date date = ((DateFormat)object).parse(string2);
                stringBuffer.append(date.toString());
            }
            catch (Exception exception) {
                System.out.println("Exception :" + exception);
            }
        } else {
            stringBuffer.append(Resource.getString("TEXT_NOT_AVAILABLE", "Not available"));
        }
        stringBuffer.append("\n\n");
        object2 = m_ctrlInfo[this.m_sasAdpList.getControllerIndex(m_slObject.getctrlId())].getEmailContent();
        if (object2 != null) {
            int n2;
            for (n2 = 0; n2 < ((EmailContent)object2).getDriverDetails().size(); ++n2) {
                object = (String)((EmailContent)object2).getDriverDetails().get(n2);
                stringBuffer.append((String)object);
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
            for (n2 = 0; n2 < ((EmailContent)object2).getImageDetails().size(); ++n2) {
                object = (String)((EmailContent)object2).getImageDetails().get(n2);
                stringBuffer.append((String)object);
                stringBuffer.append("\n");
            }
            alertActionEmail.setMailBody(new String(stringBuffer));
            alertActionEmail.sendTestMail();
        }
    }

    public String gettimeStamp(MR_TIME_STAMP mR_TIME_STAMP) {
        String string = mR_TIME_STAMP.getyear() + "." + (mR_TIME_STAMP.getmonth() + 1) + "." + mR_TIME_STAMP.getday() + " " + mR_TIME_STAMP.gethour() + ":" + mR_TIME_STAMP.getmin() + ":" + mR_TIME_STAMP.getsec();
        System.out.println(string);
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(mR_TIME_STAMP.getyear() + ".");
        if (mR_TIME_STAMP.getmonth() + 1 <= 9) {
            stringBuffer.append("0" + (mR_TIME_STAMP.getmonth() + 1) + ".");
        } else {
            stringBuffer.append(mR_TIME_STAMP.getmonth() + 1 + ".");
        }
        if (mR_TIME_STAMP.getday() <= 9) {
            stringBuffer.append("0" + mR_TIME_STAMP.getday() + " ");
        } else {
            stringBuffer.append(mR_TIME_STAMP.getday() + " ");
        }
        if (mR_TIME_STAMP.gethour() == 0) {
            stringBuffer.append("00:");
        } else if (mR_TIME_STAMP.gethour() <= 9) {
            stringBuffer.append("0" + mR_TIME_STAMP.gethour() + ":");
        } else {
            stringBuffer.append(mR_TIME_STAMP.gethour() + ":");
        }
        if (mR_TIME_STAMP.getmin() <= 9) {
            stringBuffer.append("0" + mR_TIME_STAMP.getmin() + ":");
        } else {
            stringBuffer.append(mR_TIME_STAMP.getmin() + ":");
        }
        if (mR_TIME_STAMP.getsec() <= 9) {
            stringBuffer.append("0" + mR_TIME_STAMP.getsec());
        } else {
            stringBuffer.append(mR_TIME_STAMP.getsec());
        }
        String string2 = stringBuffer.toString();
        System.out.println("time==" + string2);
        return string2;
    }

    private void updateEmailCfg() {
        AlertAction alertAction = this.m_alertConfig.getAction("email");
        if (alertAction == null) {
            System.out.println("email Action is null");
        } else {
            m_serverName = alertAction.getParam("servername");
            m_target = alertAction.getParam("email-target");
            m_sender = alertAction.getParam("sender");
            m_senderNICAddress = alertAction.getParam("nic");
            m_smtpPortNum = alertAction.getParam("port");
            System.out.println("CUSTOM PORT NUM IS==" + m_smtpPortNum);
            System.out.println("act.getParam==" + alertAction.getParam("nic"));
            m_userName = alertAction.getParam("username");
            m_password = alertAction.getParam("password");
            m_autentication = alertAction.getParam("authentication-type");
        }
        for (int i = 0; i < m_target.size(); ++i) {
            System.out.println("target [" + i + "] = " + (String)m_target.get(i));
        }
    }

    private void alertActionMSMLog(String string) {
        byte[] byArray = string.getBytes();
        System.out.println("do msm log");
        PluginDataInfo pluginDataInfo = new PluginDataInfo();
        pluginDataInfo.setBuffer(byArray);
        pluginDataInfo.setCmd(1);
        try {
            pluginDataInfo.setReceiverWWN(PluginsWWN.getLoggerWWN());
            pluginDataInfo.setSenderWWN(PluginsWWN.getMonitorWWN());
            objFramework.ProcessCommand(1, pluginDataInfo);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            System.out.println("Error - assigning Logger WWN as receiver in Monitorplugin");
        }
    }

    private void alertActionPopup(String string) {
        byte[] byArray = string.getBytes();
        System.out.println("Do Pop Up");
        PluginDataInfo pluginDataInfo = new PluginDataInfo();
        pluginDataInfo.setBuffer(byArray);
        boolean bl = false;
        pluginDataInfo.setCmd(2);
        try {
            PrintWriter printWriter;
            if (m_isPopupStarted) {
                pluginDataInfo.setReceiverWWN(this.getPopupWWN());
                pluginDataInfo.setSenderWWN(PluginsWWN.getMonitorWWN());
                bl = objFramework.ProcessCommand(2, pluginDataInfo);
            } else {
                try {
                    bl = true;
                    printWriter = new PrintWriter(new BufferedWriter(new FileWriter(m_qualified_popup_log_file_name, true)));
                    printWriter.println(string);
                    printWriter.close();
                    System.out.println("Event writted in m_qualified_popup_log_file_name file");
                }
                catch (IOException iOException) {
                    System.out.println("IOException in Monitor Service -> DOPopUp write a event in a file");
                }
            }
            if (!bl) {
                m_isPopupStarted = false;
                System.out.println("MonitorService.alertActionPopup() failure in sending event to popup");
                try {
                    printWriter = new PrintWriter(new BufferedWriter(new FileWriter(m_qualified_popup_log_file_name, true)));
                    printWriter.println(string);
                    printWriter.close();
                }
                catch (IOException iOException) {
                    System.out.println("IOException in Monitor Service -> DOPopUp write a event in a file");
                }
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            m_isPopupStarted = false;
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(m_qualified_popup_log_file_name, true)));
                printWriter.println(string);
                printWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("IOException in Monitor Service -> DOPopUp write a event in a file");
            }
        }
    }

    private void alertActionSysLog(String string, int n) {
        System.out.println("System Log Start");
        StorelibPlugin.doSystemLog(this.m_pluginDataInfo, string, n);
        System.out.println("System Log End");
    }

    @Override
    public void shutdown() {
        try {
            if (this.m_timeSyncObj != null) {
                if (this.m_timeSyncObj.isAlive()) {
                    this.m_timeSyncObj.stop();
                }
                this.m_timeSyncObj = null;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception while shutdown the Monitor Plugin");
            exception.printStackTrace();
        }
        System.out.println("Monitor plugin shutdown");
    }

    public static byte[] getClientList() {
        int n;
        Object[] objectArray = ClientManager.getClientList();
        byte[] byArray = null;
        if (objectArray.length != 0) {
            byArray = ((ClientInfo)objectArray[0]).getBytes();
            n = byArray.length;
        } else {
            n = 0;
        }
        byte[] byArray2 = new byte[objectArray.length * n + 4];
        int n2 = 0;
        NetworkToJavaConverter.intToByteArray(objectArray.length, byArray2);
        if (objectArray.length == 0) {
            return byArray2;
        }
        System.arraycopy(byArray, 0, byArray2, n2 += 4, n);
        n2 += n;
        for (int i = 1; i < objectArray.length; ++i) {
            System.arraycopy(((ClientInfo)objectArray[i]).getBytes(), 0, byArray2, n2, n);
            n2 += n;
        }
        return byArray2;
    }

    private String getPopupWWN() throws VKOperationFailedException {
        byte[] byArray = MonitorService.getClientList();
        ClientInfo[] clientInfoArray = new ClientInfo[NetworkToJavaConverter.byteArrayToInt(byArray)];
        for (int i = 0; i < clientInfoArray.length; ++i) {
            clientInfoArray[i] = new ClientInfo(byArray, 4 + i * 512);
            System.out.println("Client Minor number: " + clientInfoArray[i].getMinorNumber());
        }
        for (ClientInfo clientInfo : clientInfoArray) {
            if (clientInfo.getMajorNumber() != 0 || clientInfo.getMinorNumber() != 10) continue;
            return clientInfo.getWWN();
        }
        System.out.println("Error - assigning Popup WWN as receiver in Monitorplugin");
        throw new VKOperationFailedException(4096);
    }

    public int getCtrlID() {
        return m_slObject.getctrlId();
    }

    public short getSeqNum() {
        return (short)m_slObject.getevtDetail().getseqNum();
    }

    public int getEventCode() {
        return m_slObject.getevtDetail().getcode();
    }

    public int getEventClass() {
        return m_slObject.getevtDetail().getcl().geteventClass();
    }

    public int getargType() {
        return m_slObject.getevtDetail().getargType();
    }

    public String getEventinLocFormat(String string) {
        LogXMLParser logXMLParser = new LogXMLParser(string);
        byte[] byArray = Locale.getDefault().getLanguage().getBytes();
        byte[] byArray2 = new byte[2];
        byte[] byArray3 = Locale.getDefault().getCountry().getBytes();
        System.arraycopy(byArray3, 0, byArray2, 0, Math.min(byArray2.length, byArray3.length));
        String string2 = new String(byArray);
        String string3 = new String(byArray2);
        Localization localization = new Localization(string2, string3);
        logXMLParser.setTagValue("languageCode", localization.getLanguage());
        String string4 = localization.getLocalizedStringWithoutUnicodeConversion(logXMLParser.getTagValue("id").trim(), logXMLParser.getParams());
        logXMLParser.setTagValue("localizedMessage", string4);
        return string4;
    }

    public void updateControllerInfo() {
        MR_CTRL_INFO mR_CTRL_INFO = null;
        MR_ENCL_LIST mR_ENCL_LIST = null;
        MR_SAS_CONNECTORS mR_SAS_CONNECTORS = null;
        MR_PD_LIST mR_PD_LIST = null;
        EmailContent emailContent = null;
        String string = null;
        SASAdapterList sASAdapterList = new SASAdapterList();
        ArrayList arrayList = new ArrayList();
        arrayList = sASAdapterList.getAdapterIDDetailList();
        m_ctrlInfo = new AdapterInfo[arrayList.size() + 1];
        this.m_enclList = new EnclosureList[arrayList.size() + 1];
        this.m_pdList = new PhysicalDeviceList[arrayList.size() + 1];
        this.m_sasConnectors = new ConnectorList[arrayList.size() + 1];
        for (int i = 0; i < arrayList.size(); ++i) {
            AdapterDetails adapterDetails = (AdapterDetails)arrayList.get(i);
            Integer n = adapterDetails.getControllerID();
            string = this.getReceiverWWN(n);
            try {
                MonitorService.m_ctrlInfo[i] = new AdapterInfo(n, PluginsWWN.getMonitorWWN(), string, objFramework, null, false);
                mR_CTRL_INFO = m_ctrlInfo[i].getMR_CTRL_INFO();
                this.m_pdList[i] = new PhysicalDeviceList(n, PluginsWWN.getMonitorWWN(), string, objFramework, null, false);
                mR_PD_LIST = this.m_pdList[i].getMR_PD_LIST();
                m_ctrlInfo[i].setPDList(mR_PD_LIST);
                this.m_pdList[i].setControllerID(i);
                emailContent = new EmailContent(n, PluginsWWN.getMonitorWWN(), string, objFramework, null, false, mR_CTRL_INFO);
                m_ctrlInfo[i].setEmailContent(emailContent);
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                System.out.println("Exception in MonitorService while assi ctrlInfo and PDList");
                vKOperationFailedException.printStackTrace();
            }
            if (mR_CTRL_INFO.getadapterOperations_MR_CTRL_INFO().getsupportEnclEnumeration() == 1) {
                try {
                    this.m_enclList[i] = new EnclosureList(n, PluginsWWN.getMonitorWWN(), string, objFramework, null, false);
                    mR_ENCL_LIST = this.m_enclList[i].getMR_ENCL_LIST();
                    m_ctrlInfo[i].setEnclList(mR_ENCL_LIST);
                    this.m_enclList[i].setControllerID(i);
                    this.m_sasConnectors[i] = new ConnectorList(n, PluginsWWN.getMonitorWWN(), string, objFramework, null, false);
                    mR_SAS_CONNECTORS = this.m_sasConnectors[i].getMR_SAS_CONNECTORS();
                    m_ctrlInfo[i].setConnectors(mR_SAS_CONNECTORS);
                    this.m_sasConnectors[i].setControllerID(i);
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    System.out.println("Exception in MonitorService while assi connectors and EnclList");
                    vKOperationFailedException.printStackTrace();
                }
                continue;
            }
            this.m_enclList[i] = null;
            this.m_sasConnectors[i] = null;
        }
    }

    private synchronized boolean getLogFileAsString(PluginDataInfo pluginDataInfo) {
        byte[] byArray;
        byte[] byArray2 = pluginDataInfo.getBuffer();
        int n = NetworkToJavaConverter.byteArrayToInt(byArray2, 4);
        int n2 = NetworkToJavaConverter.byteArrayToInt(byArray2, 8);
        byte[] byArray3 = new byte[2];
        System.arraycopy(byArray2, 12, byArray3, 0, 2);
        String string = new String(byArray3);
        String string2 = new String(byArray2, 14, 2);
        Localization localization = new Localization(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        int n3 = 0;
        try {
            int n4;
            bufferedReader = new BufferedReader(new FileReader(m_qualified_log_file_name));
            byArray = null;
            for (n4 = 0; n4 <= this.m_lineCountInLogFile - n - n2; ++n4) {
                bufferedReader.readLine();
            }
            while (n4 <= this.m_lineCountInLogFile - n) {
                block16: {
                    try {
                        LogXMLParser logXMLParser = new LogXMLParser(bufferedReader.readLine());
                        logXMLParser.setTagValue("languageCode", localization.getLanguage());
                        try {
                            logXMLParser.setTagValue("localizedMessage", localization.getLocalizedString(logXMLParser.getTagValue("id").trim(), logXMLParser.getParams()));
                        }
                        catch (NullPointerException nullPointerException) {
                            break block16;
                        }
                        String string3 = logXMLParser.getXML();
                        String string4 = "";
                        for (int i = 0; i < string3.length(); ++i) {
                            if (string3.substring(i).startsWith("amp;")) {
                                i += 3;
                                continue;
                            }
                            string4 = string4 + string3.charAt(i);
                        }
                        arrayList.add(0, string4);
                        ++n3;
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byArray = null;
        int n5 = 12;
        if (n3 != 0) {
            int n6;
            n5 += arrayList.size() * 4;
            for (n6 = 0; n6 < arrayList.size(); ++n6) {
                n5 += ((String)arrayList.get(n6)).length();
            }
            byArray = new byte[n5];
            n6 = 0;
            NetworkToJavaConverter.intToByteArray(0, byArray, n6);
            NetworkToJavaConverter.intToByteArray(n5, byArray, n6 += 4);
            NetworkToJavaConverter.intToByteArray(arrayList.size() >= n2 ? n2 : arrayList.size(), byArray, n6 += 4);
            n6 += 4;
            for (int i = 0; i < arrayList.size() && i < n2; ++i) {
                String string5 = (String)arrayList.get(i);
                NetworkToJavaConverter.intToByteArray(string5.length(), byArray, n6);
                System.arraycopy(string5.getBytes(), 0, byArray, n6 += 4, string5.length());
                n6 += string5.length();
            }
        } else {
            byArray = new byte[n5];
            int n7 = 0;
            NetworkToJavaConverter.intToByteArray(0, byArray, n7);
            NetworkToJavaConverter.intToByteArray(n5, byArray, n7 += 4);
            NetworkToJavaConverter.intToByteArray(0, byArray, n7 += 4);
        }
        pluginDataInfo.setBuffer(byArray);
        return true;
    }

    private synchronized boolean clearLog() {
        File file = new File(m_qualified_log_file_name);
        try {
            if (file.exists()) {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write("");
                fileWriter.close();
                this.m_lineCountInLogFile = 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean doPopupIntialLog() {
        PluginDataInfo pluginDataInfo = new PluginDataInfo();
        pluginDataInfo.setCmd(2);
        try {
            pluginDataInfo.setReceiverWWN(this.getPopupWWN());
            pluginDataInfo.setSenderWWN(PluginsWWN.getMonitorWWN());
        }
        catch (Exception exception) {
            System.out.println("Error at sending initial popup log to popup - assigning wwn");
        }
        BufferedReader bufferedReader = null;
        byte[] byArray = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(m_qualified_popup_log_file_name));
            String string2 = "seqNum";
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(string2);
                if (n == -1) continue;
                byArray = string.getBytes();
                pluginDataInfo.setBuffer(byArray);
                bl = objFramework.ProcessCommand(2, pluginDataInfo);
                if (bl) continue;
            }
            return bl;
        }
        catch (Exception exception) {
            System.out.println("Error at sending initial popup log to popup");
            exception.printStackTrace();
            return false;
        }
    }

    private String getReceiverWWN(int n) {
        String string = null;
        SASAdapterList sASAdapterList = new SASAdapterList();
        int n2 = sASAdapterList.getControllerType(n);
        try {
            switch (n2) {
                case 1: {
                    string = PluginsWWN.getStorelibWWN();
                    break;
                }
                case 2: {
                    string = PluginsWWN.getStorelibIRWWN();
                    break;
                }
                case 3: {
                    string = PluginsWWN.getStorelibIRWWN();
                    break;
                }
                case 4: {
                    string = PluginsWWN.getStorelibIRWWN();
                    break;
                }
                default: {
                    System.out.println("Invalid ctrl type");
                    break;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception at assigning receiver WWN");
        }
        return string;
    }

    @Override
    public void preShutdown() {
        System.out.println("MonitorService.preShutdown()Inside");
        try {
            if (this.m_regAENObj != null) {
                this.m_regAENObj.unRegisterAEN();
                if (this.m_regAENObj.isAlive()) {
                    this.m_regAENObj.stop();
                }
                this.m_regAENObj = null;
            }
            this.unRegisterWithFramework();
        }
        catch (Exception exception) {
            System.out.println("Exception @ preshutdown in MonitorService");
        }
    }

    private String getMailSubject(int n) {
        String string = this.getSeverityString(n);
        String string2 = Resource.getString("desc", "Event occured on: ");
        String string3 = "";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string3 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            System.out.println("MonitorService.getMailSubject() exception while getting hostname");
        }
        return string + " | " + string2 + string3;
    }

    public String getSeverityString(int n) {
        String string = Resource.getString("INFO", "Information");
        if (n == 0) {
            string = Resource.getString("INFO", "Information");
        } else if (n == 1) {
            string = Resource.getString("WARN", "Warning");
        } else if (n == 2) {
            string = Resource.getString("CRTL", "Critical");
        } else if (n == 3) {
            string = Resource.getString("FATAL", "Fatal");
        } else if (n == 4) {
            string = Resource.getString("TITLE_DRIVES_SPIN_UP_PROGRESS", "Progress");
        }
        return string;
    }

    private byte[] getVivaldiConfig() {
        Object object;
        int n;
        int n2;
        int n3;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        Enumeration enumeration = this.m_alertConfig.getAlertEvents();
        while (enumeration.hasMoreElements()) {
            int n4 = (Integer)enumeration.nextElement();
            arrayList2.add(n4);
        }
        System.out.println("MonitorService.processCommand()events count = " + arrayList2.size());
        String string = "";
        int n5 = 0;
        for (int i = 0; i < arrayList2.size(); ++i) {
            try {
                n3 = Integer.parseInt(arrayList2.get(i).toString());
                AlertEventDetails alertEventDetails = this.m_alertConfig.getAlertEvent(Integer.parseInt(arrayList2.get(i).toString()));
                n2 = alertEventDetails.getSeverity();
                n = 0;
                if (alertEventDetails.usesGlobal()) {
                    object = this.m_alertConfig.getGlobal(n2);
                    if (object != null && ((AlertsGlobalConfig)object).hasAction("vivaldilog")) {
                        n = 1;
                    }
                } else {
                    int n6 = alertEventDetails.getActionsCount();
                    if (alertEventDetails.hasAction("vivaldilog")) {
                        n = 1;
                    }
                }
                string = n3 + "=" + n + ";" + n2;
                arrayList.add(string);
                ++n5;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (arrayList.size() == arrayList2.size()) {
            System.out.println("MonitorService.processCommand()- VivaldiCfg ArrayList filled properly");
        } else {
            System.out.println("MonitorService.processCommand()- VivaldiCfg ArrayList not filled properly");
        }
        System.out.println("MonitorService.processCommand() vivaldiConfig.size() " + arrayList.size());
        byte[] byArray = null;
        if (n5 != 0) {
            n3 = 12;
            n3 += arrayList.size() * 4;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                n3 += ((String)arrayList.get(n2)).length();
            }
            byArray = new byte[n3];
            n2 = 0;
            NetworkToJavaConverter.intToByteArray(0, byArray, n2);
            NetworkToJavaConverter.intToByteArray(n3, byArray, n2 += 4);
            NetworkToJavaConverter.intToByteArray(arrayList.size(), byArray, n2 += 4);
            n2 += 4;
            for (n = 0; n < arrayList.size(); ++n) {
                object = (String)arrayList.get(n);
                NetworkToJavaConverter.intToByteArray(((String)object).length(), byArray, n2);
                System.arraycopy(((String)object).getBytes(), 0, byArray, n2 += 4, ((String)object).length());
                n2 += ((String)object).length();
            }
        } else {
            n3 = 0;
            n2 = 12;
            byArray = new byte[n2];
            NetworkToJavaConverter.intToByteArray(0, byArray, n3);
            NetworkToJavaConverter.intToByteArray(n2, byArray, n3 += 4);
            NetworkToJavaConverter.intToByteArray(0, byArray, n3 += 4);
        }
        return byArray;
    }

    private void sendVivaldiCfgtoSLClients() {
        PluginDataInfo pluginDataInfo = new PluginDataInfo();
        byte[] byArray = this.getVivaldiConfig();
        pluginDataInfo.setBuffer(byArray);
        pluginDataInfo.setSenderWWN(pluginInfo.getWWN());
        Object[] objectArray = StorelibPlugin.getClientList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (pluginInfo.getWWN().equalsIgnoreCase((String)objectArray[i])) continue;
            System.out.println("MonitorService.processCommand()recever of cfg = " + (String)objectArray[i]);
            pluginDataInfo.setReceiverWWN((String)objectArray[i]);
            objFramework.ProcessCommand(4101, pluginDataInfo);
        }
    }

    static {
        m_smtpPortNum = null;
        m_serverName = null;
        m_target = null;
        m_sender = null;
        m_senderNICAddress = null;
        m_userName = null;
        m_password = null;
        m_autentication = null;
        m_isPopupStarted = false;
    }
}

