/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.FrameworkInterface;
import Framework.Network.NetworkManager;
import Framework.PluginManagers.PluginDataInfo;
import Framework.PluginManagers.PluginInfo;
import Framework.PluginManagers.PluginInterface;
import Services.CommonConstants;
import Services.FrameworkUtilities;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import Services.PropertiesFileHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.HashMap;
import plugins.Receiver;
import plugins.Sender;
import plugins.TCPConfirmer;

public class NetworkCapabilityPlugin
implements PluginInterface,
Runnable,
CommonConstants {
    private static final int majorGroup = 0;
    private static final int minorGroup = 2;
    private static final String version = "1.10";
    private static final String description = "NetworkCapability Plugin version: 1.10";
    private PluginInfo pluginInfo = new PluginInfo();
    private FrameworkInterface framework = null;
    private Receiver receiver_old = new Receiver(MULTICAST_PORT);
    private Receiver receiver_new = new Receiver(MULTICAST_PORT_3071);
    private Sender sender = new Sender();
    private Thread purgeThread = null;
    protected static volatile boolean continueRun = true;
    private static String MULTICAST_SOCKET = "229.111.112.12";
    protected static InetAddress inetAddr = null;
    protected static int MULTICAST_PORT = 5571;
    protected static int MULTICAST_PORT_3071 = 3071;
    protected static int HEART_BEAT_INTERVAL = 5000;
    private static int TIMEOUT_DELTA = 2000;
    protected static String message = new String("Network Capability");
    protected static HashMap ipHash = new HashMap();
    public static int TIMETOLIVE = 1;
    private static String TIMETOLIVESTR = "TIMETOLIVE";

    @Override
    public boolean init(String string, FrameworkInterface frameworkInterface) {
        String string2 = FrameworkUtilities.getLocalHostAddress();
        if (string2 == null || string2.equals("127.0.0.1")) {
            return false;
        }
        try {
            inetAddr = InetAddress.getByName(MULTICAST_SOCKET);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        this.pluginInfo.setMajorGroup(0);
        this.pluginInfo.setMinorGroup(2);
        this.pluginInfo.setVersion(version);
        this.pluginInfo.setWWN(string);
        this.pluginInfo.setDescription(description);
        continueRun = true;
        this.framework = frameworkInterface;
        TCPConfirmer tCPConfirmer = new TCPConfirmer();
        tCPConfirmer.start();
        while (tCPConfirmer.getServerSocketPort() == 0) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.receiver_old = new Receiver(MULTICAST_PORT);
        if (!this.receiver_old.init()) {
            return false;
        }
        this.receiver_new = new Receiver(MULTICAST_PORT_3071);
        if (!this.receiver_new.init()) {
            return false;
        }
        this.sender = new Sender();
        if (!this.sender.init()) {
            return false;
        }
        this.receiver_old.start();
        this.receiver_new.start();
        this.sender.start();
        this.purgeThread = new Thread(this);
        this.purgeThread.start();
        PropertiesFileHandler propertiesFileHandler = new PropertiesFileHandler("framework.properties");
        if (propertiesFileHandler != null) {
            try {
                int n;
                TIMETOLIVE = n = new Integer(propertiesFileHandler.getProperty(TIMETOLIVESTR)).intValue();
            }
            catch (Exception exception) {
                TIMETOLIVE = 1;
            }
        } else {
            TIMETOLIVE = 1;
        }
        System.out.println("TIMETOLIVE=" + TIMETOLIVE);
        return true;
    }

    @Override
    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processCommand(PluginDataInfo pluginDataInfo) {
        String string = this.getIP(pluginDataInfo.getReceiverWWN());
        int n = NetworkToJavaConverter.byteArrayToInt(pluginDataInfo.getBuffer());
        byte[] byArray = null;
        int n2 = 0;
        if (n == 262) {
            Object object;
            Object object2;
            Object object3;
            HashMap hashMap;
            Cloneable cloneable = ipHash;
            synchronized (cloneable) {
                hashMap = (HashMap)ipHash.clone();
            }
            cloneable = new ArrayList();
            try {
                object3 = NetworkInterface.getNetworkInterfaces();
                while (object3 != null && object3.hasMoreElements()) {
                    Object object4;
                    NetworkInterface networkInterface = object3.nextElement();
                    if (networkInterface == null || networkInterface.isLoopback() || !networkInterface.isUp() || !networkInterface.supportsMulticast() || (object4 = networkInterface.getInetAddresses()) == null) continue;
                    while (object4.hasMoreElements()) {
                        object2 = object4.nextElement();
                        object = ((InetAddress)object2).getHostAddress();
                        System.out.println("nic:" + (String)object + ":" + !hashMap.containsKey(object2) + ":" + object2);
                        if (((String)object).equals(string) || !hashMap.containsKey(object2)) continue;
                        ((ArrayList)cloneable).add(object);
                    }
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
            System.out.println("local ip list::" + cloneable);
            System.out.println("localIP::" + string);
            if ((string.equals("127.0.0.1") || !hashMap.containsKey(string)) && ((ArrayList)cloneable).size() > 1) {
                ((ArrayList)cloneable).remove(0);
            }
            System.out.println("local ip list::" + cloneable);
            object3 = new HashMap();
            for (Object object4 : hashMap.keySet()) {
                if (((ArrayList)cloneable).contains(((InetAddress)object4).getHostAddress())) {
                    System.out.println("multiple ipaddress;skipping ip-" + ((InetAddress)object4).getHostAddress());
                    continue;
                }
                ((HashMap)object3).put(object4, hashMap.get(object4));
            }
            for (Object object4 : ((HashMap)object3).keySet()) {
                object2 = ((InetAddress)object4).getHostAddress() + ":" + NetworkManager.getPort() + ":" + 0;
                object = NetworkPacket.convertWWNStringToByteArray((String)object2);
                if (byArray == null) {
                    byArray = new byte[4 + ((Object)object).length * ((HashMap)object3).size()];
                    NetworkToJavaConverter.intToByteArray(((HashMap)object3).size(), byArray);
                    n2 += 4;
                }
                System.arraycopy(object, 0, byArray, n2, ((Object)object).length);
                n2 += ((Object)object).length;
            }
            if (byArray == null) {
                byArray = new byte[4];
                NetworkToJavaConverter.intToByteArray(0, byArray);
            }
            pluginDataInfo.setBuffer(byArray);
            return true;
        }
        return false;
    }

    @Override
    public void shutdown() {
        continueRun = false;
        if (this.purgeThread != null) {
            this.purgeThread.interrupt();
        }
        if (this.sender != null && this.sender.isAlive()) {
            this.sender.interrupt();
        } else {
            if (this.receiver_old != null && this.receiver_old.isAlive()) {
                this.receiver_old.interrupt();
            }
            if (this.receiver_new != null && this.receiver_new.isAlive()) {
                this.receiver_new.interrupt();
            }
        }
        TCPConfirmer.stopRun();
        ipHash.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (continueRun) {
            HashMap hashMap;
            Cloneable cloneable = ipHash;
            synchronized (cloneable) {
                hashMap = (HashMap)ipHash.clone();
            }
            cloneable = new ArrayList();
            for (Object object : hashMap.keySet()) {
                ArrayList arrayList = (ArrayList)hashMap.get(object);
                Long l = (Long)arrayList.get(0);
                int n = (Integer)arrayList.get(1);
                if (System.currentTimeMillis() - l <= (long)(TIMEOUT_DELTA + 5 * HEART_BEAT_INTERVAL) || !TCPConfirmer.isRemoteFrameworkReallyDead((InetAddress)object, n)) continue;
                ((ArrayList)cloneable).add(object);
            }
            HashMap hashMap2 = ipHash;
            synchronized (hashMap2) {
                Object object;
                object = ((ArrayList)cloneable).listIterator();
                while (object.hasNext()) {
                    System.out.println("inside NC run size of ipHash <need to be removed>" + cloneable);
                    ipHash.remove(object.next());
                }
            }
            try {
                Thread.sleep(HEART_BEAT_INTERVAL);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    private String getIP(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        return string.split(":")[0];
    }

    @Override
    public void preShutdown() {
    }

    @Override
    public void startupOperations() {
    }
}

