/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.FrameworkInterface;
import Framework.PluginManagers.PluginDataInfo;
import Framework.PluginManagers.PluginInfo;
import Framework.PluginManagers.PluginInterface;
import Services.CommonConstants;
import Services.LogXMLParser;
import Services.NetworkToJavaConverter;
import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import plugins.Localization;

public class PopupService
implements PluginInterface,
CommonConstants {
    private static final int majorGroup = 0;
    private static final int minorGroup = 7;
    private static final String version = "1.10";
    private static final String description = "Popup Service Plugin version: 1.10";
    private PluginInfo pluginInfo = new PluginInfo();
    private ArrayList<EventInfo> eventQueue = null;

    public PopupService() {
        System.out.println("popup constructor");
    }

    @Override
    public boolean init(String string, FrameworkInterface frameworkInterface) {
        System.out.println("Inside popup init");
        this.pluginInfo.setMajorGroup(0);
        this.pluginInfo.setMinorGroup(7);
        this.pluginInfo.setVersion(version);
        this.pluginInfo.setWWN(string);
        this.pluginInfo.setDescription(description);
        this.eventQueue = new ArrayList();
        return true;
    }

    @Override
    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    private synchronized boolean formNewAEN(PluginDataInfo pluginDataInfo) {
        String string;
        System.out.println("PopupService.formNewAEN()");
        byte[] byArray = pluginDataInfo.getBuffer();
        String string2 = new String(byArray, 4, byArray.length - 4);
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = string2.getBytes();
        int n = 0;
        int n2 = 0;
        while (n < byArray3.length && n2 < byArray3.length) {
            if (byArray3[n] == 10 || byArray3[n] == 13) {
                ++n;
                continue;
            }
            byArray3[n2++] = byArray3[n++];
        }
        string2 = string = new String(byArray3, 0, n2);
        try {
            NetworkToJavaConverter.intToByteArray(0, byArray2);
            pluginDataInfo.setBuffer(byArray2);
            System.out.println("strToWrite  :" + string2);
            LogXMLParser logXMLParser = new LogXMLParser(string2);
            Localization localization = new Localization("en", "US");
            logXMLParser.setTagValue("languageCode", localization.getLanguage());
            String string3 = localization.getLocalizedStringWithoutUnicodeConversion(logXMLParser.getTagValue("id").trim(), logXMLParser.getParams());
            logXMLParser.setTagValue("localizedMessage", string3);
            System.out.println("Bagavathy AEN Hello " + string3);
            int n3 = 1;
            int n4 = logXMLParser.getMessageClass();
            if (n4 == 0) {
                n3 = 1;
            } else if (n4 == 1) {
                n3 = 2;
            } else if (n4 == 2) {
                n3 = 3;
            } else if (n4 == 3) {
                n3 = 0;
            } else if (n4 == 4) {
                // empty if block
            }
            this.handleAEN(string3, n3);
        }
        catch (Exception exception) {
            System.out.println("Inside formNewAen catch");
            exception.printStackTrace();
            NetworkToJavaConverter.intToByteArray(0, byArray2);
            pluginDataInfo.setBuffer(byArray2);
        }
        System.out.println("Returning true from formNewAEN().");
        return true;
    }

    private void handleAEN(String string, int n) {
        System.out.println("PopupService.handleAEN()");
        try {
            if (PopupService.isDisplayAvailable()) {
                System.out.println("Handle: YES display available: before display");
                this.DisplayMessage(string, n);
            } else {
                System.out.println("Handle: NO display, so can't show popup.");
            }
            System.out.println("Returning from handleAEN().");
        }
        catch (Exception exception) {
            System.out.println("Inside the exception in the handleAEN().");
            exception.printStackTrace();
        }
        System.out.println("Returning from handleAEN");
    }

    private void DisplayMessage(String string, int n) {
        System.out.println("PopupService.DisplayMessage()");
        try {
            System.out.println("Trying to show JDialog");
            System.out.println("localizedStr :" + string);
            System.out.println("messageType :" + n);
            JOptionPane jOptionPane = new JOptionPane(string, n);
            if (jOptionPane != null) {
                System.out.println("JOptionPane object is :" + jOptionPane);
                JDialog jDialog = jOptionPane.createDialog("Event Notification Application");
                if (jDialog != null) {
                    System.out.println("JDIAlog object is :" + jDialog);
                    jDialog.setModalityType(Dialog.ModalityType.MODELESS);
                    jDialog.setVisible(true);
                    System.out.println("Shown Dialogue...");
                } else {
                    System.out.println("JDIAlog object is null");
                }
            } else {
                System.out.println("JOptionPane object is null");
            }
        }
        catch (Throwable throwable) {
            System.out.println("inside DisplayMessage catch");
            throwable.printStackTrace();
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                System.out.println(stackTraceElementArray[i]);
            }
            return;
        }
        System.out.println("Returning from PopupService.DisplayMessage()");
    }

    private static boolean isDisplayAvailable() {
        System.out.println("PopupService.isDisplayAvailable()");
        boolean bl = false;
        try {
            bl = !GraphicsEnvironment.isHeadless();
            System.out.println("isDisplayAvailable: " + bl);
        }
        catch (Throwable throwable) {
            System.out.println("catching throwable from isDisplayAvailable().");
            throwable.printStackTrace();
        }
        System.out.println("Returning " + bl + " from isDisplayAvailable().");
        return bl;
    }

    @Override
    public boolean processCommand(PluginDataInfo pluginDataInfo) {
        System.out.println("popup processcomd");
        int n = NetworkToJavaConverter.byteArrayToInt(pluginDataInfo.getBuffer());
        System.out.println("popup processcomd cmd" + n);
        return this.formNewAEN(pluginDataInfo);
    }

    @Override
    public void shutdown() {
        System.out.println("popup shutdown");
    }

    @Override
    public void preShutdown() {
    }

    @Override
    public void startupOperations() {
    }

    public class EventInfo {
        private String eventDescStr;
        private int messageType;

        public EventInfo(String string, int n) {
            this.eventDescStr = string;
            this.messageType = n;
        }
    }
}

