/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.FrameworkInterface;
import Framework.Network.CachedSSLSocketFactory;
import Framework.Network.SocketData;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Framework.PluginManagers.PluginDataInfo;
import Services.NetworkDataPacket;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import plugins.ManageCIMOMServer;

public class ProcessCommand {
    private String m_senderWWN = null;
    private String m_receiverWWN = null;
    private FrameworkInterface m_objFramework = null;
    private ManageCIMOMServer m_cimmomDetails = null;
    private boolean m_isCimomCmd = false;

    ProcessCommand() {
    }

    ProcessCommand(String string, String string2, FrameworkInterface frameworkInterface, ManageCIMOMServer manageCIMOMServer, boolean bl) {
        this.m_senderWWN = string;
        this.m_receiverWWN = string2;
        this.m_objFramework = frameworkInterface;
        this.m_cimmomDetails = manageCIMOMServer;
        this.m_isCimomCmd = bl;
    }

    public int fireDCMDCommand(NetworkDataPacket networkDataPacket) {
        byte[] byArray = null;
        if (this.m_isCimomCmd) {
            byte[] byArray2 = networkDataPacket.getDataBuffer();
            byte[] byArray3 = new byte[552 + byArray2.length];
            int n = 0;
            byte[] byArray4 = this.m_cimmomDetails.getCIMMOMIP();
            byte[] byArray5 = this.m_cimmomDetails.getCIMMOMPort();
            byte[] byArray6 = this.m_cimmomDetails.getCIMMOMUserName();
            byte[] byArray7 = this.m_cimmomDetails.getCIMMOMPassword();
            NetworkToJavaConverter.intToByteArray(271, byArray3, 0);
            System.arraycopy(byArray4, 0, byArray3, n += 4, byArray4.length);
            System.arraycopy(byArray5, 0, byArray3, n += 32, byArray5.length);
            System.arraycopy(byArray6, 0, byArray3, n += 4, byArray6.length);
            System.arraycopy(byArray7, 0, byArray3, n += 256, byArray7.length);
            System.arraycopy(byArray2, 0, byArray3, n += 256, byArray2.length);
            n += byArray2.length;
            NetworkDataPacket networkDataPacket2 = new NetworkDataPacket(byArray3);
            int n2 = 271;
            byte[] byArray8 = new byte[60];
            NetworkToJavaConverter.intToByteArray(n2, byArray8, 0);
            System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.m_senderWWN), 0, byArray8, 4, 24);
            System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.m_receiverWWN), 0, byArray8, 28, 24);
            NetworkToJavaConverter.intToByteArray(networkDataPacket2.getDataBuffer().length, byArray8, 56);
            byArray = networkDataPacket2.getDataBuffer();
            PluginDataInfo pluginDataInfo = null;
            pluginDataInfo = new PluginDataInfo(this.m_senderWWN, this.m_receiverWWN, byArray);
            boolean bl = this.m_objFramework.ProcessCommand(271, pluginDataInfo);
            if (bl) {
                networkDataPacket.setDataBuffer(pluginDataInfo.getBuffer());
                return 0;
            }
            System.out.println("Generic Failure");
            return 1;
        }
        int n = 6;
        byte[] byArray9 = new byte[60];
        NetworkToJavaConverter.intToByteArray(n, byArray9, 0);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.m_senderWWN), 0, byArray9, 4, 24);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(this.m_receiverWWN), 0, byArray9, 28, 24);
        NetworkToJavaConverter.intToByteArray(networkDataPacket.getDataBuffer().length, byArray9, 56);
        int n3 = NetworkToJavaConverter.byteArrayToInt(networkDataPacket.getDataBuffer(), 0);
        byArray = networkDataPacket.getDataBuffer();
        PluginDataInfo pluginDataInfo = null;
        pluginDataInfo = new PluginDataInfo(this.m_senderWWN, this.m_receiverWWN, byArray);
        boolean bl = this.m_objFramework.ProcessCommand(4098, pluginDataInfo);
        if (bl) {
            networkDataPacket.setDataBuffer(pluginDataInfo.getBuffer());
            return 0;
        }
        return 1;
    }

    public int fireProcessCommand(byte[] byArray, NetworkDataPacket networkDataPacket) throws IOException, VivaldiFrameworkProtocolErrorException {
        boolean bl;
        int n = 1;
        int n2 = 0;
        String string = null;
        int n3 = 0;
        do {
            try {
                BufferedOutputStream bufferedOutputStream = null;
                DataInputStream dataInputStream = null;
                SocketData socketData = null;
                bl = false;
                string = NetworkPacket.getReceiverIPAsStringFromHeader(byArray);
                n3 = NetworkPacket.getReceiverPortFromHeader(byArray);
                socketData = CachedSSLSocketFactory.createSocket(string, n3);
                bufferedOutputStream = socketData.getOutputStream();
                dataInputStream = socketData.getInputStream();
                if (byArray.length > 0) {
                    bufferedOutputStream.write(byArray, 0, byArray.length);
                }
                byte[] byArray2 = networkDataPacket.getDataBuffer();
                n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 56);
                if (n2 > 0) {
                    bufferedOutputStream.write(byArray2, 0, n2);
                }
                bufferedOutputStream.flush();
                dataInputStream.readFully(byArray);
                int n4 = NetworkToJavaConverter.byteArrayToInt(byArray, 52);
                if (n4 != 0) {
                    throw new VivaldiFrameworkProtocolErrorException(n4);
                }
                n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 56);
                if (n2 > 0) {
                    byArray2 = new byte[n2];
                    int n5 = 0;
                    int n6 = 0;
                    while ((n5 = dataInputStream.read(byArray2, n6, n2 - n6)) != 0 && n2 != (n6 += n5)) {
                    }
                }
                networkDataPacket.setDataBuffer(byArray2);
                CachedSSLSocketFactory.returnSocket(socketData, string, n3);
            }
            catch (IOException iOException) {
                if (--n >= 0) {
                    bl = true;
                    System.out.println("Socket connection to " + string + " failed once..try again");
                    CachedSSLSocketFactory.removeSocketCache(string, 3071);
                    continue;
                }
                System.out.println("Socket connection to " + string + " failed on retry");
                throw iOException;
            }
        } while (bl);
        return n2;
    }
}

