/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Services.NetworkToJavaConverter;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import plugins.NetworkCapabilityPlugin;

public class Receiver
extends Thread {
    private byte[] dataBuffer;
    private MulticastSocket multicastsocket = null;
    private DatagramPacket datagrampacket = null;
    volatile boolean goOnListening = true;
    volatile boolean nowListening = false;
    private int portlist;
    static int receiverCount = 0;

    public Receiver(int n) {
        this.portlist = n;
    }

    public boolean init() {
        try {
            this.multicastsocket = new MulticastSocket(this.portlist);
            this.multicastsocket.setSoTimeout(10000);
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration != null && enumeration.hasMoreElements()) {
                Enumeration<InetAddress> enumeration2;
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface == null || networkInterface.isLoopback() || !networkInterface.supportsMulticast() || !networkInterface.isUp() || (enumeration2 = networkInterface.getInetAddresses()) == null || !enumeration2.hasMoreElements()) continue;
                this.multicastsocket.setNetworkInterface(networkInterface);
                this.multicastsocket.joinGroup(NetworkCapabilityPlugin.inetAddr);
            }
            this.dataBuffer = new byte[NetworkCapabilityPlugin.message.length()];
            this.datagrampacket = new DatagramPacket(this.dataBuffer, this.dataBuffer.length);
        }
        catch (Exception exception) {
            System.out.println("NetworkCapabilityPlugin Receiver: failed to initialize");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("Receiver " + receiverCount++);
        this.nowListening = true;
        while (NetworkCapabilityPlugin.continueRun && this.goOnListening) {
            try {
                this.multicastsocket.receive(this.datagrampacket);
                HashMap hashMap = NetworkCapabilityPlugin.ipHash;
                synchronized (hashMap) {
                    ArrayList<Number> arrayList = new ArrayList<Number>(2);
                    int n = NetworkToJavaConverter.byteArrayToInt(this.datagrampacket.getData());
                    arrayList.add(new Long(System.currentTimeMillis()));
                    arrayList.add(new Integer(n));
                    if (NetworkCapabilityPlugin.ipHash.get(this.datagrampacket.getAddress()) == null) {
                        // empty if block
                    }
                    NetworkCapabilityPlugin.ipHash.put(this.datagrampacket.getAddress(), arrayList);
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (Exception exception) {
                System.out.println("Exception in receiver..." + exception.getMessage());
            }
        }
        this.nowListening = false;
        this.multicastsocket.close();
        this.multicastsocket = null;
        System.gc();
    }
}

