/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.FrameworkInterface;
import Framework.PluginManagers.PluginDataInfo;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import Services.NetworkDataPacket;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import java.util.ArrayList;
import plugins.AdapterDetails;
import plugins.Utils.PluginsWWN;

public class SASAdapterList
extends Thread {
    public static FrameworkInterface objFramework = null;
    private static ArrayList adapterList = null;
    private static ArrayList adapterTypeList = null;
    private static ArrayList adapterIDDetailList = null;
    public static final int ADAPTER_UNKNOWN = 0;
    public static final int ADAPTER_SAS_MEGARAID = 1;
    public static final int ADAPTER_SAS_IR = 2;
    public static final int ADAPTER_SAS_IR2 = 3;
    public static final int ADAPTER_SAS_IR3 = 4;

    SASAdapterList(FrameworkInterface frameworkInterface) {
        objFramework = frameworkInterface;
    }

    SASAdapterList() {
    }

    @Override
    public void run() {
        this.createSASAdapters();
    }

    public void createSASAdapters() {
        Integer n;
        int n2;
        ArrayList arrayList = new ArrayList();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList arrayList3 = new ArrayList();
        int n3 = 0;
        System.out.println("b4 assignment tempList");
        try {
            arrayList3 = this.getControllerList((byte)1, PluginsWWN.getMonitorWWN(), PluginsWWN.getStorelibWWN());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        System.out.println("tempList length -> " + arrayList3.size());
        if (arrayList3 != null) {
            for (int i = 0; i < arrayList3.size(); ++i) {
                arrayList.add(arrayList3.get(i));
                arrayList2.add(1);
                ++n3;
            }
        } else {
            System.out.println("MR ctrlr count 0");
        }
        try {
            arrayList3 = this.getControllerList((byte)2, PluginsWWN.getMonitorWWN(), PluginsWWN.getStorelibIRWWN());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            arrayList3 = null;
            System.out.println("inside IR catch");
        }
        if (arrayList3 != null) {
            for (int i = 0; i < arrayList3.size(); ++i) {
                arrayList.add(arrayList3.get(i));
                arrayList2.add(2);
                ++n3;
            }
        } else {
            System.out.println("IR ctrlr count 0");
        }
        try {
            arrayList3 = this.getControllerList((byte)3, PluginsWWN.getMonitorWWN(), PluginsWWN.getStorelibIRWWN());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            arrayList3 = null;
        }
        if (arrayList3 != null) {
            for (int i = 0; i < arrayList3.size(); ++i) {
                arrayList.add(arrayList3.get(i));
                arrayList2.add(3);
                ++n3;
            }
        } else {
            System.out.println("IR2 ctrlr count 0");
        }
        try {
            arrayList3 = this.getControllerList((byte)4, PluginsWWN.getMonitorWWN(), PluginsWWN.getStorelibIRWWN());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            arrayList3 = null;
        }
        if (arrayList3 != null) {
            for (int i = 0; i < arrayList3.size(); ++i) {
                arrayList.add(arrayList3.get(i));
                arrayList2.add(4);
                ++n3;
            }
        } else {
            System.out.println("IR3 ctrlr count 0");
        }
        try {
            arrayList3 = this.getVirtualControllerList((byte)3, PluginsWWN.getMonitorWWN(), PluginsWWN.getStorelibIRWWN());
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            arrayList3 = null;
        }
        if (arrayList3 != null) {
            for (int i = 0; i < arrayList3.size(); ++i) {
                arrayList.add(arrayList3.get(i));
                arrayList2.add(3);
                ++n3;
            }
        } else {
            System.out.println("Virtual ctrlr count 0");
        }
        adapterList = arrayList;
        adapterTypeList = arrayList2;
        System.out.println("size of adapterTypeList" + adapterTypeList.size());
        ArrayList arrayList4 = new ArrayList();
        ArrayList<AdapterDetails> arrayList5 = new ArrayList<AdapterDetails>();
        arrayList4 = adapterList;
        if (arrayList4 != null) {
            for (n2 = 0; n2 < arrayList4.size(); ++n2) {
                n = (Integer)arrayList4.get(n2);
                Integer n4 = (Integer)adapterTypeList.get(n2);
                AdapterDetails adapterDetails = new AdapterDetails();
                adapterDetails.setControllerIndex(n2);
                adapterDetails.setControllerID(n);
                adapterDetails.setControllerType(n4);
                arrayList5.add(adapterDetails);
            }
        }
        adapterIDDetailList = arrayList5;
        if (arrayList4 != null) {
            for (n2 = 0; n2 < arrayList4.size(); ++n2) {
                n = (Integer)arrayList4.get(n2);
                System.out.println("Discovered ctrl ID -> " + n);
            }
        } else {
            System.out.println("Controller not found in Ctrl Detection");
        }
    }

    public ArrayList getAdapterList() {
        if (adapterList == null) {
            System.out.println("Error in getting adapter list");
        }
        return adapterList;
    }

    public ArrayList getAdapterTypeList() {
        if (adapterTypeList == null) {
            System.out.println("Error in getting adapter type list");
        }
        return adapterTypeList;
    }

    public ArrayList getAdapterIDDetailList() {
        if (adapterIDDetailList == null) {
            System.out.println("Error in getting adapterIDDetailList");
        }
        return adapterIDDetailList;
    }

    public int getControllerIndex(int n) {
        int n2 = 0;
        for (int i = 0; i < adapterIDDetailList.size(); ++i) {
            AdapterDetails adapterDetails = (AdapterDetails)adapterIDDetailList.get(i);
            if (n != adapterDetails.getControllerID()) continue;
            n2 = adapterDetails.getControllerIndex();
            break;
        }
        return n2;
    }

    public int getControllerType(int n) {
        int n2 = 0;
        for (int i = 0; i < adapterIDDetailList.size(); ++i) {
            AdapterDetails adapterDetails = (AdapterDetails)adapterIDDetailList.get(i);
            if (n != adapterDetails.getControllerID()) continue;
            n2 = adapterDetails.getControllerType();
            break;
        }
        return n2;
    }

    ArrayList getControllerList(byte by, String string, String string2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        NetworkDataPacket networkDataPacket = null;
        byte[] byArray = null;
        if (1 == by) {
            networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0, 68).getByteArray());
        } else if (2 == by) {
            networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0x1000000, 68).getByteArray());
        } else if (3 == by) {
            networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0x2000000, 68).getByteArray());
        } else if (4 == by) {
            networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0x4000000, 68).getByteArray());
        } else {
            return null;
        }
        int n = 6;
        byte[] byArray2 = new byte[60];
        NetworkToJavaConverter.intToByteArray(n, byArray2, 0);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(string), 0, byArray2, 4, 24);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(string2), 0, byArray2, 28, 24);
        NetworkToJavaConverter.intToByteArray(networkDataPacket.getDataBuffer().length, byArray2, 56);
        byArray = networkDataPacket.getDataBuffer();
        PluginDataInfo pluginDataInfo = null;
        pluginDataInfo = new PluginDataInfo(string, string2, byArray);
        boolean bl = objFramework.ProcessCommand(4098, pluginDataInfo);
        if (bl) {
            byte[] byArray3 = networkDataPacket.getDataBuffer();
            int n2 = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray3, 44);
            System.out.println("Number of Controller Found = " + n2);
            for (int i = 0; i < n2; ++i) {
                int n3 = NetworkToJavaConverter.byteArrayToInt(byArray3, 48 + i * 4);
                System.out.println("Controller ID int value = " + n3);
                arrayList.add(new Integer(n3));
            }
        } else {
            System.out.println("Generic Failure");
        }
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        return arrayList;
    }

    ArrayList getVirtualControllerList(byte by, String string, String string2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        NetworkDataPacket networkDataPacket = null;
        byte[] byArray = null;
        networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 10, 0x2000000, 68).getByteArray());
        int n = 6;
        byte[] byArray2 = new byte[60];
        NetworkToJavaConverter.intToByteArray(n, byArray2, 0);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(string), 0, byArray2, 4, 24);
        System.arraycopy(NetworkPacket.convertWWNStringToByteArray(string2), 0, byArray2, 28, 24);
        NetworkToJavaConverter.intToByteArray(networkDataPacket.getDataBuffer().length, byArray2, 56);
        byArray = networkDataPacket.getDataBuffer();
        PluginDataInfo pluginDataInfo = null;
        pluginDataInfo = new PluginDataInfo(string, string2, byArray);
        boolean bl = objFramework.ProcessCommand(4098, pluginDataInfo);
        if (bl) {
            byte[] byArray3 = networkDataPacket.getDataBuffer();
            int n2 = NetworkToJavaConverter.byteArrayToUnsignedShort(byArray3, 44);
            System.out.println("Number of Virtual Controller Found = " + n2);
            for (int i = 0; i < n2; ++i) {
                int n3 = NetworkToJavaConverter.byteArrayToInt(byArray3, 48 + i * 4);
                System.out.println("Virtual Controller ID int value = " + n3);
                arrayList.add(new Integer(n3));
            }
        } else {
            System.out.println("Generic Failure");
        }
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList;
        }
        return arrayList;
    }
}

