/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Services.NetworkToJavaConverter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.Enumeration;
import plugins.NetworkCapabilityPlugin;
import plugins.TCPConfirmer;

public class Sender
extends Thread {
    private MulticastSocket multicastsocket = null;
    private DatagramPacket datagrampacket = null;

    public boolean init() {
        byte[] byArray = new byte[4];
        NetworkToJavaConverter.intToByteArray(TCPConfirmer.getServerSocketPort(), byArray);
        this.datagrampacket = new DatagramPacket(byArray, byArray.length, NetworkCapabilityPlugin.inetAddr, NetworkCapabilityPlugin.MULTICAST_PORT_3071);
        System.out.println("Sender will send port:" + NetworkToJavaConverter.byteArrayToInt(byArray));
        try {
            this.multicastsocket = new MulticastSocket();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        Enumeration<InetAddress> enumeration;
        NetworkInterface networkInterface;
        Enumeration<NetworkInterface> enumeration2;
        while (NetworkCapabilityPlugin.continueRun) {
            try {
                enumeration2 = NetworkInterface.getNetworkInterfaces();
                while (enumeration2 != null && enumeration2.hasMoreElements()) {
                    networkInterface = enumeration2.nextElement();
                    if (networkInterface == null || networkInterface.isLoopback() || !networkInterface.isUp() || !networkInterface.supportsMulticast() || (enumeration = networkInterface.getInetAddresses()) == null || !enumeration.hasMoreElements()) continue;
                    this.multicastsocket.setNetworkInterface(networkInterface);
                    this.multicastsocket.setTimeToLive(NetworkCapabilityPlugin.TIMETOLIVE);
                    this.multicastsocket.send(this.datagrampacket);
                }
                Thread.sleep(NetworkCapabilityPlugin.HEART_BEAT_INTERVAL);
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                System.out.println("NetworkCapability Plugin::Failed to send heartbeat!");
                return;
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Sender: Sleep interrupted");
                break;
            }
        }
        try {
            enumeration2 = NetworkInterface.getNetworkInterfaces();
            while (enumeration2 != null && enumeration2.hasMoreElements()) {
                networkInterface = enumeration2.nextElement();
                if (networkInterface == null || networkInterface.isLoopback() || !networkInterface.isUp() || !networkInterface.supportsMulticast() || (enumeration = networkInterface.getInetAddresses()) == null || !enumeration.hasMoreElements()) continue;
                this.multicastsocket.setNetworkInterface(networkInterface);
                this.multicastsocket.setTimeToLive(NetworkCapabilityPlugin.TIMETOLIVE);
                this.multicastsocket.send(this.datagrampacket);
            }
        }
        catch (IOException iOException) {
            System.out.println("Exception while sending the wake up datagram.");
            iOException.printStackTrace();
        }
    }
}

