/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.FrameworkInterface;
import Framework.PluginManagers.PluginDataInfo;
import Framework.PluginManagers.PluginInfo;
import Framework.PluginManagers.PluginInterface;
import Framework.PluginManagers.PluginManager;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.SL_EVENT_DETAIL_T;
import Services.NetworkToJavaConverter;
import java.util.ArrayList;
import plugins.AENRegistrationData;
import plugins.Utils.PluginsWWN;

public class StorelibPlugin
implements PluginInterface {
    private static final int majorGroup = 1;
    private static final int minorGroup = 2;
    private static final String version = "2.01";
    private static String description = "Storelib Plugin version:2.01";
    private static final String libName = "storelibjni";
    private static PluginInfo pluginInfo = new PluginInfo();
    private static FrameworkInterface framework = null;
    private static ArrayList<AENRegistrationData> m_aenRegDataList = new ArrayList();
    private static boolean startedCallbackThread = false;

    public native boolean processNativeCommand(byte[] var1);

    public native boolean storeLibInit();

    public native boolean storeLibExit();

    public native void startCallbackThread(byte[] var1);

    public static native void stopCallbackThread();

    private static native String getVersion();

    public static native void systemLogWin(byte[] var0, String var1, int var2);

    public static native void systemLogLin(byte[] var0, String var1, int var2);

    private static void loadLibrary() {
        System.loadLibrary(libName);
    }

    public static Object[] getClientList() {
        int n = m_aenRegDataList.size();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = m_aenRegDataList.get(i).getSenderWWN();
        }
        return objectArray;
    }

    @Override
    public void shutdown() {
        if (startedCallbackThread) {
            StorelibPlugin.stopCallbackThread();
            startedCallbackThread = false;
        }
        this.storeLibExit();
        System.out.println("Storelib shut down....");
    }

    @Override
    public boolean init(String string, FrameworkInterface frameworkInterface) {
        this.loadLibrary();
        pluginInfo.setMajorGroup(1);
        pluginInfo.setMinorGroup(2);
        pluginInfo.setVersion(version);
        pluginInfo.setWWN(string);
        framework = frameworkInterface;
        if (!this.storeLibInit()) {
            return false;
        }
        new pluginCallbackThread();
        startedCallbackThread = true;
        description = description + " JNI Layer Version: " + StorelibPlugin.getVersion();
        pluginInfo.setDescription(description);
        return true;
    }

    @Override
    public PluginInfo getPluginInfo() {
        return pluginInfo;
    }

    public void snapshotCreatePIT(byte[] byArray, short s, int n) {
        int n2 = 77;
        byte[] byArray2 = new byte[1 + byArray.length + 2 + 4];
        byArray2[0] = n2;
        System.arraycopy(byArray, 0, byArray2, 1, 64);
        NetworkToJavaConverter.shortTobyteArray(s, byArray2, 65);
        NetworkToJavaConverter.intToByteArray(n, byArray2, 67);
        this.processNativeCommand(byArray2);
    }

    @Override
    public boolean processCommand(PluginDataInfo pluginDataInfo) {
        int n;
        byte[] byArray = pluginDataInfo.getBuffer();
        boolean bl = this.processNativeCommand(byArray);
        AENRegistrationData aENRegistrationData = null;
        if (bl && byArray[4] == 0 && (n = NetworkToJavaConverter.byteArrayToInt(byArray)) == 0) {
            if (byArray[5] == 1) {
                int n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 112);
                AENRegistrationData aENRegistrationData2 = new AENRegistrationData();
                aENRegistrationData2.setCtrlId(NetworkToJavaConverter.byteArrayToInt(byArray, 8));
                aENRegistrationData2.setUniqueId(n2);
                aENRegistrationData2.setSenderWWN(pluginDataInfo.getSenderWWN());
                int n3 = m_aenRegDataList.size();
                for (int i = 0; i < n3; ++i) {
                    aENRegistrationData = m_aenRegDataList.get(i);
                    if (!aENRegistrationData2.equals(aENRegistrationData.getCtrlId()) || !aENRegistrationData2.equals(aENRegistrationData.getSenderWWN())) continue;
                    m_aenRegDataList.remove(i);
                    break;
                }
                m_aenRegDataList.add(aENRegistrationData2);
            } else if (byArray[5] == 2) {
                int n4 = NetworkToJavaConverter.byteArrayToInt(byArray, 20);
                int n5 = NetworkToJavaConverter.byteArrayToInt(byArray, 8);
                int n6 = m_aenRegDataList.size();
                for (int i = 0; i < n6; ++i) {
                    aENRegistrationData = m_aenRegDataList.get(i);
                    if (n4 != aENRegistrationData.getUniqueId() || n5 != aENRegistrationData.getCtrlId()) continue;
                    m_aenRegDataList.remove(i);
                    break;
                }
            }
        }
        return bl;
    }

    public int pluginCallback(byte[] byArray) {
        Object object;
        SL_EVENT_DETAIL_T sL_EVENT_DETAIL_T;
        int n = NetworkToJavaConverter.byteArrayToInt(byArray, 8);
        int n2 = NetworkToJavaConverter.byteArrayToInt(byArray, 4);
        AENRegistrationData aENRegistrationData = null;
        String string = null;
        int n3 = m_aenRegDataList.size();
        for (int i = 0; i < n3; ++i) {
            aENRegistrationData = m_aenRegDataList.get(i);
            if (n != aENRegistrationData.getUniqueId() || n2 != aENRegistrationData.getCtrlId()) continue;
            string = aENRegistrationData.getSenderWWN();
            break;
        }
        if (string == null) {
            System.out.println("Unknown registration id in AEN callback!!\n");
            try {
                string = PluginsWWN.getMonitorWWN();
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
            }
            if (string == null) {
                return 0;
            }
        }
        if ((sL_EVENT_DETAIL_T = new SL_EVENT_DETAIL_T(byArray, 0)).getevtDetail().getcode() == 381) {
            short s;
            System.out.println("\nSchedule Expired \n");
            object = sL_EVENT_DETAIL_T.getevtDetail();
            int n4 = sL_EVENT_DETAIL_T.getctrlId();
            char[] cArray = new char[8];
            byte[] byArray2 = new byte[64];
            for (s = 0; s < 8; ++s) {
                cArray[s] = ((MR_EVT_DETAIL)object).getargs_MR_EVT_DETAIL1().getArgsBitmap().getEvtBitmap()[s];
                System.out.println("BITMAP is " + cArray[s]);
            }
            s = 0;
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    if ((cArray[i] & 1 << j) == 0) continue;
                    byArray2[s] = (byte)(i * 8 + j);
                    System.out.println("targetIds: " + byArray2[s]);
                    s = (short)(s + 1);
                }
            }
            System.out.println("The number of LDs are " + s);
            if (s != 0) {
                this.snapshotCreatePIT(byArray2, s, n4);
            }
            System.out.println("After JNI Call...");
        }
        object = new PluginDataInfo();
        ((PluginDataInfo)object).setBuffer(byArray);
        ((PluginDataInfo)object).setReceiverWWN(string);
        ((PluginDataInfo)object).setSenderWWN(pluginInfo.getWWN());
        if (framework.ProcessCommand(4098, (PluginDataInfo)object)) {
            return 0;
        }
        AENRegistrationData aENRegistrationData2 = null;
        n3 = m_aenRegDataList.size();
        for (int i = 0; i < n3; ++i) {
            aENRegistrationData2 = m_aenRegDataList.get(i);
            if (n != aENRegistrationData2.getUniqueId() || n2 != aENRegistrationData2.getCtrlId()) continue;
            m_aenRegDataList.remove(i);
            break;
        }
        return 1;
    }

    public PluginInfo[] getPlugIns() {
        PluginInfo[] pluginInfoArray = PluginManager.getListOfPlugins();
        return pluginInfoArray;
    }

    private String getMonitorPluginWWN() throws VKOperationFailedException {
        PluginInfo[] pluginInfoArray = this.getPlugIns();
        for (int i = 0; i < pluginInfoArray.length; ++i) {
            if (0 != pluginInfoArray[i].getMajorGroup() || 8 != pluginInfoArray[i].getMinorGroup()) continue;
            return pluginInfoArray[i].getWWN();
        }
        throw new VKOperationFailedException(4096);
    }

    public static void doSystemLog(PluginDataInfo pluginDataInfo, String string, int n) {
        System.out.println("StorelibPlugin.doSystemLog() Inside");
        String string2 = string;
        String string3 = System.getProperty("os.name");
        if (string3.contains("Windows")) {
            StorelibPlugin.systemLogWin(pluginDataInfo.getBuffer(), string2, n);
        } else {
            StorelibPlugin.systemLogLin(pluginDataInfo.getBuffer(), string2, n);
        }
    }

    @Override
    public void preShutdown() {
    }

    @Override
    public void startupOperations() {
    }

    private class pluginCallbackThread
    extends Thread {
        pluginCallbackThread() {
            this.start();
        }

        @Override
        public void run() {
            byte[] byArray = new byte[268];
            StorelibPlugin.this.startCallbackThread(byArray);
        }
    }
}

