/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.FrameworkInterface;
import Framework.PluginManagers.PluginDataInfo;
import Framework.PluginManagers.PluginInfo;
import Framework.PluginManagers.PluginInterface;
import Framework.PluginManagers.PluginManager;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MSM_CLUSTERS_INFO;
import SASKernel.LibraryAPI.StoreLib.MSM_CLUSTER_INFO;
import SASKernel.LibraryAPI.StoreLib.SL_CTRL_HEALTH_T;
import SASKernel.LibraryAPI.StoreLib.SL_SYSTEM_HEALTH_T;
import SASKernel.LibraryAPI.StoreLib.SimpleCommandPacket;
import Services.CommonConstants;
import Services.NetworkDataPacket;
import Services.NetworkToJavaConverter;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class SystemInfo
implements PluginInterface,
CommonConstants {
    private static final int majorGroup = 0;
    private static final int minorGroup = 4;
    private static final String version = "1.04";
    private static final String description = "SystemInfo Plugin version: 1.04";
    private PluginInfo pluginInfo = new PluginInfo();
    private FrameworkInterface framework = null;
    private static String ARCH64TEXT = "x86_64";
    MR_CTRL_INFO mrControllerInfo = null;
    MR_CTRL_INFO dup_mrControllerInfo = null;
    byte systemType = this.getSystemType();
    byte[] dataBuff;
    private static byte[] clusterid = null;
    private int clusterSupported;
    private int maxHaNodes;
    int ctrlCount;

    private static native int sysType();

    @Override
    public boolean init(String string, FrameworkInterface frameworkInterface) {
        this.pluginInfo.setMajorGroup(0);
        this.pluginInfo.setMinorGroup(4);
        this.pluginInfo.setVersion(version);
        this.pluginInfo.setWWN(string);
        this.pluginInfo.setDescription(description);
        this.framework = frameworkInterface;
        return true;
    }

    @Override
    public PluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    public boolean getSystemInformation(PluginDataInfo pluginDataInfo) {
        byte[] byArray;
        ArrayList<Object> arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Object var4_4 = null;
        arrayList = this.getControllerinformation();
        Iterator<Object> iterator = arrayList.iterator();
        MSM_CLUSTER_INFO[] mSM_CLUSTER_INFOArray = new MSM_CLUSTER_INFO[arrayList.size()];
        int n = 0;
        while (iterator.hasNext()) {
            System.out.println("inside while");
            this.dup_mrControllerInfo = (MR_CTRL_INFO)iterator.next();
            clusterid = this.dup_mrControllerInfo.getClusterId();
            for (int i = 0; i < 16; ++i) {
                System.out.println("clusterid = " + clusterid[i]);
            }
            System.out.println("CLuser ID inside while" + this.dup_mrControllerInfo.getExpanderFwVersion());
            this.clusterSupported = this.dup_mrControllerInfo.getadapterOperations_MR_CTRL_INFO().getclusterSupported();
            System.out.println("before assiging=" + this.maxHaNodes);
            this.maxHaNodes = this.dup_mrControllerInfo.getmaxHANodes();
            System.out.println("maxHaNodes=" + this.maxHaNodes);
            mSM_CLUSTER_INFOArray[n] = new MSM_CLUSTER_INFO(clusterid, (byte)this.clusterSupported, (byte)this.maxHaNodes);
            ++n;
        }
        MSM_CLUSTERS_INFO mSM_CLUSTERS_INFO = new MSM_CLUSTERS_INFO(mSM_CLUSTER_INFOArray);
        String string = SystemInfo.getOSName();
        String string2 = System.getProperty("os.version");
        String string3 = SystemInfo.getOSArch();
        System.out.println("Cluster Id" + clusterid);
        String string4 = null;
        try {
            string4 = SystemInfo.getLocalHostName();
        }
        catch (Exception exception) {
            string4 = " ";
        }
        System.out.println("hostname==" + string4);
        byte[] byArray2 = new byte[400];
        int n2 = 0;
        NetworkToJavaConverter.shortTobyteArray((short)0, byArray2, n2);
        n2 += 2;
        System.out.println("buff[0] = " + byArray2[0]);
        System.out.println("buff[0] = " + byArray2[1]);
        if (string == null) {
            NetworkToJavaConverter.shortTobyteArray((short)0, byArray2, n2);
        } else {
            System.arraycopy(byArray, 0, byArray2, n2, (byArray = string.getBytes()).length >= 128 ? 128 : byArray.length);
        }
        n2 += 128;
        if (string2 == null) {
            NetworkToJavaConverter.shortTobyteArray((short)0, byArray2, n2);
        } else {
            System.arraycopy(byArray, 0, byArray2, n2, (byArray = string2.getBytes()).length >= 32 ? 32 : byArray.length);
        }
        n2 += 32;
        if (string3 == null) {
            NetworkToJavaConverter.shortTobyteArray((short)0, byArray2, n2);
        } else {
            System.arraycopy(byArray, 0, byArray2, n2, (byArray = string3.getBytes()).length >= 32 ? 32 : byArray.length);
        }
        n2 += 32;
        this.setSysHealthDataInBuff(this.getSystemHealth(), byArray2, 194);
        n2 = 210;
        byArray2[n2] = this.systemType;
        ++n2;
        if (string4 == null) {
            NetworkToJavaConverter.shortTobyteArray((short)0, byArray2, n2);
        } else {
            byArray = string4.getBytes();
            System.out.println("Hostname len==" + byArray.length);
            System.arraycopy(byArray, 0, byArray2, n2, byArray.length >= 32 ? 32 : byArray.length);
        }
        System.arraycopy(Locale.getDefault().getLanguage().getBytes(), 0, byArray2, n2 += 32, 2);
        System.arraycopy(mSM_CLUSTERS_INFO.getbytearray(), 0, byArray2, n2 += 2, mSM_CLUSTERS_INFO.getbytearray().length);
        pluginDataInfo.setBuffer(byArray2);
        return true;
    }

    private void setSysHealthDataInBuff(SL_SYSTEM_HEALTH_T sL_SYSTEM_HEALTH_T, byte[] byArray, int n) {
        if (sL_SYSTEM_HEALTH_T == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        SL_CTRL_HEALTH_T[] sL_CTRL_HEALTH_TArray = sL_SYSTEM_HEALTH_T.getctrlHealth();
        for (int i = 0; i < sL_SYSTEM_HEALTH_T.getctrlCount(); ++i) {
            n3 += sL_CTRL_HEALTH_TArray[i].getldOptimalCount();
            n4 += sL_CTRL_HEALTH_TArray[i].getldOfflineCount();
            n5 += sL_CTRL_HEALTH_TArray[i].getldCriticalCount();
        }
        n2 = n3 + n4 + n5;
        NetworkToJavaConverter.intToByteArray(n2, byArray, n);
        NetworkToJavaConverter.intToByteArray(n3, byArray, n += 4);
        NetworkToJavaConverter.intToByteArray(n4, byArray, n += 4);
        NetworkToJavaConverter.intToByteArray(n5, byArray, n += 4);
    }

    private synchronized ArrayList<MR_CTRL_INFO> getControllerinformation() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<MR_CTRL_INFO> arrayList2 = new ArrayList<MR_CTRL_INFO>();
        PluginInfo pluginInfo = PluginManager.getPluginInfo(1, 2);
        if (pluginInfo != null) {
            PluginInterface pluginInterface = PluginManager.getPluginInterface(1, 2);
            NetworkDataPacket networkDataPacket = new NetworkDataPacket(new SimpleCommandPacket(0, 3, 0, 68).getByteArray());
            PluginDataInfo pluginDataInfo = new PluginDataInfo();
            pluginDataInfo.setSenderWWN(this.pluginInfo.getWWN());
            pluginDataInfo.setReceiverWWN(pluginInfo.getWWN());
            pluginDataInfo.setBuffer(networkDataPacket.getDataBuffer());
            if (pluginInterface != null) {
                int n;
                try {
                    boolean bl = pluginInterface.processCommand(pluginDataInfo);
                    this.dataBuff = pluginDataInfo.getBuffer();
                    int n2 = NetworkToJavaConverter.byteArrayToInt(this.dataBuff, 0);
                    int n3 = NetworkToJavaConverter.byteArrayToUnsignedShort(this.dataBuff, 44);
                    System.out.println("Number of Controller Found = " + n3);
                    for (n = 0; n < n3; ++n) {
                        int n4 = NetworkToJavaConverter.byteArrayToInt(this.dataBuff, 48 + n * 4);
                        arrayList.add(n4);
                        System.out.println("Controller ID =" + n4);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    NetworkDataPacket networkDataPacket2 = new NetworkDataPacket(new SimpleCommandPacket(1, 0, (Integer)iterator.next(), 2048).getByteArray());
                    PluginDataInfo pluginDataInfo2 = new PluginDataInfo();
                    pluginDataInfo2.setSenderWWN(this.pluginInfo.getWWN());
                    pluginDataInfo2.setReceiverWWN(pluginInfo.getWWN());
                    pluginDataInfo2.setBuffer(networkDataPacket2.getDataBuffer());
                    try {
                        n = pluginInterface.processCommand(pluginDataInfo2) ? 1 : 0;
                        byte[] byArray = pluginDataInfo2.getBuffer();
                        byte[] byArray2 = new byte[2048];
                        System.arraycopy(byArray, 44, byArray2, 0, byArray2.length);
                        this.mrControllerInfo = new MR_CTRL_INFO(byArray2, 0);
                        arrayList2.add(this.mrControllerInfo);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        return arrayList2;
    }

    private SL_SYSTEM_HEALTH_T getSystemHealth() {
        PluginInfo pluginInfo = PluginManager.getPluginInfo(1, 3);
        PluginInterface pluginInterface = PluginManager.getPluginInterface(1, 3);
        if (pluginInfo == null || pluginInterface == null) {
            return this.getMRSystemHealth();
        }
        PluginDataInfo pluginDataInfo = new PluginDataInfo();
        pluginDataInfo.setSenderWWN(this.pluginInfo.getWWN());
        pluginDataInfo.setReceiverWWN(pluginInfo.getWWN());
        pluginDataInfo.setBuffer(new SimpleCommandPacket(0, 5, 0, 33124).getByteArray());
        boolean bl = pluginInterface.processCommand(pluginDataInfo);
        byte[] byArray = pluginDataInfo.getBuffer();
        int n = NetworkToJavaConverter.byteArrayToInt(byArray);
        if (bl && n == 0) {
            SL_SYSTEM_HEALTH_T sL_SYSTEM_HEALTH_T = new SL_SYSTEM_HEALTH_T(byArray, 44);
            this.ctrlCount = sL_SYSTEM_HEALTH_T.getctrlCount();
            SL_CTRL_HEALTH_T[] sL_CTRL_HEALTH_TArray = sL_SYSTEM_HEALTH_T.getctrlHealth();
            for (int i = 0; i < this.ctrlCount; ++i) {
                if (sL_CTRL_HEALTH_TArray[i].getldCriticalCount() <= 0 && sL_CTRL_HEALTH_TArray[i].getldOfflineCount() <= 0) continue;
                return sL_SYSTEM_HEALTH_T;
            }
        }
        return this.getMRSystemHealth();
    }

    private SL_SYSTEM_HEALTH_T getMRSystemHealth() {
        PluginInfo pluginInfo = PluginManager.getPluginInfo(1, 2);
        PluginInterface pluginInterface = PluginManager.getPluginInterface(1, 2);
        if (pluginInfo == null || pluginInterface == null) {
            return null;
        }
        PluginDataInfo pluginDataInfo = new PluginDataInfo();
        pluginDataInfo.setSenderWWN(this.pluginInfo.getWWN());
        pluginDataInfo.setReceiverWWN(pluginInfo.getWWN());
        pluginDataInfo.setBuffer(new SimpleCommandPacket(0, 5, 0, 33124).getByteArray());
        boolean bl = pluginInterface.processCommand(pluginDataInfo);
        byte[] byArray = pluginDataInfo.getBuffer();
        int n = NetworkToJavaConverter.byteArrayToInt(byArray);
        if (bl && n == 0) {
            SL_SYSTEM_HEALTH_T sL_SYSTEM_HEALTH_T = new SL_SYSTEM_HEALTH_T(byArray, 44);
            return sL_SYSTEM_HEALTH_T;
        }
        return null;
    }

    private byte getSystemType() {
        return 0;
    }

    @Override
    public boolean processCommand(PluginDataInfo pluginDataInfo) {
        int n = NetworkToJavaConverter.byteArrayToInt(pluginDataInfo.getBuffer());
        switch (n) {
            case 1: {
                return this.getSystemInformation(pluginDataInfo);
            }
        }
        return false;
    }

    @Override
    public void shutdown() {
    }

    public static String getLocalHostName() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            int n;
            String string = unknownHostException.getMessage();
            if (string != null && (n = string.indexOf(58)) > 0) {
                return string.substring(0, n);
            }
            throw unknownHostException;
        }
    }

    public static String getOSArch() {
        boolean bl;
        String string = System.getProperty("os.arch");
        boolean bl2 = bl = System.getProperty("os.arch").toUpperCase().contains("SPARC") || System.getProperty("os.name").toUpperCase().contains("WINDOWS");
        if (!bl) {
            try {
                string = SystemInfo.getLOSarch();
            }
            catch (Exception exception) {
                System.out.println("Exception in getting OS architecture for non Windows OS");
            }
        }
        try {
            if (System.getProperty("os.name").contains("Windows") && System.getenv("ProgramFiles(x86)") != null) {
                string = ARCH64TEXT;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public static String getOSName() {
        String string = System.getProperty("os.name");
        try {
            if (System.getProperty("os.name").contains("Windows Vista") && System.getProperty("os.version").contains("6.1")) {
                string = "Windows 7";
            }
            if (System.getProperty("os.name").contains("Windows NT") && System.getProperty("os.version").contains("6.2")) {
                string = "Windows 8";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public static String getLOSarch() throws Exception {
        int n;
        String string = "arch";
        Process process = Runtime.getRuntime().exec(string);
        InputStream inputStream = process.getInputStream();
        String string2 = "";
        while ((n = inputStream.read()) != 10) {
            string2 = string2 + (char)n;
        }
        inputStream.close();
        return string2;
    }

    @Override
    public void preShutdown() {
    }

    @Override
    public void startupOperations() {
    }
}

