/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import Framework.Network.NetworkManager;
import Services.NetworkToJavaConverter;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import plugins.NetworkCapabilityPlugin;

class TCPConfirmer
extends Thread {
    private static volatile ServerSocket servSoc;
    static final int SIGNATURE = 1111;

    TCPConfirmer() {
    }

    @Override
    public void run() {
        TCPConfirmer.startListen();
    }

    static void startListen() {
        try {
            servSoc = new ServerSocket(NetworkManager.getAFreePort());
            while (NetworkCapabilityPlugin.continueRun) {
                Socket socket = servSoc.accept();
                if (!NetworkCapabilityPlugin.continueRun) break;
                DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                byte[] byArray = new byte[4];
                dataInputStream.readFully(byArray);
                if (NetworkToJavaConverter.byteArrayToInt(byArray) != servSoc.getLocalPort()) continue;
                NetworkToJavaConverter.intToByteArray(1111, byArray);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream(), byArray.length);
                bufferedOutputStream.write(byArray);
                bufferedOutputStream.flush();
                dataInputStream.close();
                bufferedOutputStream.close();
                socket.close();
            }
            servSoc.close();
        }
        catch (IOException iOException) {
            System.out.println("IO exception in TCP confirmer::" + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    static int getServerSocketPort() {
        return servSoc == null ? 0 : servSoc.getLocalPort();
    }

    static boolean isRemoteFrameworkReallyDead(InetAddress inetAddress, int n) {
        try {
            Socket socket = new Socket(inetAddress, n);
            socket.setSoTimeout(5000);
            byte[] byArray = new byte[4];
            NetworkToJavaConverter.intToByteArray(n, byArray);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream(), byArray.length);
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
            dataInputStream.readFully(byArray);
            if (NetworkToJavaConverter.byteArrayToInt(byArray) == 1111) {
                dataInputStream.close();
                socket.close();
                return false;
            }
            dataInputStream.close();
            socket.close();
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    static void stopRun() {
        try {
            Socket socket = new Socket("127.0.0.1", servSoc.getLocalPort());
            socket.setSoTimeout(5000);
            byte[] byArray = new byte[2];
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream(), byArray.length);
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Exiting TCPConfirmer...");
    }
}

