/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import plugins.AlertAction;
import plugins.AlertEventDetails;
import plugins.AlertSeverity;
import plugins.AlertsConfigData;
import plugins.AlertsGlobalConfig;

public class XMLParser {
    private DocumentBuilder builder = null;
    private Document document = null;
    private AlertsConfigData theConfig = null;

    public XMLParser() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            this.builder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    public void parse(InputStream inputStream) {
        try {
            this.document = this.builder.parse(inputStream);
            System.out.println("Config file name -> " + inputStream);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.document != null) {
            this.treatDocument();
        }
    }

    public AlertsConfigData getConfig() {
        return this.theConfig;
    }

    private void treatDocument() {
        int n = this.document.getChildNodes().getLength();
        for (int i = 0; i < n; ++i) {
            Node node = this.document.getChildNodes().item(i);
            if (!node.getNodeName().equals("monitor-config") || node.getNodeType() != 1) continue;
            this.treatConfig(node);
        }
    }

    public void treatConfig(Node node) {
        if (node != null) {
            this.theConfig = new AlertsConfigData();
            int n = node.getChildNodes().getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = node.getChildNodes().item(i);
                if (node2.getNodeType() != 1) continue;
                if (node2.getNodeName().equals("actions")) {
                    this.treatActions(node2);
                }
                if (node2.getNodeName().equals("global")) {
                    this.treatGlobals(node2);
                }
                if (!node2.getNodeName().equals("events")) continue;
                this.treatEvents(node2);
            }
        }
    }

    private void treatActions(Node node) {
        int n = node.getChildNodes().getLength();
        for (int i = 0; i < n; ++i) {
            AlertAction alertAction;
            Node node2 = node.getChildNodes().item(i);
            if (node2.getNodeType() != 1 || (alertAction = this.treatAction(node2)) == null) continue;
            this.theConfig.addAction(alertAction, alertAction.getName());
        }
    }

    private AlertAction treatAction(Node node) {
        String string = node.getNodeName();
        AlertAction alertAction = new AlertAction(string);
        int n = node.getChildNodes().getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = node.getChildNodes().item(i);
            if (node2.getNodeType() != 1) continue;
            this.treatParams(node2, alertAction);
        }
        return alertAction;
    }

    private void treatParams(Node node, AlertAction alertAction) {
        String string = node.getNodeName();
        ArrayList<String> arrayList = alertAction.getParam(string);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            alertAction.setParam(string, arrayList);
        }
        int n = node.getChildNodes().getLength();
        String string2 = null;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Node node2 = node.getChildNodes().item(i);
            if (node2.getNodeType() != 3) continue;
            bl = true;
            string2 = node2.getNodeValue();
        }
        if (bl) {
            arrayList.add(string2);
        } else {
            arrayList.add("");
        }
    }

    private void treatGlobals(Node node) {
        int n = node.getChildNodes().getLength();
        for (int i = 0; i < n; ++i) {
            AlertsGlobalConfig alertsGlobalConfig;
            Node node2 = node.getChildNodes().item(i);
            if (node2.getNodeType() != 1 || (alertsGlobalConfig = this.treatGlobal(node2)) == null) continue;
            this.theConfig.addGlobal(alertsGlobalConfig, alertsGlobalConfig.getSeverity());
        }
    }

    private AlertsGlobalConfig treatGlobal(Node node) {
        String string;
        String string2;
        Node node2;
        int n;
        int n2 = node.getAttributes().getLength();
        AlertsGlobalConfig alertsGlobalConfig = null;
        for (n = 0; n < n2; ++n) {
            node2 = node.getAttributes().item(n);
            if (node2.getNodeType() != 2 || !(string2 = node2.getNodeName()).equals("level")) continue;
            string = node2.getNodeValue();
            int n3 = AlertSeverity.getSeverityId(string);
            if (n3 >= 0) {
                alertsGlobalConfig = new AlertsGlobalConfig(n3);
                continue;
            }
            return alertsGlobalConfig;
        }
        n2 = node.getChildNodes().getLength();
        for (n = 0; n < n2; ++n) {
            AlertAction alertAction;
            node2 = node.getChildNodes().item(n);
            if (node2.getNodeType() != 1 || (alertAction = this.theConfig.getAction(string = (string2 = node2.getNodeName()).substring(3))) == null || alertsGlobalConfig == null) continue;
            alertsGlobalConfig.addAction(alertAction);
        }
        return alertsGlobalConfig;
    }

    private void treatEvents(Node node) {
        int n = node.getChildNodes().getLength();
        for (int i = 0; i < n; ++i) {
            AlertEventDetails alertEventDetails;
            Node node2 = node.getChildNodes().item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals("event") || (alertEventDetails = this.treatEvent(node2)) == null) continue;
            this.theConfig.addAlertEvent(alertEventDetails);
        }
    }

    private AlertEventDetails treatEvent(Node node) {
        String string;
        String string2;
        Node node2;
        int n;
        int n2 = node.getAttributes().getLength();
        AlertEventDetails alertEventDetails = null;
        int n3 = -1;
        int n4 = -1;
        for (n = 0; n < n2; ++n) {
            node2 = node.getAttributes().item(n);
            if (node2.getNodeType() != 2) continue;
            string2 = node2.getNodeName();
            if (string2.equals("id") && (string = node2.getNodeValue()) != null) {
                n3 = Integer.valueOf(string);
            }
            if (!string2.equals("severity")) continue;
            string = node2.getNodeValue();
            n4 = AlertSeverity.getSeverityId(string);
        }
        if (n3 < 0 || n4 < 0) {
            return alertEventDetails;
        }
        alertEventDetails = new AlertEventDetails(n3, n4);
        n2 = node.getChildNodes().getLength();
        for (n = 0; n < n2; ++n) {
            AlertAction alertAction;
            node2 = node.getChildNodes().item(n);
            if (node2.getNodeType() != 1) continue;
            string2 = node2.getNodeName();
            if (string2.equals("apply-global")) {
                alertEventDetails.setUseGlobals(true);
            }
            if ((alertAction = this.theConfig.getAction(string = string2.substring(3))) == null) continue;
            alertEventDetails.addAction(alertAction);
        }
        return alertEventDetails;
    }
}

