#!/bin/bash
### BEGIN INIT INFO
# Provides:          tp-conf-hostname
# Required-Start:    $network $named $local_fs
# Required-Stop:
# Default-Start:     S
# Default-Stop:      
# X-Start-Before:    exim4
# Short-Description: Configures the hostname using the reverse IP
# Description: Apenas tem utilidade nos laboratários do Taguspark
#              sobre gestão do CIIST-TP.  Ou seja, não quer instalar 
#              este pacote a menos para fazer investigação sobre pacotes 
#              Debian.  
### END INIT INFO

# PATH should only include /usr/* if it runs after the mountnfs.sh script
PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DESC="Setting up hostname"    # Introduce a short description here
NAME=tp-conf-hostname         # Introduce the short server's name here
SCRIPTNAME=/etc/init.d/$NAME

# Load the VERBOSE setting and other rcS variables
. /lib/init/vars.sh

# Define LSB log_* functions.
# Depend on lsb-base (>= 3.0-6) to ensure that this file is present.
. /lib/lsb/init-functions

function check_interface {
    if ! ifconfig $1 ; then
	echo "Nao existe a interface $1" 
	return 1
    fi
    ifconfig $1 | grep "inet addr"
    if [ ! $? ] ; then
	echo "Interface $1 nao tem IP"
	return 1
    fi
}

function change_hostname {
    FHN=$1
    hostname $FHN
    echo $FHN > /etc/hostname
    echo $FHN > /etc/mailname
    #echo -e "exim4-config    exim4/dc_other_hostnames  string  $HN:$FHN" | debconf-set-selections
    dpkg-reconfigure -phigh -u exim4-config
    #DEBCONF_DEBUG=developer dpkg-reconfigure exim4-config
}


#
# Function that starts the daemon/service
#
do_start()
{
	# Return
	#   0 if daemon has been started
	#   1 if daemon was already running
	#   2 if daemon could not be started
	if ! check_interface eth0 ; then
	    exit 2
	fi
	IP=`ifconfig eth0 | grep "inet addr" | awk '{print $2}' | cut -b6- `
	echo $IP
	FHN=`host -t PTR $IP | awk '{print $5 }'`
	if echo $FHN | grep "tagus.ist.utl.pt" ; then
	    FHN=${FHN%.}
	    HN=`echo $FHN | cut -d. -f1`
	    echo $HN
	    change_hostname $FHN
	else
	    echo -n "Nao encontro um nome apropriado"
	    if [ `hostname` == "p4-022.tagus.ist.utl.pt" -o \
                 `hostname` == "p4-027.tagus.ist.utl.pt" -o \
		 `hostname` == "p4-228.tagus.ist.utl.pt" -o \
		 `hostname` == "p4-231.tagus.ist.utl.pt" ] ; then 
		echo " mudando para um nome genérico"
		change_hostname p4-xxx.tagus.ist.utl.pt
	    else
		echo " deixando o nome anterior"
	    fi
	fi
	# Add code here, if necessary, that waits for the process to be ready
	# to handle requests from services started subsequently which depend
	# on this one.  As a last resort, sleep for some time.
}


case "$1" in
    start|reload|restart|force-reload)
	[ "$VERBOSE" != no ] && log_daemon_msg "Starting $DESC " "$NAME"
	do_start
	case "$?" in
	    0|1) [ "$VERBOSE" != no ] && log_end_msg 0 ;;
	    2) [ "$VERBOSE" != no ] && log_end_msg 1 ;;
	esac
	;;
    stop)
	#Do nothing
	[ "$VERBOSE" != no ] && log_daemon_msg "Stopping $DESC" "$NAME"
	[ "$VERBOSE" != no ] && log_end_msg 0
	;;
    status)
	hostname && exit 0 || exit $?
	;;
    *)
	echo "Usage: $SCRIPTNAME {start|stop|status|restart|force-reload}" >&2
	exit 3
	;;
esac

exit 0
