/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.apache.batik.dom.svg.SVGTextContent;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;

public class SVGTextContentSupport {
    public static int getNumberOfChars(Element element) {
        SVGOMElement sVGOMElement = (SVGOMElement)((Object)element);
        return ((SVGTextContent)((Object)sVGOMElement.getSVGContext())).getNumberOfChars();
    }

    public static SVGRect getExtentOfChar(Element element, final int n) {
        final SVGOMElement sVGOMElement = (SVGOMElement)((Object)element);
        if (n < 0 || n >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        final SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return new SVGRect(){

            public float getX() {
                return (float)SVGTextContentSupport.getExtent(sVGOMElement, sVGTextContent, n).getX();
            }

            public void setX(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }

            public float getY() {
                return (float)SVGTextContentSupport.getExtent(sVGOMElement, sVGTextContent, n).getY();
            }

            public void setY(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }

            public float getWidth() {
                return (float)SVGTextContentSupport.getExtent(sVGOMElement, sVGTextContent, n).getWidth();
            }

            public void setWidth(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }

            public float getHeight() {
                return (float)SVGTextContentSupport.getExtent(sVGOMElement, sVGTextContent, n).getHeight();
            }

            public void setHeight(float f) throws DOMException {
                throw sVGOMElement.createDOMException((short)7, "readonly.rect", null);
            }
        };
    }

    protected static Rectangle2D getExtent(SVGOMElement sVGOMElement, SVGTextContent sVGTextContent, int n) {
        Rectangle2D rectangle2D = sVGTextContent.getExtentOfChar(n);
        if (rectangle2D == null) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        return rectangle2D;
    }

    public static SVGPoint getStartPositionOfChar(Element element, final int n) throws DOMException {
        SVGOMElement sVGOMElement = (SVGOMElement)((Object)element);
        if (n < 0 || n >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        final SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return new SVGTextPoint(sVGOMElement){

            public float getX() {
                return (float)SVGTextContentSupport.getStartPos(this.svgelt, sVGTextContent, n).getX();
            }

            public float getY() {
                return (float)SVGTextContentSupport.getStartPos(this.svgelt, sVGTextContent, n).getY();
            }
        };
    }

    protected static Point2D getStartPos(SVGOMElement sVGOMElement, SVGTextContent sVGTextContent, int n) {
        Point2D point2D = sVGTextContent.getStartPositionOfChar(n);
        if (point2D == null) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        return point2D;
    }

    public static SVGPoint getEndPositionOfChar(Element element, final int n) throws DOMException {
        SVGOMElement sVGOMElement = (SVGOMElement)((Object)element);
        if (n < 0 || n >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        final SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return new SVGTextPoint(sVGOMElement){

            public float getX() {
                return (float)SVGTextContentSupport.getEndPos(this.svgelt, sVGTextContent, n).getX();
            }

            public float getY() {
                return (float)SVGTextContentSupport.getEndPos(this.svgelt, sVGTextContent, n).getY();
            }
        };
    }

    protected static Point2D getEndPos(SVGOMElement sVGOMElement, SVGTextContent sVGTextContent, int n) {
        Point2D point2D = sVGTextContent.getEndPositionOfChar(n);
        if (point2D == null) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        return point2D;
    }

    public static void selectSubString(Element element, int n, int n2) {
        SVGOMElement sVGOMElement = (SVGOMElement)((Object)element);
        if (n < 0 || n >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        sVGTextContent.selectSubString(n, n2);
    }

    public static float getRotationOfChar(Element element, int n) {
        SVGOMElement sVGOMElement = (SVGOMElement)((Object)element);
        if (n < 0 || n >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return sVGTextContent.getRotationOfChar(n);
    }

    public static float getComputedTextLength(Element element) {
        SVGOMElement sVGOMElement = (SVGOMElement)((Object)element);
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return sVGTextContent.getComputedTextLength();
    }

    public static float getSubStringLength(Element element, int n, int n2) {
        SVGOMElement sVGOMElement = (SVGOMElement)((Object)element);
        if (n < 0 || n >= SVGTextContentSupport.getNumberOfChars(element)) {
            throw sVGOMElement.createDOMException((short)1, "", null);
        }
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return sVGTextContent.getSubStringLength(n, n2);
    }

    public static int getCharNumAtPosition(Element element, float f, float f2) throws DOMException {
        SVGOMElement sVGOMElement = (SVGOMElement)((Object)element);
        SVGTextContent sVGTextContent = (SVGTextContent)((Object)sVGOMElement.getSVGContext());
        return sVGTextContent.getCharNumAtPosition(f, f2);
    }

    public static class SVGTextPoint
    extends SVGOMPoint {
        SVGOMElement svgelt;

        SVGTextPoint(SVGOMElement sVGOMElement) {
            this.svgelt = sVGOMElement;
        }

        public void setX(float f) throws DOMException {
            throw this.svgelt.createDOMException((short)7, "readonly.point", null);
        }

        public void setY(float f) throws DOMException {
            throw this.svgelt.createDOMException((short)7, "readonly.point", null);
        }
    }
}

