%% The contents of this file are subject to the Mozilla Public License
%% Version 1.1 (the "License"); you may not use this file except in
%% compliance with the License. You may obtain a copy of the License at
%% http://www.mozilla.org/MPL/
%%
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
%% License for the specific language governing rights and limitations
%% under the License.
%%
%% The Original Code is RabbitMQ.
%%
%% The Initial Developer of the Original Code is GoPivotal, Inc.
%% Copyright (c) 2007-2016 Pivotal Software, Inc.  All rights reserved.
%%

%% @private
-module(amqp_sup).

-include("amqp_client.hrl").

-behaviour(supervisor2).

-export([start_link/0, is_ready/0, start_connection_sup/1]).
-export([init/1]).

%%---------------------------------------------------------------------------
%% Interface
%%---------------------------------------------------------------------------

start_link() ->
    supervisor2:start_link({local, amqp_sup}, ?MODULE, []).

is_ready() ->
    whereis(amqp_sup) =/= undefined.

start_connection_sup(AmqpParams) ->
    supervisor2:start_child(amqp_sup, [AmqpParams]).

%%---------------------------------------------------------------------------
%% supervisor2 callbacks
%%---------------------------------------------------------------------------

init([]) ->
    {ok, {{simple_one_for_one, 0, 1},
          [{connection_sup, {amqp_connection_sup, start_link, []},
           temporary, infinity, supervisor, [amqp_connection_sup]}]}}.
